/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FoldGenerator {
    public void generate(String inputFilename, int folds, String foldsFolder, boolean addTestSet) throws Exception {
        String line;
        PrintStream[] trainingFiles = new PrintStream[folds];
        PrintStream[] validationFiles = new PrintStream[folds];
        PrintStream[] testFiles = addTestSet ? new PrintStream[folds] : null;
        for (int f = 0; f < folds; ++f) {
            String curFolder = foldsFolder + "/Fold" + (f + 1) + "/";
            new File(curFolder).mkdirs();
            trainingFiles[f] = new PrintStream(curFolder + "train.txt");
            validationFiles[f] = new PrintStream(curFolder + "valid.txt");
            if (!addTestSet) continue;
            testFiles[f] = new PrintStream(curFolder + "test.txt");
        }
        BufferedReader reader = new BufferedReader(new FileReader(new File(inputFilename)));
        ArrayList<Integer> instanceIds = new ArrayList<Integer>();
        int curId = 0;
        while ((line = reader.readLine()) != null) {
            instanceIds.add(curId);
            if (++curId % 10000 != 0) continue;
            System.out.println("Loaded " + curId + " lines.");
        }
        reader.close();
        Collections.shuffle(instanceIds);
        ArrayList partitions = new ArrayList();
        for (int f = 0; f < folds; ++f) {
            partitions.add(new ArrayList());
        }
        HashMap<Integer, Integer> instanceId2partition = new HashMap<Integer, Integer>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            int qid = (Integer)instanceIds.get(i);
            int partition = i % folds;
            ((List)partitions.get(partition)).add(qid);
            instanceId2partition.put(qid, partition);
        }
        curId = 0;
        reader = new BufferedReader(new FileReader(new File(inputFilename)));
        while ((line = reader.readLine()) != null) {
            int partition = (Integer)instanceId2partition.get(curId);
            for (int f = 0; f < folds; ++f) {
                if (addTestSet) {
                    if (f % folds == partition) {
                        validationFiles[f].println(line);
                        continue;
                    }
                    if ((f + 1) % folds == partition) {
                        testFiles[f].println(line);
                        continue;
                    }
                    trainingFiles[f].println(line);
                    continue;
                }
                if (f % folds == partition) {
                    validationFiles[f].println(line);
                    continue;
                }
                trainingFiles[f].println(line);
            }
            if (++curId % 10000 != 0) continue;
            System.out.println("Dumped " + curId + " lines.");
        }
        reader.close();
        for (int f = 0; f < folds; ++f) {
            trainingFiles[f].close();
            validationFiles[f].close();
        }
    }
}

