/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class Categorical2NumericalCsvConvertor {
    Map<Integer, Map<String, Integer>> perFeatureMappings;

    private int getOrdinal(String value, int fIdx) {
        Integer ordinal;
        Map<String, Integer> featureMap = this.perFeatureMappings.get(fIdx);
        if (featureMap == null) {
            featureMap = new HashMap<String, Integer>();
            this.perFeatureMappings.put(fIdx, featureMap);
        }
        if ((ordinal = featureMap.get(value)) == null) {
            int maxOrdinal = 0;
            for (int curOrdinal : featureMap.values()) {
                if (curOrdinal <= maxOrdinal) continue;
                maxOrdinal = curOrdinal;
            }
            ordinal = maxOrdinal + 1;
            featureMap.put(value, ordinal);
        }
        return ordinal;
    }

    public void convert(String inputFilename, String outputFilename, boolean hasHeader) {
        try {
            int columnCount;
            File outputFile = new File(outputFilename);
            if (outputFile.exists()) {
                System.out.println("File: " + outputFilename + " already exists. Skipping it.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(new File(inputFilename)));
            PrintStream output = new PrintStream(outputFile);
            String line = reader.readLine();
            String header = null;
            if (hasHeader) {
                header = line;
                line = reader.readLine();
                columnCount = header.split(",").length;
                output.println(header);
            } else {
                String firstLine = line;
                if (firstLine.indexOf(35) >= 0) {
                    firstLine = firstLine.substring(0, firstLine.indexOf(35));
                }
                columnCount = firstLine.split(",").length;
            }
            StringBuilder sb = new StringBuilder();
            int lineCount = 0;
            int curSize = 0;
            this.perFeatureMappings = new HashMap<Integer, Map<String, Integer>>();
            do {
                String comment;
                int commentStartIdx;
                if ((commentStartIdx = line.indexOf(35)) >= 0) {
                    comment = line.substring(commentStartIdx + 1).trim();
                    line = line.substring(0, commentStartIdx).trim();
                } else {
                    comment = null;
                }
                String[] parts = line.split(",");
                for (int f = 1; f <= columnCount; ++f) {
                    if (f > 1) {
                        sb.append(",");
                    }
                    try {
                        Double.parseDouble(parts[f - 1]);
                        sb.append(parts[f - 1]);
                        continue;
                    }
                    catch (Exception e) {
                        sb.append(this.getOrdinal(parts[f - 1], f));
                    }
                }
                if (comment != null) {
                    sb.append(" # " + comment);
                }
                sb.append("\n");
                if (++curSize == 10000) {
                    output.print(sb.toString());
                    curSize = 0;
                    sb.setLength(0);
                }
                if (++lineCount % 10000 != 0) continue;
                System.out.print("\rProcessed lines: " + lineCount);
            } while ((line = reader.readLine()) != null);
            if (curSize > 0) {
                output.print(sb.toString());
            }
            System.out.println();
            reader.close();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

