/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.sample;

import edu.uci.jforests.dataset.RankingDataset;
import edu.uci.jforests.eval.ranking.RankingEvaluationMetric;
import edu.uci.jforests.sample.Sample;
import edu.uci.jforests.util.ArraysUtil;
import edu.uci.jforests.util.Constants;
import edu.uci.jforests.util.FloatingPointUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class RankingSample
extends Sample {
    public int numQueries;
    public int[] queryBoundaries;
    public int[] queryIndices;

    public RankingSample(RankingDataset dataset) {
        super(dataset);
        this.queryBoundaries = dataset.queryBoundaries;
        this.numQueries = this.queryBoundaries.length - 1;
        this.queryIndices = new int[this.numQueries];
        for (int q = 0; q < this.numQueries; ++q) {
            this.queryIndices[q] = q;
        }
        this.indicesInParentSample = null;
    }

    public RankingSample(RankingDataset dataset, int[] queryIndices, int[] queryBoundaries, int[] instances, double[] weights, double[] targets, int[] indicesInParentSample, int docCount, int queryCount) {
        super(dataset, instances, weights, targets, indicesInParentSample, docCount);
        this.queryIndices = queryIndices;
        this.queryBoundaries = queryBoundaries;
        this.numQueries = queryCount;
    }

    @Override
    public RankingSample getRandomSubSample(double rate, Random rnd) {
        if (rate < 1.0) {
            int subSampleNumQueries = (int)((double)this.numQueries * rate);
            int[] tempQueryIndices = new int[this.numQueries];
            for (int i = 0; i < this.numQueries; ++i) {
                tempQueryIndices[i] = i;
            }
            ArraysUtil.shuffle(tempQueryIndices, rnd);
            Arrays.sort(tempQueryIndices, 0, subSampleNumQueries);
            int[] subSampleQueryBoundaries = new int[subSampleNumQueries + 1];
            int subSampleSize = 0;
            for (int idx = 0; idx < subSampleNumQueries; ++idx) {
                int f = tempQueryIndices[idx];
                subSampleSize += this.queryBoundaries[f + 1] - this.queryBoundaries[f];
            }
            int[] sampleIndicesInDataset = new int[subSampleSize];
            double[] sampleWeights = new double[subSampleSize];
            double[] sampleTargets = new double[subSampleSize];
            int[] sampleIndicesInParentSample = new int[subSampleSize];
            int curSampleSize = 0;
            int[] subSampleQueryIndices = new int[subSampleNumQueries];
            for (int idx = 0; idx < subSampleNumQueries; ++idx) {
                int f = tempQueryIndices[idx];
                subSampleQueryBoundaries[idx] = curSampleSize;
                int beginOffset = this.queryBoundaries[f];
                int numDocs = this.queryBoundaries[f + 1] - beginOffset;
                for (int d = 0; d < numDocs; ++d) {
                    sampleIndicesInDataset[curSampleSize] = this.indicesInDataset[beginOffset + d];
                    sampleWeights[curSampleSize] = this.weights[beginOffset + d];
                    sampleTargets[curSampleSize] = this.targets[beginOffset + d];
                    sampleIndicesInParentSample[curSampleSize] = beginOffset + d;
                    ++curSampleSize;
                }
                subSampleQueryIndices[idx] = this.queryIndices[f];
            }
            subSampleQueryBoundaries[subSampleNumQueries] = curSampleSize;
            return new RankingSample((RankingDataset)this.dataset, subSampleQueryIndices, subSampleQueryBoundaries, sampleIndicesInDataset, sampleWeights, sampleTargets, sampleIndicesInParentSample, subSampleSize, subSampleNumQueries);
        }
        RankingSample result = this.getClone();
        result.indicesInParentSample = Constants.ONE_TWO_THREE_ETC;
        return result;
    }

    public RankingSample getFilteredSubSample(List<Integer> qids) {
        int subSampleNumQueries = qids.size();
        int[] subSampleQueryBoundaries = new int[subSampleNumQueries + 1];
        int subSampleSize = 0;
        for (int idx = 0; idx < subSampleNumQueries; ++idx) {
            int q = qids.get(idx) - 1;
            subSampleSize += this.queryBoundaries[q + 1] - this.queryBoundaries[q];
        }
        int[] sampleIndicesInDataset = new int[subSampleSize];
        double[] sampleWeights = new double[subSampleSize];
        double[] sampleTargets = new double[subSampleSize];
        int[] sampleIndicesInParentSample = new int[subSampleSize];
        int curSampleSize = 0;
        int[] subSampleQueryIndices = new int[subSampleNumQueries];
        for (int idx = 0; idx < subSampleNumQueries; ++idx) {
            int q = qids.get(idx) - 1;
            subSampleQueryBoundaries[idx] = curSampleSize;
            int beginOffset = this.queryBoundaries[q];
            int numDocs = this.queryBoundaries[q + 1] - beginOffset;
            for (int d = 0; d < numDocs; ++d) {
                sampleIndicesInDataset[curSampleSize] = this.indicesInDataset[beginOffset + d];
                sampleWeights[curSampleSize] = this.weights[beginOffset + d];
                sampleTargets[curSampleSize] = this.targets[beginOffset + d];
                sampleIndicesInParentSample[curSampleSize] = beginOffset + d;
                ++curSampleSize;
            }
            subSampleQueryIndices[idx] = this.queryIndices[q];
        }
        subSampleQueryBoundaries[subSampleNumQueries] = curSampleSize;
        return new RankingSample((RankingDataset)this.dataset, subSampleQueryIndices, subSampleQueryBoundaries, sampleIndicesInDataset, sampleWeights, sampleTargets, sampleIndicesInParentSample, subSampleSize, subSampleNumQueries);
    }

    public RankingSample getOutOfSample(List<Integer> qids) {
        ArrayList<Integer> oosQids = new ArrayList<Integer>();
        for (int q = 0; q < this.numQueries; ++q) {
            if (qids.contains(q + 1)) continue;
            oosQids.add(q + 1);
        }
        return this.getFilteredSubSample(oosQids);
    }

    private int addQueryWithDocSampling(int oldSampleQueryIdx, int newSampleQueryIdx, double rate, int curSampleSize, int[] sampleIndicesInDataset, double[] sampleWeights, double[] sampleTargets, int[] sampleIndicesInParentSample, Random rnd) {
        int beginOffset = this.queryBoundaries[oldSampleQueryIdx];
        int numDocs = this.queryBoundaries[oldSampleQueryIdx + 1] - beginOffset;
        int newDocsAdded = 0;
        int[] tmpLevelCounts = new int[5];
        for (int d = 0; d < numDocs; ++d) {
            if (!(rnd.nextDouble() <= rate)) continue;
            sampleIndicesInDataset[curSampleSize + newDocsAdded] = this.indicesInDataset[beginOffset + d];
            sampleWeights[curSampleSize + newDocsAdded] = this.weights[beginOffset + d];
            sampleTargets[curSampleSize + newDocsAdded] = this.targets[beginOffset + d];
            int n = (int)this.targets[beginOffset + d];
            tmpLevelCounts[n] = tmpLevelCounts[n] + 1;
            sampleIndicesInParentSample[curSampleSize + newDocsAdded] = beginOffset + d;
            ++newDocsAdded;
        }
        int distinctLevelCounts = 0;
        for (int k = 0; k < tmpLevelCounts.length; ++k) {
            if (tmpLevelCounts[k] <= 0) continue;
            ++distinctLevelCounts;
        }
        if (distinctLevelCounts > 1) {
            return newDocsAdded;
        }
        return 0;
    }

    public RankingSample getAugmentedSampleWithDocSampling(int times, double rate, Random rnd) {
        int newSampleMaxSize = this.size * (times + 1);
        int newSampleNumQueries = this.numQueries * (times + 1);
        int[] newSampleIndicesInDataset = new int[newSampleMaxSize];
        double[] newSampleWeights = new double[newSampleMaxSize];
        double[] newSampleTargets = new double[newSampleMaxSize];
        int[] sampleIndicesInParentSample = new int[newSampleMaxSize];
        int curSampleSize = 0;
        int[] newSampleQueryIndices = new int[newSampleNumQueries];
        int[] newSampleQueryBoundaries = new int[newSampleNumQueries];
        int newSampleQueryIdx = 0;
        for (int oldSampleQueryIdx = 0; oldSampleQueryIdx < this.numQueries; ++oldSampleQueryIdx) {
            for (int k = 0; k < times + 1; ++k) {
                int newDocsAdded = this.addQueryWithDocSampling(oldSampleQueryIdx, newSampleQueryIdx, k == 0 ? 1.0 : rate, curSampleSize, newSampleIndicesInDataset, newSampleWeights, newSampleTargets, sampleIndicesInParentSample, rnd);
                if (newDocsAdded <= 0) continue;
                newSampleQueryBoundaries[newSampleQueryIdx] = curSampleSize;
                newSampleQueryIndices[newSampleQueryIdx] = oldSampleQueryIdx;
                curSampleSize += newDocsAdded;
                ++newSampleQueryIdx;
            }
        }
        newSampleQueryBoundaries[newSampleQueryIdx] = curSampleSize;
        return new RankingSample((RankingDataset)this.dataset, newSampleQueryIndices, newSampleQueryBoundaries, newSampleIndicesInDataset, newSampleWeights, newSampleTargets, sampleIndicesInParentSample, curSampleSize, newSampleQueryIdx);
    }

    @Override
    public RankingSample getClone() {
        return new RankingSample((RankingDataset)this.dataset, this.queryIndices, this.queryBoundaries, this.indicesInDataset, this.weights, this.targets, this.indicesInParentSample, this.size, this.numQueries);
    }

    public double[] evaluateByQuery(double[] predictions, RankingEvaluationMetric evaluationMetric) throws Exception {
        return evaluationMetric.measureByQuery(predictions, this);
    }

    public RankingSample getZeroFilteredSample() {
        int[] sampleIndicesInDataset = new int[this.size];
        double[] sampleWeights = new double[this.size];
        double[] sampleTargets = new double[this.size];
        int[] sampleIndicesInParentSample = new int[this.size];
        int curSampleSize = 0;
        int subSampleNumQueries = 0;
        int[] subSampleQueryBoundaries = new int[this.queryBoundaries.length];
        int prevSampleSize = 0;
        int[] subSampleQueryIndices = new int[this.queryBoundaries.length - 1];
        for (int idx = 0; idx < this.numQueries; ++idx) {
            int beginOffset = this.queryBoundaries[idx];
            int numDocs = this.queryBoundaries[idx + 1] - beginOffset;
            for (int d = 0; d < numDocs; ++d) {
                double target = this.targets[beginOffset + d];
                if (FloatingPointUtil.equal(target, 0.0)) continue;
                sampleIndicesInDataset[curSampleSize] = this.indicesInDataset[beginOffset + d];
                sampleWeights[curSampleSize] = this.weights[beginOffset + d];
                sampleTargets[curSampleSize] = target;
                sampleIndicesInParentSample[curSampleSize] = beginOffset + d;
                ++curSampleSize;
            }
            if (curSampleSize > prevSampleSize) {
                subSampleQueryBoundaries[subSampleNumQueries] = prevSampleSize;
                subSampleQueryIndices[subSampleNumQueries] = idx;
                ++subSampleNumQueries;
            }
            prevSampleSize = curSampleSize;
        }
        subSampleQueryBoundaries[subSampleNumQueries] = curSampleSize;
        return new RankingSample((RankingDataset)this.dataset, subSampleQueryIndices, subSampleQueryBoundaries, sampleIndicesInDataset, sampleWeights, sampleTargets, sampleIndicesInParentSample, curSampleSize, subSampleNumQueries);
    }

    public Sample getRandomDocDistBiasedSubSample(double rate, Random rnd) {
        if (rate < 1.0) {
            int sampleQueries;
            int minDocsPerQuery = Integer.MAX_VALUE;
            int maxDocsPerQuery = Integer.MIN_VALUE;
            for (int q = 0; q < this.numQueries; ++q) {
                int numDocuments = this.queryBoundaries[q + 1] - this.queryBoundaries[q];
                if (numDocuments < minDocsPerQuery) {
                    minDocsPerQuery = numDocuments;
                }
                if (numDocuments <= maxDocsPerQuery) continue;
                maxDocsPerQuery = numDocuments;
            }
            int binCount = 20;
            int range = maxDocsPerQuery - minDocsPerQuery + 1;
            double binWidth = range / binCount;
            int[] bins = new int[this.numQueries];
            int[] binHist = new int[binCount];
            for (int q = 0; q < this.numQueries; ++q) {
                int numDocuments = this.queryBoundaries[q + 1] - this.queryBoundaries[q];
                bins[q] = (int)((double)(numDocuments - minDocsPerQuery) / binWidth);
                if (bins[q] == binCount) {
                    bins[q] = binCount - 1;
                }
                int n = bins[q];
                binHist[n] = binHist[n] + 1;
            }
            ArrayList<Sample.BinFreq> binFreqs = new ArrayList<Sample.BinFreq>();
            for (int i = 0; i < binCount; ++i) {
                binFreqs.add(new Sample.BinFreq(this, i, binHist[i]));
            }
            Collections.sort(binFreqs);
            int remainedQueries = sampleQueries = (int)((double)this.numQueries * rate);
            double[] perBinSampleRate = new double[binCount];
            for (int i = 0; i < binCount; ++i) {
                Sample.BinFreq binFreq = (Sample.BinFreq)binFreqs.get(i);
                int currentMax = remainedQueries / (binCount - i);
                int selectedSize = Math.min(binFreq.freq, currentMax);
                if (binFreq.freq > 0) {
                    perBinSampleRate[binFreq.bin] = (double)selectedSize / (double)binFreq.freq;
                }
                remainedQueries -= selectedSize;
            }
            boolean[] queryIsSelected = new boolean[this.numQueries];
            int sampleSize = 0;
            sampleQueries = 0;
            for (int q = 0; q < this.numQueries; ++q) {
                if (!(rnd.nextDouble() <= perBinSampleRate[bins[q]])) continue;
                queryIsSelected[q] = true;
                sampleSize += this.queryBoundaries[q + 1] - this.queryBoundaries[q];
                ++sampleQueries;
            }
            int[] sampleIndicesInDataset = new int[sampleSize];
            double[] sampleWeights = new double[sampleSize];
            double[] sampleTargets = new double[sampleSize];
            int[] sampleIndicesInParentSample = new int[sampleSize];
            int curSampleSize = 0;
            int subSampleNumQueries = 0;
            int[] subSampleQueryBoundaries = new int[sampleQueries + 1];
            int prevSampleSize = 0;
            int[] subSampleQueryIndices = new int[sampleQueries];
            for (int q = 0; q < this.numQueries; ++q) {
                if (!queryIsSelected[q]) continue;
                int beginOffset = this.queryBoundaries[q];
                int numDocs = this.queryBoundaries[q + 1] - beginOffset;
                for (int d = 0; d < numDocs; ++d) {
                    sampleIndicesInDataset[curSampleSize] = this.indicesInDataset[beginOffset + d];
                    sampleWeights[curSampleSize] = this.weights[beginOffset + d];
                    sampleTargets[curSampleSize] = this.targets[beginOffset + d];
                    sampleIndicesInParentSample[curSampleSize] = beginOffset + d;
                    ++curSampleSize;
                }
                if (curSampleSize > prevSampleSize) {
                    subSampleQueryBoundaries[subSampleNumQueries] = prevSampleSize;
                    subSampleQueryIndices[subSampleNumQueries] = q;
                    ++subSampleNumQueries;
                }
                prevSampleSize = curSampleSize;
            }
            subSampleQueryBoundaries[subSampleNumQueries] = curSampleSize;
            return new RankingSample((RankingDataset)this.dataset, subSampleQueryIndices, subSampleQueryBoundaries, sampleIndicesInDataset, sampleWeights, sampleTargets, sampleIndicesInParentSample, curSampleSize, subSampleNumQueries);
        }
        RankingSample result = this.getClone();
        result.indicesInParentSample = Constants.ONE_TWO_THREE_ETC;
        return result;
    }

    public void printDocsPerQuery() {
        for (int q = 0; q < this.numQueries; ++q) {
            int numDocs = this.queryBoundaries[q + 1] - this.queryBoundaries[q];
            System.out.println(numDocs);
        }
    }
}

