/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.regression;

import edu.uci.jforests.dataset.Dataset;
import edu.uci.jforests.learning.trees.Tree;
import edu.uci.jforests.learning.trees.TreeSplit;
import edu.uci.jforests.learning.trees.regression.RegressionTreeSplit;
import edu.uci.jforests.sample.Sample;
import edu.uci.jforests.util.ArraysUtil;

public class RegressionTree
extends Tree {
    private double[] leafOutputs;
    private double maxLeafOutput;

    public Object clone() {
        RegressionTree copy = new RegressionTree();
        super.copyTo(copy);
        copy.maxLeafOutput = this.maxLeafOutput;
        copy.leafOutputs = new double[this.leftChild.length + 1];
        System.arraycopy(this.leafOutputs, 0, copy.leafOutputs, 0, copy.leafOutputs.length);
        return copy;
    }

    public void init(int maxLeaves, double maxLeafOutput) {
        super.init(maxLeaves);
        this.leafOutputs = new double[maxLeaves];
        this.maxLeafOutput = maxLeafOutput;
    }

    private void markPresenceOfNodesInSubtree(int node, boolean[] internalNodeIsPresent, boolean[] leafIsPresent) {
        if (node < 0) {
            leafIsPresent[node ^ 0xFFFFFFFF] = true;
        } else {
            internalNodeIsPresent[node] = true;
            this.markPresenceOfNodesInSubtree(this.leftChild[node], internalNodeIsPresent, leafIsPresent);
            this.markPresenceOfNodesInSubtree(this.rightChild[node], internalNodeIsPresent, leafIsPresent);
        }
    }

    public void normalizeNodeNames() {
        int i;
        int maxNumLeaves = this.leftChild.length + 1;
        boolean[] internalNodeIsPresent = new boolean[maxNumLeaves - 1];
        boolean[] leafIsPresent = new boolean[maxNumLeaves];
        this.markPresenceOfNodesInSubtree(0, internalNodeIsPresent, leafIsPresent);
        int newLeafCount = 0;
        for (int l = 0; l < maxNumLeaves; ++l) {
            if (!leafIsPresent[l]) continue;
            ++newLeafCount;
        }
        int[] internalNodesMappingsOld2New = new int[maxNumLeaves - 1];
        int[] internalNodesMappingsNew2Old = new int[newLeafCount - 1];
        int internalIdx = 0;
        for (int i2 = 0; i2 < maxNumLeaves - 1; ++i2) {
            if (!internalNodeIsPresent[i2]) continue;
            internalNodesMappingsOld2New[i2] = internalIdx;
            internalNodesMappingsNew2Old[internalIdx] = i2;
            if (++internalIdx == newLeafCount - 1) break;
        }
        int[] leavesMappingNew2Old = new int[newLeafCount];
        int[] leavesMappingOld2New = new int[maxNumLeaves];
        int leafIdx = 0;
        for (int i3 = 0; i3 < maxNumLeaves; ++i3) {
            if (!leafIsPresent[i3]) continue;
            leavesMappingNew2Old[leafIdx] = i3;
            leavesMappingOld2New[i3] = leafIdx++;
            if (leafIdx == newLeafCount) break;
        }
        int[] newLeftChild = new int[newLeafCount - 1];
        int[] newRightChild = new int[newLeafCount - 1];
        for (i = 0; i < maxNumLeaves - 1; ++i) {
            if (!internalNodeIsPresent[i]) continue;
            int prevLeftChild = this.leftChild[i];
            newLeftChild[internalNodesMappingsOld2New[i]] = prevLeftChild < 0 ? ~leavesMappingOld2New[~prevLeftChild] : internalNodesMappingsOld2New[prevLeftChild];
            int prevRightChild = this.rightChild[i];
            newRightChild[internalNodesMappingsOld2New[i]] = prevRightChild < 0 ? ~leavesMappingOld2New[~prevRightChild] : internalNodesMappingsOld2New[prevRightChild];
        }
        for (i = 0; i < newLeafCount - 1; ++i) {
            this.leftChild[i] = newLeftChild[i];
            this.rightChild[i] = newRightChild[i];
            this.splitFeatures[i] = this.splitFeatures[internalNodesMappingsNew2Old[i]];
            this.thresholds[i] = this.thresholds[internalNodesMappingsNew2Old[i]];
        }
        for (i = 0; i < newLeafCount; ++i) {
            this.leafOutputs[i] = this.leafOutputs[leavesMappingNew2Old[i]];
        }
        this.numLeaves = newLeafCount;
    }

    public double getLeafOutput(int leaf) {
        return this.leafOutputs[leaf];
    }

    public void setLeafOutput(int leaf, double output) {
        if (this.maxLeafOutput > 0.0) {
            if (output > this.maxLeafOutput) {
                output = this.maxLeafOutput;
            } else if (output < -this.maxLeafOutput) {
                output = -this.maxLeafOutput;
            }
        }
        this.leafOutputs[leaf] = output;
    }

    public void multiplyLeafOutputs(double factor) {
        if (factor == 1.0) {
            return;
        }
        for (int l = 0; l < this.numLeaves; ++l) {
            this.setLeafOutput(l, this.leafOutputs[l] * factor);
        }
    }

    public void incrementLeafOutputs(double constant) {
        if (constant == 0.0) {
            return;
        }
        for (int l = 0; l < this.numLeaves; ++l) {
            this.setLeafOutput(l, this.leafOutputs[l] + constant);
        }
    }

    public double getOutput(Dataset dataset, int instanceIndex) {
        return this.leafOutputs[this.getLeaf(dataset, instanceIndex)];
    }

    public double[] getOutputs(Dataset dataset) {
        double[] outputs = new double[dataset.numInstances];
        for (int i = 0; i < dataset.numInstances; ++i) {
            outputs[i] = this.getOutput(dataset, i);
        }
        return outputs;
    }

    @Override
    public int split(int leaf, TreeSplit split) {
        int indexOfNewNonLeaf = super.split(leaf, split);
        RegressionTreeSplit rsplit = (RegressionTreeSplit)split;
        this.leafOutputs[leaf] = rsplit.leftOutput;
        this.leafOutputs[this.numLeaves - 1] = rsplit.rightOutput;
        return indexOfNewNonLeaf;
    }

    @Override
    public void loadCustomData(String str) throws Exception {
        this.leafOutputs = ArraysUtil.loadDoubleArrayFromLine(this.removeXmlTag(str, "LeafOutputs"), this.numLeaves);
    }

    @Override
    protected void addCustomData(String linePrefix, StringBuilder sb) {
        StringBuilder sbOutput = new StringBuilder();
        for (int n = 0; n < this.numLeaves; ++n) {
            sbOutput.append(" " + this.leafOutputs[n]);
        }
        sb.append("\n" + linePrefix + "\t<LeafOutputs>" + sbOutput.toString().trim() + "</LeafOutputs>");
    }

    @Override
    public void backfit(Sample sample) {
        int l;
        double[] sumPerLeaf = new double[this.numLeaves];
        double[] weightedCountPerLeaf = new double[this.numLeaves];
        for (int i = 0; i < sample.size; ++i) {
            int leaf;
            int n = leaf = this.getLeaf(sample.dataset, sample.indicesInDataset[i]);
            sumPerLeaf[n] = sumPerLeaf[n] + sample.targets[i] * sample.weights[i];
            int n2 = leaf;
            weightedCountPerLeaf[n2] = weightedCountPerLeaf[n2] + sample.weights[i];
        }
        boolean hasZeroCountLeaf = false;
        double[] sumPerInternalNode = new double[this.numLeaves - 1];
        int[] countPerInternalNode = new int[this.numLeaves - 1];
        for (l = 0; l < this.numLeaves; ++l) {
            if (weightedCountPerLeaf[l] > 0.0) {
                double newOutput = sumPerLeaf[l] / weightedCountPerLeaf[l];
                this.setLeafOutput(l, newOutput);
                int parent = this.getParent(~l);
                while (parent >= 0) {
                    int n = parent;
                    sumPerInternalNode[n] = sumPerInternalNode[n] + newOutput;
                    int n3 = parent;
                    countPerInternalNode[n3] = (int)((double)countPerInternalNode[n3] + weightedCountPerLeaf[l]);
                    parent = this.getParent(parent);
                }
                continue;
            }
            hasZeroCountLeaf = true;
        }
        if (hasZeroCountLeaf) {
            block3: for (l = 0; l < this.numLeaves; ++l) {
                if (weightedCountPerLeaf[l] != 0.0) continue;
                int parent = this.getParent(~l);
                while (parent >= 0) {
                    if (countPerInternalNode[parent] > 0) {
                        this.setLeafOutput(l, sumPerInternalNode[parent] / (double)countPerInternalNode[parent]);
                        continue block3;
                    }
                    parent = this.getParent(parent);
                }
            }
        }
    }
}

