/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.eval.ranking;

public class GAPEval {
    public static final int GAIN_LEVELS = 5;
    private static double[] g_cumulative = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};

    private static int[] getCountPerGrade(int[] labels) {
        int[] countPerGrade = new int[5];
        int[] nArray = labels;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int label;
            int n2 = label = nArray[i];
            countPerGrade[n2] = countPerGrade[n2] + 1;
        }
        return countPerGrade;
    }

    private static double getMaxExpectedPrecision(int[] labels) {
        int[] countPerGrade = GAPEval.getCountPerGrade(labels);
        double denom = 0.0;
        for (int i = 1; i < 5; ++i) {
            denom += (double)countPerGrade[i] * g_cumulative[i];
        }
        return denom;
    }

    public static double getGAP(int[] labels) {
        double denom = GAPEval.getMaxExpectedPrecision(labels);
        double numerator = 0.0;
        for (int n = 0; n < labels.length; ++n) {
            double sum = 0.0;
            for (int m = 0; m <= n; ++m) {
                if (labels[m] <= 0) continue;
                sum += g_cumulative[Math.min(labels[m], labels[n])];
            }
            numerator += sum / (double)(n + 1);
        }
        return numerator / denom;
    }

    public static double getDeltaGAP(int[] labels, int[][] cumulativeLabelCount, int p, int q, double maxExpectedPrecision) {
        int i;
        double numerator = 0.0;
        int label_p = labels[p];
        int label_q = labels[q];
        double sum1 = 0.0;
        double sum2 = 0.0;
        if (label_q > 0) {
            for (i = 1; i < 5; ++i) {
                if (label_q > i) {
                    if (p > 0) {
                        sum1 += (double)cumulativeLabelCount[p - 1][i] * g_cumulative[i];
                    }
                    sum2 -= (double)cumulativeLabelCount[q][i] * g_cumulative[i];
                    continue;
                }
                if (p > 0) {
                    sum1 += (double)cumulativeLabelCount[p - 1][i] * g_cumulative[label_q];
                }
                sum2 -= (double)cumulativeLabelCount[q][i] * g_cumulative[label_q];
            }
            sum1 += g_cumulative[label_q];
        }
        if (label_p > 0) {
            for (i = 1; i < 5; ++i) {
                if (label_p > i) {
                    if (p > 0) {
                        sum1 -= (double)cumulativeLabelCount[p - 1][i] * g_cumulative[i];
                    }
                    sum2 += (double)cumulativeLabelCount[q][i] * g_cumulative[i];
                    continue;
                }
                if (p > 0) {
                    sum1 -= (double)cumulativeLabelCount[p - 1][i] * g_cumulative[label_p];
                }
                sum2 += (double)cumulativeLabelCount[q][i] * g_cumulative[label_p];
            }
            sum1 -= g_cumulative[label_p];
        }
        numerator += sum1 / (double)(p + 1);
        numerator += sum2 / (double)(q + 1);
        for (int n = p + 1; n <= q - 1; ++n) {
            if (labels[n] <= 0) continue;
            double deltaQN = label_q < labels[n] ? g_cumulative[label_q] : g_cumulative[labels[n]];
            double deltaPN = label_p < labels[n] ? g_cumulative[label_p] : g_cumulative[labels[n]];
            numerator += (deltaQN - deltaPN) / (double)(n + 1);
        }
        return Math.abs(numerator) / maxExpectedPrecision;
    }

    public static double[] getMaxExpectedPrecisionForAllQueries(double[] labels, int[] boundaries, int[][] labelCounts) throws Exception {
        double[] maxExpectedPrecision = new double[boundaries.length - 1];
        for (int q = 0; q < boundaries.length - 1; ++q) {
            maxExpectedPrecision[q] = 0.0;
            for (int i = 1; i < 5; ++i) {
                int n = q;
                maxExpectedPrecision[n] = maxExpectedPrecision[n] + (double)labelCounts[q][i] * g_cumulative[i];
            }
        }
        return maxExpectedPrecision;
    }
}

