/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.eval;

import edu.uci.jforests.eval.EvaluationMetric;
import edu.uci.jforests.sample.Sample;

public class BalancedYoundenIndex
extends EvaluationMetric {
    private static final double THRESHOLD = 0.5;

    public BalancedYoundenIndex() {
        super(true);
    }

    @Override
    public double measure(double[] predictions, Sample sample) {
        int tp = 0;
        int tn = 0;
        int fn = 0;
        int fp = 0;
        for (int i = 0; i < sample.size; ++i) {
            double target = sample.targets[i];
            double pred = predictions[i];
            if (target > 0.5) {
                if (pred > 0.5) {
                    ++tp;
                    continue;
                }
                ++fn;
                continue;
            }
            if (pred > 0.5) {
                ++fp;
                continue;
            }
            ++tn;
        }
        double sensitivity = (double)tp / (double)(tp + fn);
        double specificity = (double)tn / (double)(tn + fp);
        return Math.min(sensitivity, specificity);
    }
}

