/*
 * Decompiled with CFR 0.152.
 */
package dt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Examples {
    private List<Example> examples = new LinkedList<Example>();

    public void add(String[] attributeNames, String[] attributeValues, boolean classifier) {
        this.examples.add(new Example(attributeNames, attributeValues, classifier));
    }

    public void add(Map<String, String> attributes, boolean classifier) {
        this.examples.add(new Example(attributes, classifier));
    }

    int countDecisions(String attribute, String decision) {
        int count = 0;
        for (Example e : this.examples) {
            if (!e.getAttributeValue(attribute).equals(decision)) continue;
            ++count;
        }
        return count;
    }

    public Map<String, Set<String>> extractDecisions() {
        HashMap<String, Set<String>> decisions = new HashMap<String, Set<String>>();
        for (String attribute : this.extractAttributes()) {
            decisions.put(attribute, this.extractDecisions(attribute));
        }
        return decisions;
    }

    public int countNegative(String attribute, String decision, Map<String, String> attributes) {
        return this.countClassifier(false, attribute, decision, attributes);
    }

    public int countPositive(String attribute, String decision, Map<String, String> attributes) {
        return this.countClassifier(true, attribute, decision, attributes);
    }

    public int countNegative(Map<String, String> attributes) {
        return this.countClassifier(false, attributes);
    }

    public int countPositive(Map<String, String> attributes) {
        return this.countClassifier(true, attributes);
    }

    public int count(String attribute, String decision, Map<String, String> attributes) {
        attributes = new HashMap<String, String>(attributes);
        attributes.put(attribute, decision);
        return this.count(attributes);
    }

    public int count(Map<String, String> attributes) {
        int count = 0;
        block0: for (Example e : this.examples) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                if (e.getAttributeValue(attribute.getKey()).equals(attribute.getValue())) continue;
                continue block0;
            }
            ++count;
        }
        return count;
    }

    public int countClassifier(boolean classifier, Map<String, String> attributes) {
        int count = 0;
        block0: for (Example e : this.examples) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                if (e.getAttributeValue(attribute.getKey()).equals(attribute.getValue())) continue;
                continue block0;
            }
            if (!e.matchesClass(classifier)) continue;
            ++count;
        }
        return count;
    }

    public int countClassifier(boolean classifier, String attribute, String decision, Map<String, String> attributes) {
        attributes = new HashMap<String, String>(attributes);
        attributes.put(attribute, decision);
        return this.countClassifier(classifier, attributes);
    }

    public int count() {
        return this.examples.size();
    }

    public Set<String> extractAttributes() {
        HashSet<String> attributes = new HashSet<String>();
        for (Example e : this.examples) {
            attributes.addAll(e.getAttributes());
        }
        return attributes;
    }

    private Set<String> extractDecisions(String attribute) {
        HashSet<String> decisions = new HashSet<String>();
        for (Example e : this.examples) {
            decisions.add(e.getAttributeValue(attribute));
        }
        return decisions;
    }

    class Example {
        private Map<String, String> values;
        private boolean classifier;

        public Example(String[] attributeNames, String[] attributeValues, boolean classifier) {
            assert (attributeNames.length == attributeValues.length);
            this.values = new HashMap<String, String>();
            for (int i = 0; i < attributeNames.length; ++i) {
                this.values.put(attributeNames[i], attributeValues[i]);
            }
            this.classifier = classifier;
        }

        public Example(Map<String, String> attributes, boolean classifier) {
            this.classifier = classifier;
            this.values = attributes;
        }

        public Set<String> getAttributes() {
            return this.values.keySet();
        }

        public String getAttributeValue(String attribute) {
            return this.values.get(attribute);
        }

        public boolean matchesClass(boolean classifier) {
            return classifier == this.classifier;
        }
    }
}

