/*
 * Decompiled with CFR 0.152.
 */
package dt;

import dt.Attribute;
import dt.BadDecisionException;
import dt.DecisionTree;
import dt.UnknownDecisionException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class DecisionTreeTest {
    private DecisionTree makeOne() {
        return new DecisionTree();
    }

    private DecisionTree makeOutlookTree() {
        try {
            return this.makeOne().setAttributes(new String[]{"Outlook", "Temperature", "Humidity", "Wind"}).addExample(new String[]{"Sunny", "Hot", "High", "Weak"}, false).addExample(new String[]{"Sunny", "Hot", "High", "Strong"}, false).addExample(new String[]{"Overcast", "Hot", "High", "Weak"}, true).addExample(new String[]{"Rain", "Mild", "High", "Weak"}, true).addExample(new String[]{"Rain", "Cool", "Normal", "Weak"}, true).addExample(new String[]{"Rain", "Cool", "Normal", "Strong"}, false).addExample(new String[]{"Overcast", "Cool", "Normal", "Strong"}, true).addExample(new String[]{"Sunny", "Mild", "High", "Weak"}, false).addExample(new String[]{"Sunny", "Cool", "Normal", "Weak"}, true).addExample(new String[]{"Rain", "Mild", "Normal", "Weak"}, true).addExample(new String[]{"Sunny", "Mild", "Normal", "Strong"}, true).addExample(new String[]{"Overcast", "Mild", "High", "Strong"}, true).addExample(new String[]{"Overcast", "Hot", "Normal", "Weak"}, true).addExample(new String[]{"Rain", "Mild", "High", "Strong"}, false);
        }
        catch (UnknownDecisionException e) {
            Assert.fail();
            return this.makeOne();
        }
    }

    @Test(expected=UnknownDecisionException.class)
    public void testUnknownDecisionThrowsException() throws UnknownDecisionException {
        DecisionTree tree = this.makeOne().setAttributes(new String[]{"Outlook"}).setDecisions("Outlook", new String[]{"Sunny", "Overcast"});
        tree.addExample(new String[]{"Rain"}, false);
    }

    @Test
    public void testOutlookOvercastApplyReturnsTrue() throws BadDecisionException {
        HashMap<String, String> case1 = new HashMap<String, String>();
        case1.put("Outlook", "Overcast");
        case1.put("Temperature", "Hot");
        case1.put("Humidity", "High");
        case1.put("Wind", "Strong");
        Assert.assertTrue((boolean)this.makeOutlookTree().apply(case1));
    }

    @Test(expected=BadDecisionException.class)
    public void testOutlookRainInsufficientDataThrowsException() throws BadDecisionException {
        HashMap<String, String> case1 = new HashMap<String, String>();
        case1.put("Outlook", "Rain");
        case1.put("Temperature", "Mild");
        this.makeOutlookTree().apply(case1);
    }

    public void attributeIsUsedOnlyOnceInTree(Attribute node, List<String> attributes) {
        for (Attribute child : node.getDecisions().values()) {
            if (child.isLeaf()) continue;
            Assert.assertFalse((boolean)attributes.contains(child.getName()));
            attributes.add(child.getName());
            this.attributeIsUsedOnlyOnceInTree(child, attributes);
        }
    }

    @Test
    public void testAttributeIsUsedOnlyOnceInTree() {
        DecisionTree tree = this.makeOutlookTree();
        tree.compile();
        LinkedList<String> attributeList = new LinkedList<String>();
        attributeList.add(tree.getRoot().getName());
        this.attributeIsUsedOnlyOnceInTree(tree.getRoot(), attributeList);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"DecisionTreeTest"});
    }
}

