/*
 * Decompiled with CFR 0.152.
 */
package dt;

import dt.BadDecisionException;
import dt.Decisions;
import java.util.Map;

public class Attribute {
    private boolean leaf;
    private String attributeName;
    private Decisions decisions;
    private boolean classification;

    public Attribute(boolean classification) {
        this.leaf = true;
        this.classification = classification;
        this.decisions = new Decisions();
        this.attributeName = null;
    }

    public Attribute(String name) {
        this.leaf = false;
        this.attributeName = name;
        this.decisions = new Decisions();
    }

    public String getName() {
        return this.attributeName;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setClassification(boolean classification) {
        assert (this.leaf);
        this.classification = classification;
    }

    public boolean getClassification() {
        assert (this.leaf);
        return this.classification;
    }

    public boolean apply(Map<String, String> data) throws BadDecisionException {
        if (this.isLeaf()) {
            return this.getClassification();
        }
        Attribute nextAttribute = this.decisions.apply(data.get(this.attributeName));
        return nextAttribute.apply(data);
    }

    public void addDecision(String decision, Attribute attribute) {
        assert (!this.leaf);
        this.decisions.put(decision, attribute);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (Map.Entry<String, Attribute> e : this.decisions.getMap().entrySet()) {
            b.append(this.getName());
            b.append(" -> ");
            if (e.getValue().isLeaf()) {
                b.append(e.getValue().getClassification());
            } else {
                b.append(e.getValue().getName());
            }
            b.append(" [label=\"");
            b.append(e.getKey());
            b.append("\"]\n");
            b.append(e.getValue().toString());
        }
        return b.toString();
    }

    public Map<String, Attribute> getDecisions() {
        return this.decisions.getMap();
    }
}

