/*
 * Decompiled with CFR 0.152.
 */
package com.seisw.util.geom;

import com.seisw.util.geom.Poly;
import com.seisw.util.geom.PolyDefault;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Clip {
    private static final boolean DEBUG = false;
    private static final double GPC_EPSILON = 2.220446049250313E-16;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int ABOVE = 0;
    private static final int BELOW = 1;
    private static final int CLIP = 0;
    private static final int SUBJ = 1;

    private Clip() {
    }

    public static Poly intersection(Poly p1, Poly p2, Class polyClass) {
        return Clip.clip(OperationType.GPC_INT, p1, p2, polyClass);
    }

    public static Poly union(Poly p1, Poly p2, Class polyClass) {
        return Clip.clip(OperationType.GPC_UNION, p1, p2, polyClass);
    }

    public static Poly xor(Poly p1, Poly p2, Class polyClass) {
        return Clip.clip(OperationType.GPC_XOR, p1, p2, polyClass);
    }

    public static Poly intersection(Poly p1, Poly p2) {
        return Clip.clip(OperationType.GPC_INT, p1, p2, PolyDefault.class);
    }

    public static Poly union(Poly p1, Poly p2) {
        return Clip.clip(OperationType.GPC_UNION, p1, p2, PolyDefault.class);
    }

    public static Poly xor(Poly p1, Poly p2) {
        return Clip.clip(OperationType.GPC_XOR, p1, p2, PolyDefault.class);
    }

    public static Poly diff(Poly p1, Poly p2) {
        return Clip.clip(OperationType.GPC_DIFF, p1, p2, PolyDefault.class);
    }

    public static Poly diff(Poly p1, Poly p2, Class class1) {
        return Clip.clip(OperationType.GPC_DIFF, p1, p2, class1);
    }

    private static Poly createNewPoly(Class polyClass) {
        try {
            return (Poly)polyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Poly clip(OperationType op, Poly subj, Poly clip, Class polyClass) {
        Poly result = Clip.createNewPoly(polyClass);
        if (subj.isEmpty() && clip.isEmpty() || subj.isEmpty() && (op == OperationType.GPC_INT || op == OperationType.GPC_DIFF) || clip.isEmpty() && op == OperationType.GPC_INT) {
            return result;
        }
        if (!(op != OperationType.GPC_INT && op != OperationType.GPC_DIFF || subj.isEmpty() || clip.isEmpty())) {
            Clip.minimax_test(subj, clip, op);
        }
        LmtTable lmt_table = new LmtTable();
        ScanBeamTreeEntries sbte = new ScanBeamTreeEntries();
        if (!subj.isEmpty()) {
            Clip.build_lmt(lmt_table, sbte, subj, 1, op);
        }
        if (!clip.isEmpty()) {
            Clip.build_lmt(lmt_table, sbte, clip, 0, op);
        }
        if (lmt_table.top_node == null) {
            return result;
        }
        double[] sbt = sbte.build_sbt();
        int[] parity = new int[]{0, 0};
        if (op == OperationType.GPC_DIFF) {
            parity[0] = 1;
        }
        LmtNode local_min = lmt_table.top_node;
        TopPolygonNode out_poly = new TopPolygonNode();
        AetTree aet = new AetTree();
        int scanbeam = 0;
        while (scanbeam < sbt.length) {
            double yb = sbt[scanbeam++];
            double yt = 0.0;
            double dy = 0.0;
            if (scanbeam < sbt.length) {
                yt = sbt[scanbeam];
                dy = yt - yb;
            }
            if (local_min != null && local_min.y == yb) {
                EdgeNode edge = local_min.first_bound;
                while (edge != null) {
                    Clip.add_edge_to_aet(aet, edge);
                    edge = edge.next_bound;
                }
                local_min = local_min.next;
            }
            double px = -1.7976931348623157E308;
            EdgeNode e0 = aet.top_node;
            EdgeNode e1 = aet.top_node;
            aet.top_node.bundle[0][aet.top_node.type] = aet.top_node.top.y != yb ? 1 : 0;
            aet.top_node.bundle[0][aet.top_node.type == 0 ? 1 : 0] = 0;
            aet.top_node.bstate[0] = BundleState.UNBUNDLED;
            EdgeNode next_edge = aet.top_node.next;
            while (next_edge != null) {
                int ne_type = next_edge.type;
                int ne_type_opp = next_edge.type == 0 ? 1 : 0;
                next_edge.bundle[0][ne_type] = next_edge.top.y != yb ? 1 : 0;
                next_edge.bundle[0][ne_type_opp] = 0;
                next_edge.bstate[0] = BundleState.UNBUNDLED;
                if (next_edge.bundle[0][ne_type] == 1) {
                    if (Clip.EQ(e0.xb, next_edge.xb) && Clip.EQ(e0.dx, next_edge.dx) && e0.top.y != yb) {
                        int[] nArray = next_edge.bundle[0];
                        int n = ne_type;
                        nArray[n] = nArray[n] ^ e0.bundle[0][ne_type];
                        next_edge.bundle[0][ne_type_opp] = e0.bundle[0][ne_type_opp];
                        next_edge.bstate[0] = BundleState.BUNDLE_HEAD;
                        e0.bundle[0][0] = 0;
                        e0.bundle[0][1] = 0;
                        e0.bstate[0] = BundleState.BUNDLE_TAIL;
                    }
                    e0 = next_edge;
                }
                next_edge = next_edge.next;
            }
            int[] horiz = new int[]{0, 0};
            int[] exists = new int[]{0, 0};
            PolygonNode cf = null;
            EdgeNode edge = aet.top_node;
            while (edge != null) {
                exists[0] = edge.bundle[0][0] + (edge.bundle[1][0] << 1);
                exists[1] = edge.bundle[0][1] + (edge.bundle[1][1] << 1);
                if (exists[0] != 0 || exists[1] != 0) {
                    edge.bside[0] = parity[0];
                    edge.bside[1] = parity[1];
                    boolean contributing = false;
                    int br = 0;
                    int bl = 0;
                    int tr = 0;
                    int tl = 0;
                    if (op == OperationType.GPC_DIFF || op == OperationType.GPC_INT) {
                        contributing = exists[0] != 0 && (parity[1] != 0 || horiz[1] != 0) || exists[1] != 0 && (parity[0] != 0 || horiz[0] != 0) || exists[0] != 0 && exists[1] != 0 && parity[0] == parity[1];
                        br = parity[0] != 0 && parity[1] != 0 ? 1 : 0;
                        bl = (parity[0] ^ edge.bundle[0][0]) != 0 && (parity[1] ^ edge.bundle[0][1]) != 0 ? 1 : 0;
                        tr = (parity[0] ^ (horiz[0] != 0 ? 1 : 0)) != 0 && (parity[1] ^ (horiz[1] != 0 ? 1 : 0)) != 0 ? 1 : 0;
                        tl = (parity[0] ^ (horiz[0] != 0 ? 1 : 0) ^ edge.bundle[1][0]) != 0 && (parity[1] ^ (horiz[1] != 0 ? 1 : 0) ^ edge.bundle[1][1]) != 0 ? 1 : 0;
                    } else if (op == OperationType.GPC_XOR) {
                        contributing = exists[0] != 0 || exists[1] != 0;
                        br = parity[0] ^ parity[1];
                        bl = parity[0] ^ edge.bundle[0][0] ^ (parity[1] ^ edge.bundle[0][1]);
                        tr = parity[0] ^ (horiz[0] != 0 ? 1 : 0) ^ (parity[1] ^ (horiz[1] != 0 ? 1 : 0));
                        tl = parity[0] ^ (horiz[0] != 0 ? 1 : 0) ^ edge.bundle[1][0] ^ (parity[1] ^ (horiz[1] != 0 ? 1 : 0) ^ edge.bundle[1][1]);
                    } else if (op == OperationType.GPC_UNION) {
                        contributing = exists[0] != 0 && (parity[1] == 0 || horiz[1] != 0) || exists[1] != 0 && (parity[0] == 0 || horiz[0] != 0) || exists[0] != 0 && exists[1] != 0 && parity[0] == parity[1];
                        br = parity[0] != 0 || parity[1] != 0 ? 1 : 0;
                        bl = (parity[0] ^ edge.bundle[0][0]) != 0 || (parity[1] ^ edge.bundle[0][1]) != 0 ? 1 : 0;
                        tr = (parity[0] ^ (horiz[0] != 0 ? 1 : 0)) != 0 || (parity[1] ^ (horiz[1] != 0 ? 1 : 0)) != 0 ? 1 : 0;
                        tl = (parity[0] ^ (horiz[0] != 0 ? 1 : 0) ^ edge.bundle[1][0]) != 0 || (parity[1] ^ (horiz[1] != 0 ? 1 : 0) ^ edge.bundle[1][1]) != 0 ? 1 : 0;
                    } else {
                        throw new IllegalStateException("Unknown op");
                    }
                    parity[0] = parity[0] ^ edge.bundle[0][0];
                    parity[1] = parity[1] ^ edge.bundle[0][1];
                    if (exists[0] != 0) {
                        horiz[0] = HState.next_h_state[horiz[0]][(exists[0] - 1 << 1) + parity[0]];
                    }
                    if (exists[1] != 0) {
                        horiz[1] = HState.next_h_state[horiz[1]][(exists[1] - 1 << 1) + parity[1]];
                    }
                    if (contributing) {
                        double xb = edge.xb;
                        int vclass = VertexType.getType(tr, tl, br, bl);
                        switch (vclass) {
                            case 7: 
                            case 8: {
                                edge.outp[0] = out_poly.add_local_min(xb, yb);
                                px = xb;
                                cf = edge.outp[0];
                                break;
                            }
                            case 4: {
                                if (xb != px) {
                                    cf.add_right(xb, yb);
                                    px = xb;
                                }
                                edge.outp[0] = cf;
                                cf = null;
                                break;
                            }
                            case 2: {
                                edge.outp[1].add_left(xb, yb);
                                px = xb;
                                cf = edge.outp[1];
                                break;
                            }
                            case 1: {
                                if (xb != px) {
                                    cf.add_left(xb, yb);
                                    px = xb;
                                }
                                out_poly.merge_right(cf, edge.outp[1]);
                                cf = null;
                                break;
                            }
                            case 11: {
                                if (xb != px) {
                                    cf.add_left(xb, yb);
                                    px = xb;
                                }
                                edge.outp[0] = cf;
                                cf = null;
                                break;
                            }
                            case 13: {
                                edge.outp[1].add_right(xb, yb);
                                px = xb;
                                cf = edge.outp[1];
                                edge.outp[1] = null;
                                break;
                            }
                            case 14: {
                                if (xb != px) {
                                    cf.add_right(xb, yb);
                                    px = xb;
                                }
                                out_poly.merge_left(cf, edge.outp[1]);
                                cf = null;
                                edge.outp[1] = null;
                                break;
                            }
                            case 6: {
                                if (xb != px) {
                                    cf.add_right(xb, yb);
                                    px = xb;
                                }
                                out_poly.merge_left(cf, edge.outp[1]);
                                edge.outp[1] = null;
                                edge.outp[0] = out_poly.add_local_min(xb, yb);
                                cf = edge.outp[0];
                                break;
                            }
                            case 9: {
                                if (xb != px) {
                                    cf.add_left(xb, yb);
                                    px = xb;
                                }
                                out_poly.merge_right(cf, edge.outp[1]);
                                edge.outp[1] = null;
                                edge.outp[0] = out_poly.add_local_min(xb, yb);
                                cf = edge.outp[0];
                                break;
                            }
                            case 10: {
                                if (edge.bot.y == yb) {
                                    edge.outp[1].add_left(xb, yb);
                                }
                                edge.outp[0] = edge.outp[1];
                                px = xb;
                                break;
                            }
                            case 5: {
                                if (edge.bot.y == yb) {
                                    edge.outp[1].add_right(xb, yb);
                                }
                                edge.outp[0] = edge.outp[1];
                                px = xb;
                                break;
                            }
                        }
                    }
                }
                edge = edge.next;
            }
            edge = aet.top_node;
            while (edge != null) {
                if (edge.top.y == yb) {
                    EdgeNode prev_edge = edge.prev;
                    EdgeNode next_edge2 = edge.next;
                    if (prev_edge != null) {
                        prev_edge.next = next_edge2;
                    } else {
                        aet.top_node = next_edge2;
                    }
                    if (next_edge2 != null) {
                        next_edge2.prev = prev_edge;
                    }
                    if (edge.bstate[1] == BundleState.BUNDLE_HEAD && prev_edge != null && prev_edge.bstate[1] == BundleState.BUNDLE_TAIL) {
                        prev_edge.outp[1] = edge.outp[1];
                        prev_edge.bstate[1] = BundleState.UNBUNDLED;
                        if (prev_edge.prev != null && prev_edge.prev.bstate[1] == BundleState.BUNDLE_TAIL) {
                            prev_edge.bstate[1] = BundleState.BUNDLE_HEAD;
                        }
                    }
                } else {
                    edge.xt = edge.top.y == yt ? edge.top.x : edge.bot.x + edge.dx * (yt - edge.bot.y);
                }
                edge = edge.next;
            }
            if (scanbeam >= sbte.sbt_entries) continue;
            ItNodeTable it_table = new ItNodeTable();
            it_table.build_intersection_table(aet, dy);
            ItNode intersect = it_table.top_node;
            while (intersect != null) {
                e0 = intersect.ie[0];
                e1 = intersect.ie[1];
                if (!(e0.bundle[0][0] == 0 && e0.bundle[0][1] == 0 || e1.bundle[0][0] == 0 && e1.bundle[0][1] == 0)) {
                    PolygonNode p = e0.outp[0];
                    PolygonNode q = e1.outp[0];
                    double ix = intersect.point.x;
                    double iy = intersect.point.y + yb;
                    int in_clip = e0.bundle[0][0] != 0 && e0.bside[0] == 0 || e1.bundle[0][0] != 0 && e1.bside[0] != 0 || e0.bundle[0][0] == 0 && e1.bundle[0][0] == 0 && e0.bside[0] != 0 && e1.bside[0] != 0 ? 1 : 0;
                    int in_subj = e0.bundle[0][1] != 0 && e0.bside[1] == 0 || e1.bundle[0][1] != 0 && e1.bside[1] != 0 || e0.bundle[0][1] == 0 && e1.bundle[0][1] == 0 && e0.bside[1] != 0 && e1.bside[1] != 0 ? 1 : 0;
                    int tr = 0;
                    int tl = 0;
                    int br = 0;
                    int bl = 0;
                    if (op == OperationType.GPC_DIFF || op == OperationType.GPC_INT) {
                        tr = in_clip != 0 && in_subj != 0 ? 1 : 0;
                        tl = (in_clip ^ e1.bundle[0][0]) != 0 && (in_subj ^ e1.bundle[0][1]) != 0 ? 1 : 0;
                        br = (in_clip ^ e0.bundle[0][0]) != 0 && (in_subj ^ e0.bundle[0][1]) != 0 ? 1 : 0;
                        bl = (in_clip ^ e1.bundle[0][0] ^ e0.bundle[0][0]) != 0 && (in_subj ^ e1.bundle[0][1] ^ e0.bundle[0][1]) != 0 ? 1 : 0;
                    } else if (op == OperationType.GPC_XOR) {
                        tr = in_clip ^ in_subj;
                        tl = in_clip ^ e1.bundle[0][0] ^ (in_subj ^ e1.bundle[0][1]);
                        br = in_clip ^ e0.bundle[0][0] ^ (in_subj ^ e0.bundle[0][1]);
                        bl = in_clip ^ e1.bundle[0][0] ^ e0.bundle[0][0] ^ (in_subj ^ e1.bundle[0][1] ^ e0.bundle[0][1]);
                    } else if (op == OperationType.GPC_UNION) {
                        tr = in_clip != 0 || in_subj != 0 ? 1 : 0;
                        tl = (in_clip ^ e1.bundle[0][0]) != 0 || (in_subj ^ e1.bundle[0][1]) != 0 ? 1 : 0;
                        br = (in_clip ^ e0.bundle[0][0]) != 0 || (in_subj ^ e0.bundle[0][1]) != 0 ? 1 : 0;
                        bl = (in_clip ^ e1.bundle[0][0] ^ e0.bundle[0][0]) != 0 || (in_subj ^ e1.bundle[0][1] ^ e0.bundle[0][1]) != 0 ? 1 : 0;
                    } else {
                        throw new IllegalStateException("Unknown op type, " + op);
                    }
                    int vclass = VertexType.getType(tr, tl, br, bl);
                    switch (vclass) {
                        case 8: {
                            e0.outp[0] = out_poly.add_local_min(ix, iy);
                            e1.outp[0] = e0.outp[0];
                            break;
                        }
                        case 4: {
                            if (p == null) break;
                            p.add_right(ix, iy);
                            e1.outp[0] = p;
                            e0.outp[0] = null;
                            break;
                        }
                        case 2: {
                            if (q == null) break;
                            q.add_left(ix, iy);
                            e0.outp[0] = q;
                            e1.outp[0] = null;
                            break;
                        }
                        case 1: {
                            if (p == null || q == null) break;
                            p.add_left(ix, iy);
                            out_poly.merge_right(p, q);
                            e0.outp[0] = null;
                            e1.outp[0] = null;
                            break;
                        }
                        case 7: {
                            e0.outp[0] = out_poly.add_local_min(ix, iy);
                            e1.outp[0] = e0.outp[0];
                            break;
                        }
                        case 11: {
                            if (p == null) break;
                            p.add_left(ix, iy);
                            e1.outp[0] = p;
                            e0.outp[0] = null;
                            break;
                        }
                        case 13: {
                            if (q == null) break;
                            q.add_right(ix, iy);
                            e0.outp[0] = q;
                            e1.outp[0] = null;
                            break;
                        }
                        case 14: {
                            if (p == null || q == null) break;
                            p.add_right(ix, iy);
                            out_poly.merge_left(p, q);
                            e0.outp[0] = null;
                            e1.outp[0] = null;
                            break;
                        }
                        case 6: {
                            if (p == null || q == null) break;
                            p.add_right(ix, iy);
                            out_poly.merge_left(p, q);
                            e0.outp[0] = out_poly.add_local_min(ix, iy);
                            e1.outp[0] = e0.outp[0];
                            break;
                        }
                        case 9: {
                            if (p == null || q == null) break;
                            p.add_left(ix, iy);
                            out_poly.merge_right(p, q);
                            e0.outp[0] = out_poly.add_local_min(ix, iy);
                            e1.outp[0] = e0.outp[0];
                            break;
                        }
                    }
                }
                if (e0.bundle[0][0] != 0) {
                    int n = e1.bside[0] = e1.bside[0] == 0 ? 1 : 0;
                }
                if (e1.bundle[0][0] != 0) {
                    int n = e0.bside[0] = e0.bside[0] == 0 ? 1 : 0;
                }
                if (e0.bundle[0][1] != 0) {
                    int n = e1.bside[1] = e1.bside[1] == 0 ? 1 : 0;
                }
                if (e1.bundle[0][1] != 0) {
                    e0.bside[1] = e0.bside[1] == 0 ? 1 : 0;
                }
                EdgeNode prev_edge = e0.prev;
                EdgeNode next_edge3 = e1.next;
                if (next_edge3 != null) {
                    next_edge3.prev = e0;
                }
                if (e0.bstate[0] == BundleState.BUNDLE_HEAD) {
                    boolean search = true;
                    while (search) {
                        prev_edge = prev_edge.prev;
                        if (prev_edge != null) {
                            if (prev_edge.bstate[0] == BundleState.BUNDLE_TAIL) continue;
                            search = false;
                            continue;
                        }
                        search = false;
                    }
                }
                if (prev_edge == null) {
                    aet.top_node.prev = e1;
                    e1.next = aet.top_node;
                    aet.top_node = e0.next;
                } else {
                    prev_edge.next.prev = e1;
                    e1.next = prev_edge.next;
                    prev_edge.next = e0.next;
                }
                e0.next.prev = prev_edge;
                e1.next.prev = e1;
                e0.next = next_edge3;
                intersect = intersect.next;
            }
            EdgeNode edge2 = aet.top_node;
            while (edge2 != null) {
                EdgeNode next_edge4 = edge2.next;
                EdgeNode succ_edge = edge2.succ;
                if (edge2.top.y == yt && succ_edge != null) {
                    succ_edge.outp[1] = edge2.outp[0];
                    succ_edge.bstate[1] = edge2.bstate[0];
                    succ_edge.bundle[1][0] = edge2.bundle[0][0];
                    succ_edge.bundle[1][1] = edge2.bundle[0][1];
                    EdgeNode prev_edge = edge2.prev;
                    if (prev_edge != null) {
                        prev_edge.next = succ_edge;
                    } else {
                        aet.top_node = succ_edge;
                    }
                    if (next_edge4 != null) {
                        next_edge4.prev = succ_edge;
                    }
                    succ_edge.prev = prev_edge;
                    succ_edge.next = next_edge4;
                } else {
                    edge2.outp[1] = edge2.outp[0];
                    edge2.bstate[1] = edge2.bstate[0];
                    edge2.bundle[1][0] = edge2.bundle[0][0];
                    edge2.bundle[1][1] = edge2.bundle[0][1];
                    edge2.xb = edge2.xt;
                }
                edge2.outp[0] = null;
                edge2 = edge2.next;
            }
        }
        result = out_poly.getResult(polyClass);
        return result;
    }

    private static boolean EQ(double a, double b) {
        return Math.abs(a - b) <= 2.220446049250313E-16;
    }

    private static int PREV_INDEX(int i, int n) {
        return (i - 1 + n) % n;
    }

    private static int NEXT_INDEX(int i, int n) {
        return (i + 1) % n;
    }

    private static boolean OPTIMAL(Poly p, int i) {
        return p.getY(Clip.PREV_INDEX(i, p.getNumPoints())) != p.getY(i) || p.getY(Clip.NEXT_INDEX(i, p.getNumPoints())) != p.getY(i);
    }

    private static Rectangle2D[] create_contour_bboxes(Poly p) {
        Rectangle2D[] box = new Rectangle2D[p.getNumInnerPoly()];
        for (int c = 0; c < p.getNumInnerPoly(); ++c) {
            Poly inner_poly = p.getInnerPoly(c);
            box[c] = inner_poly.getBounds();
        }
        return box;
    }

    private static void minimax_test(Poly subj, Poly clip, OperationType op) {
        boolean overlap;
        int s;
        Rectangle2D[] s_bbox = Clip.create_contour_bboxes(subj);
        Rectangle2D[] c_bbox = Clip.create_contour_bboxes(clip);
        int subj_num_poly = subj.getNumInnerPoly();
        int clip_num_poly = clip.getNumInnerPoly();
        boolean[][] o_table = new boolean[subj_num_poly][clip_num_poly];
        for (s = 0; s < subj_num_poly; ++s) {
            for (int c = 0; c < clip_num_poly; ++c) {
                o_table[s][c] = !(s_bbox[s].getMaxX() < c_bbox[c].getMinX() || s_bbox[s].getMinX() > c_bbox[c].getMaxX() || s_bbox[s].getMaxY() < c_bbox[c].getMinY() || s_bbox[s].getMinY() > c_bbox[c].getMaxY());
            }
        }
        for (int c = 0; c < clip_num_poly; ++c) {
            overlap = false;
            for (int s2 = 0; !overlap && s2 < subj_num_poly; ++s2) {
                overlap = o_table[s2][c];
            }
            if (overlap) continue;
            clip.setContributing(c, false);
        }
        if (op == OperationType.GPC_INT) {
            for (s = 0; s < subj_num_poly; ++s) {
                overlap = false;
                for (int c = 0; !overlap && c < clip_num_poly; ++c) {
                    overlap = o_table[s][c];
                }
                if (overlap) continue;
                subj.setContributing(s, false);
            }
        }
    }

    private static LmtNode bound_list(LmtTable lmt_table, double y) {
        if (lmt_table.top_node == null) {
            lmt_table.top_node = new LmtNode(y);
            return lmt_table.top_node;
        }
        LmtNode prev = null;
        LmtNode node = lmt_table.top_node;
        boolean done = false;
        while (!done) {
            if (y < node.y) {
                LmtNode existing_node = node;
                node = new LmtNode(y);
                node.next = existing_node;
                if (prev == null) {
                    lmt_table.top_node = node;
                } else {
                    prev.next = node;
                }
                done = true;
                continue;
            }
            if (y > node.y) {
                if (node.next == null) {
                    node = node.next = new LmtNode(y);
                    done = true;
                    continue;
                }
                prev = node;
                node = node.next;
                continue;
            }
            done = true;
        }
        return node;
    }

    private static void insert_bound(LmtNode lmt_node, EdgeNode e) {
        if (lmt_node.first_bound == null) {
            lmt_node.first_bound = e;
        } else {
            boolean done = false;
            EdgeNode prev_bound = null;
            EdgeNode current_bound = lmt_node.first_bound;
            while (!done) {
                if (e.bot.x < current_bound.bot.x) {
                    if (prev_bound == null) {
                        lmt_node.first_bound = e;
                    } else {
                        prev_bound.next_bound = e;
                    }
                    e.next_bound = current_bound;
                    done = true;
                    continue;
                }
                if (e.bot.x == current_bound.bot.x) {
                    if (e.dx < current_bound.dx) {
                        if (prev_bound == null) {
                            lmt_node.first_bound = e;
                        } else {
                            prev_bound.next_bound = e;
                        }
                        e.next_bound = current_bound;
                        done = true;
                        continue;
                    }
                    if (current_bound.next_bound == null) {
                        current_bound.next_bound = e;
                        done = true;
                        continue;
                    }
                    prev_bound = current_bound;
                    current_bound = current_bound.next_bound;
                    continue;
                }
                if (current_bound.next_bound == null) {
                    current_bound.next_bound = e;
                    done = true;
                    continue;
                }
                prev_bound = current_bound;
                current_bound = current_bound.next_bound;
            }
        }
    }

    private static void add_edge_to_aet(AetTree aet, EdgeNode edge) {
        if (aet.top_node == null) {
            aet.top_node = edge;
            edge.prev = null;
            edge.next = null;
        } else {
            EdgeNode current_edge = aet.top_node;
            EdgeNode prev = null;
            boolean done = false;
            while (!done) {
                if (edge.xb < current_edge.xb) {
                    edge.prev = prev;
                    edge.next = current_edge;
                    current_edge.prev = edge;
                    if (prev == null) {
                        aet.top_node = edge;
                    } else {
                        prev.next = edge;
                    }
                    done = true;
                    continue;
                }
                if (edge.xb == current_edge.xb) {
                    if (edge.dx < current_edge.dx) {
                        edge.prev = prev;
                        edge.next = current_edge;
                        current_edge.prev = edge;
                        if (prev == null) {
                            aet.top_node = edge;
                        } else {
                            prev.next = edge;
                        }
                        done = true;
                        continue;
                    }
                    prev = current_edge;
                    if (current_edge.next == null) {
                        current_edge.next = edge;
                        edge.prev = current_edge;
                        edge.next = null;
                        done = true;
                        continue;
                    }
                    current_edge = current_edge.next;
                    continue;
                }
                prev = current_edge;
                if (current_edge.next == null) {
                    current_edge.next = edge;
                    edge.prev = current_edge;
                    edge.next = null;
                    done = true;
                    continue;
                }
                current_edge = current_edge.next;
            }
        }
    }

    private static void add_to_sbtree(ScanBeamTreeEntries sbte, double y) {
        if (sbte.sb_tree == null) {
            sbte.sb_tree = new ScanBeamTree(y);
            ++sbte.sbt_entries;
            return;
        }
        ScanBeamTree tree_node = sbte.sb_tree;
        boolean done = false;
        while (!done) {
            if (tree_node.y > y) {
                if (tree_node.less == null) {
                    tree_node.less = new ScanBeamTree(y);
                    ++sbte.sbt_entries;
                    done = true;
                    continue;
                }
                tree_node = tree_node.less;
                continue;
            }
            if (tree_node.y < y) {
                if (tree_node.more == null) {
                    tree_node.more = new ScanBeamTree(y);
                    ++sbte.sbt_entries;
                    done = true;
                    continue;
                }
                tree_node = tree_node.more;
                continue;
            }
            done = true;
        }
    }

    private static EdgeTable build_lmt(LmtTable lmt_table, ScanBeamTreeEntries sbte, Poly p, int type, OperationType op) {
        EdgeTable edge_table = new EdgeTable();
        for (int c = 0; c < p.getNumInnerPoly(); ++c) {
            EdgeNode ev;
            EdgeNode ei;
            int i;
            EdgeNode e;
            int max;
            int min;
            Poly ip = p.getInnerPoly(c);
            if (!ip.isContributing(0)) {
                ip.setContributing(0, true);
                continue;
            }
            int num_vertices = 0;
            int e_index = 0;
            edge_table = new EdgeTable();
            for (int i2 = 0; i2 < ip.getNumPoints(); ++i2) {
                if (!Clip.OPTIMAL(ip, i2)) continue;
                double x = ip.getX(i2);
                double y = ip.getY(i2);
                edge_table.addNode(x, y);
                Clip.add_to_sbtree(sbte, ip.getY(i2));
                ++num_vertices;
            }
            for (min = 0; min < num_vertices; ++min) {
                if (!edge_table.FWD_MIN(min)) continue;
                int num_edges = 1;
                max = Clip.NEXT_INDEX(min, num_vertices);
                while (edge_table.NOT_FMAX(max)) {
                    ++num_edges;
                    max = Clip.NEXT_INDEX(max, num_vertices);
                }
                int v = min;
                e = edge_table.getNode(e_index);
                e.bstate[1] = BundleState.UNBUNDLED;
                e.bundle[1][0] = 0;
                e.bundle[1][1] = 0;
                for (i = 0; i < num_edges; ++i) {
                    ei = edge_table.getNode(e_index + i);
                    ev = edge_table.getNode(v);
                    ei.xb = ev.vertex.x;
                    ei.bot.x = ev.vertex.x;
                    ei.bot.y = ev.vertex.y;
                    v = Clip.NEXT_INDEX(v, num_vertices);
                    ev = edge_table.getNode(v);
                    ei.top.x = ev.vertex.x;
                    ei.top.y = ev.vertex.y;
                    ei.dx = (ev.vertex.x - ei.bot.x) / (ei.top.y - ei.bot.y);
                    ei.type = type;
                    ei.outp[0] = null;
                    ei.outp[1] = null;
                    ei.next = null;
                    ei.prev = null;
                    ei.succ = num_edges > 1 && i < num_edges - 1 ? edge_table.getNode(e_index + i + 1) : null;
                    ei.pred = num_edges > 1 && i > 0 ? edge_table.getNode(e_index + i - 1) : null;
                    ei.next_bound = null;
                    ei.bside[0] = op == OperationType.GPC_DIFF ? 1 : 0;
                    ei.bside[1] = 0;
                }
                Clip.insert_bound(Clip.bound_list(lmt_table, edge_table.getNode((int)min).vertex.y), e);
                e_index += num_edges;
            }
            for (min = 0; min < num_vertices; ++min) {
                if (!edge_table.REV_MIN(min)) continue;
                int num_edges = 1;
                max = Clip.PREV_INDEX(min, num_vertices);
                while (edge_table.NOT_RMAX(max)) {
                    ++num_edges;
                    max = Clip.PREV_INDEX(max, num_vertices);
                }
                int v = min;
                e = edge_table.getNode(e_index);
                e.bstate[1] = BundleState.UNBUNDLED;
                e.bundle[1][0] = 0;
                e.bundle[1][1] = 0;
                for (i = 0; i < num_edges; ++i) {
                    ei = edge_table.getNode(e_index + i);
                    ev = edge_table.getNode(v);
                    ei.xb = ev.vertex.x;
                    ei.bot.x = ev.vertex.x;
                    ei.bot.y = ev.vertex.y;
                    v = Clip.PREV_INDEX(v, num_vertices);
                    ev = edge_table.getNode(v);
                    ei.top.x = ev.vertex.x;
                    ei.top.y = ev.vertex.y;
                    ei.dx = (ev.vertex.x - ei.bot.x) / (ei.top.y - ei.bot.y);
                    ei.type = type;
                    ei.outp[0] = null;
                    ei.outp[1] = null;
                    ei.next = null;
                    ei.prev = null;
                    ei.succ = num_edges > 1 && i < num_edges - 1 ? edge_table.getNode(e_index + i + 1) : null;
                    ei.pred = num_edges > 1 && i > 0 ? edge_table.getNode(e_index + i - 1) : null;
                    ei.next_bound = null;
                    ei.bside[0] = op == OperationType.GPC_DIFF ? 1 : 0;
                    ei.bside[1] = 0;
                }
                Clip.insert_bound(Clip.bound_list(lmt_table, edge_table.getNode((int)min).vertex.y), e);
                e_index += num_edges;
            }
        }
        return edge_table;
    }

    private static StNode add_st_edge(StNode st, ItNodeTable it, EdgeNode edge, double dy) {
        if (st == null) {
            st = new StNode(edge, null);
        } else {
            double den = st.xt - st.xb - (edge.xt - edge.xb);
            if (edge.xt >= st.xt || edge.dx == st.dx || Math.abs(den) <= 2.220446049250313E-16) {
                StNode existing_node = st;
                st = new StNode(edge, existing_node);
            } else {
                double r = (edge.xb - st.xb) / den;
                double x = st.xb + r * (st.xt - st.xb);
                double y = r * dy;
                it.top_node = Clip.add_intersection(it.top_node, st.edge, edge, x, y);
                st.prev = Clip.add_st_edge(st.prev, it, edge, dy);
            }
        }
        return st;
    }

    private static ItNode add_intersection(ItNode it_node, EdgeNode edge0, EdgeNode edge1, double x, double y) {
        if (it_node == null) {
            it_node = new ItNode(edge0, edge1, x, y, null);
        } else if (it_node.point.y > y) {
            ItNode existing_node = it_node;
            it_node = new ItNode(edge0, edge1, x, y, existing_node);
        } else {
            it_node.next = Clip.add_intersection(it_node.next, edge0, edge1, x, y);
        }
        return it_node;
    }

    private static void print_sbt(double[] sbt) {
        System.out.println("");
        System.out.println("sbt.length=" + sbt.length);
        for (int i = 0; i < sbt.length; ++i) {
            System.out.println("sbt[" + i + "]=" + sbt[i]);
        }
    }

    private static class StNode {
        EdgeNode edge;
        double xb;
        double xt;
        double dx;
        StNode prev;

        public StNode(EdgeNode edge, StNode prev) {
            this.edge = edge;
            this.xb = edge.xb;
            this.xt = edge.xt;
            this.dx = edge.dx;
            this.prev = prev;
        }
    }

    private static class ItNodeTable {
        ItNode top_node;

        private ItNodeTable() {
        }

        public void build_intersection_table(AetTree aet, double dy) {
            StNode st = null;
            EdgeNode edge = aet.top_node;
            while (edge != null) {
                if (edge.bstate[0] == BundleState.BUNDLE_HEAD || edge.bundle[0][0] != 0 || edge.bundle[0][1] != 0) {
                    st = Clip.add_st_edge(st, this, edge, dy);
                }
                edge = edge.next;
            }
        }
    }

    private static class EdgeNode {
        Point2D.Double vertex = new Point2D.Double();
        Point2D.Double bot = new Point2D.Double();
        Point2D.Double top = new Point2D.Double();
        double xb;
        double xt;
        double dx;
        int type;
        int[][] bundle = new int[2][2];
        int[] bside = new int[2];
        BundleState[] bstate = new BundleState[2];
        PolygonNode[] outp = new PolygonNode[2];
        EdgeNode prev;
        EdgeNode next;
        EdgeNode pred;
        EdgeNode succ;
        EdgeNode next_bound;

        private EdgeNode() {
        }
    }

    private static class OperationType {
        private String m_Type;
        public static final OperationType GPC_DIFF = new OperationType("Difference");
        public static final OperationType GPC_INT = new OperationType("Intersection");
        public static final OperationType GPC_XOR = new OperationType("Exclusive or");
        public static final OperationType GPC_UNION = new OperationType("Union");

        private OperationType(String type) {
            this.m_Type = type;
        }

        public String toString() {
            return this.m_Type;
        }
    }

    private static class LmtTable {
        LmtNode top_node;

        private LmtTable() {
        }

        public void print() {
            int n = 0;
            LmtNode lmt = this.top_node;
            while (lmt != null) {
                System.out.println("lmt(" + n + ")");
                EdgeNode edge = lmt.first_bound;
                while (edge != null) {
                    System.out.println("edge.vertex.x=" + edge.vertex.x + "  edge.vertex.y=" + edge.vertex.y);
                    edge = edge.next_bound;
                }
                ++n;
                lmt = lmt.next;
            }
        }
    }

    private static class ScanBeamTreeEntries {
        int sbt_entries;
        ScanBeamTree sb_tree;

        private ScanBeamTreeEntries() {
        }

        public double[] build_sbt() {
            double[] sbt = new double[this.sbt_entries];
            int entries = 0;
            if ((entries = this.inner_build_sbt(entries, sbt, this.sb_tree)) != this.sbt_entries) {
                throw new IllegalStateException("Something went wrong buildign sbt from tree.");
            }
            return sbt;
        }

        private int inner_build_sbt(int entries, double[] sbt, ScanBeamTree sbt_node) {
            if (sbt_node.less != null) {
                entries = this.inner_build_sbt(entries, sbt, sbt_node.less);
            }
            sbt[entries] = sbt_node.y;
            ++entries;
            if (sbt_node.more != null) {
                entries = this.inner_build_sbt(entries, sbt, sbt_node.more);
            }
            return entries;
        }
    }

    private static class EdgeTable {
        private List<EdgeNode> m_List = new ArrayList<EdgeNode>();

        private EdgeTable() {
        }

        public void addNode(double x, double y) {
            EdgeNode node = new EdgeNode();
            node.vertex.x = x;
            node.vertex.y = y;
            this.m_List.add(node);
        }

        public EdgeNode getNode(int index) {
            return this.m_List.get(index);
        }

        public boolean FWD_MIN(int i) {
            EdgeNode prev = this.m_List.get(Clip.PREV_INDEX(i, this.m_List.size()));
            EdgeNode next = this.m_List.get(Clip.NEXT_INDEX(i, this.m_List.size()));
            EdgeNode ith = this.m_List.get(i);
            return prev.vertex.getY() >= ith.vertex.getY() && next.vertex.getY() > ith.vertex.getY();
        }

        public boolean NOT_FMAX(int i) {
            EdgeNode next = this.m_List.get(Clip.NEXT_INDEX(i, this.m_List.size()));
            EdgeNode ith = this.m_List.get(i);
            return next.vertex.getY() > ith.vertex.getY();
        }

        public boolean REV_MIN(int i) {
            EdgeNode prev = this.m_List.get(Clip.PREV_INDEX(i, this.m_List.size()));
            EdgeNode next = this.m_List.get(Clip.NEXT_INDEX(i, this.m_List.size()));
            EdgeNode ith = this.m_List.get(i);
            return prev.vertex.getY() > ith.vertex.getY() && next.vertex.getY() >= ith.vertex.getY();
        }

        public boolean NOT_RMAX(int i) {
            EdgeNode prev = this.m_List.get(Clip.PREV_INDEX(i, this.m_List.size()));
            EdgeNode ith = this.m_List.get(i);
            return prev.vertex.getY() > ith.vertex.getY();
        }
    }

    private static class LmtNode {
        double y;
        EdgeNode first_bound;
        LmtNode next;

        public LmtNode(double yvalue) {
            this.y = yvalue;
        }
    }

    private static class TopPolygonNode {
        PolygonNode top_node = null;

        private TopPolygonNode() {
        }

        public PolygonNode add_local_min(double x, double y) {
            PolygonNode existing_min = this.top_node;
            this.top_node = new PolygonNode(existing_min, x, y);
            return this.top_node;
        }

        public void merge_left(PolygonNode p, PolygonNode q) {
            q.proxy.hole = true;
            if (p.proxy != q.proxy) {
                p.proxy.v[1].next = q.proxy.v[0];
                q.proxy.v[0] = p.proxy.v[0];
                PolygonNode target = p.proxy;
                PolygonNode node = this.top_node;
                while (node != null) {
                    if (node.proxy == target) {
                        node.active = 0;
                        node.proxy = q.proxy;
                    }
                    node = node.next;
                }
            }
        }

        public void merge_right(PolygonNode p, PolygonNode q) {
            q.proxy.hole = false;
            if (p.proxy != q.proxy) {
                q.proxy.v[1].next = p.proxy.v[0];
                q.proxy.v[1] = p.proxy.v[1];
                PolygonNode target = p.proxy;
                PolygonNode node = this.top_node;
                while (node != null) {
                    if (node.proxy == target) {
                        node.active = 0;
                        node.proxy = q.proxy;
                    }
                    node = node.next;
                }
            }
        }

        public int count_contours() {
            int nc = 0;
            PolygonNode polygon = this.top_node;
            while (polygon != null) {
                if (polygon.active != 0) {
                    int nv = 0;
                    VertexNode v = polygon.proxy.v[0];
                    while (v != null) {
                        ++nv;
                        v = v.next;
                    }
                    if (nv > 2) {
                        polygon.active = nv;
                        ++nc;
                    } else {
                        polygon.active = 0;
                    }
                }
                polygon = polygon.next;
            }
            return nc;
        }

        public Poly getResult(Class polyClass) {
            Poly result = Clip.createNewPoly(polyClass);
            int num_contours = this.count_contours();
            if (num_contours > 0) {
                Poly inner;
                int i;
                int c = 0;
                PolygonNode npoly_node = null;
                PolygonNode poly_node = this.top_node;
                while (poly_node != null) {
                    npoly_node = poly_node.next;
                    if (poly_node.active != 0) {
                        Poly poly = result;
                        if (num_contours > 1) {
                            poly = Clip.createNewPoly(polyClass);
                        }
                        if (poly_node.proxy.hole) {
                            poly.setIsHole(poly_node.proxy.hole);
                        }
                        VertexNode vtx = poly_node.proxy.v[0];
                        while (vtx != null) {
                            poly.add(vtx.x, vtx.y);
                            vtx = vtx.next;
                        }
                        if (num_contours > 1) {
                            result.add(poly);
                        }
                        ++c;
                    }
                    poly_node = npoly_node;
                }
                Poly orig = result;
                result = Clip.createNewPoly(polyClass);
                for (i = 0; i < orig.getNumInnerPoly(); ++i) {
                    inner = orig.getInnerPoly(i);
                    if (inner.isHole()) continue;
                    result.add(inner);
                }
                for (i = 0; i < orig.getNumInnerPoly(); ++i) {
                    inner = orig.getInnerPoly(i);
                    if (!inner.isHole()) continue;
                    result.add(inner);
                }
            }
            return result;
        }

        public void print() {
            System.out.println("---- out_poly ----");
            int c = 0;
            PolygonNode npoly_node = null;
            PolygonNode poly_node = this.top_node;
            while (poly_node != null) {
                System.out.println("contour=" + c + "  active=" + poly_node.active + "  hole=" + poly_node.proxy.hole);
                npoly_node = poly_node.next;
                if (poly_node.active != 0) {
                    int v = 0;
                    VertexNode vtx = poly_node.proxy.v[0];
                    while (vtx != null) {
                        System.out.println("v=" + v + "  vtx.x=" + vtx.x + "  vtx.y=" + vtx.y);
                        vtx = vtx.next;
                    }
                    ++c;
                }
                poly_node = npoly_node;
            }
        }
    }

    private static class AetTree {
        EdgeNode top_node;

        private AetTree() {
        }

        public void print() {
            System.out.println("");
            System.out.println("aet");
            EdgeNode edge = this.top_node;
            while (edge != null) {
                System.out.println("edge.vertex.x=" + edge.vertex.x + "  edge.vertex.y=" + edge.vertex.y);
                edge = edge.next;
            }
        }
    }

    private static class BundleState {
        private String m_State;
        public static final BundleState UNBUNDLED = new BundleState("UNBUNDLED");
        public static final BundleState BUNDLE_HEAD = new BundleState("BUNDLE_HEAD");
        public static final BundleState BUNDLE_TAIL = new BundleState("BUNDLE_TAIL");

        private BundleState(String state) {
            this.m_State = state;
        }

        public String toString() {
            return this.m_State;
        }
    }

    private static class HState {
        public static final int NH = 0;
        public static final int BH = 1;
        public static final int TH = 2;
        public static final int[][] next_h_state = new int[][]{{1, 2, 2, 1, 0, 0}, {0, 0, 0, 0, 2, 2}, {0, 0, 0, 0, 1, 1}};

        private HState() {
        }
    }

    private static class VertexType {
        public static final int NUL = 0;
        public static final int EMX = 1;
        public static final int ELI = 2;
        public static final int TED = 3;
        public static final int ERI = 4;
        public static final int RED = 5;
        public static final int IMM = 6;
        public static final int IMN = 7;
        public static final int EMN = 8;
        public static final int EMM = 9;
        public static final int LED = 10;
        public static final int ILI = 11;
        public static final int BED = 12;
        public static final int IRI = 13;
        public static final int IMX = 14;
        public static final int FUL = 15;

        private VertexType() {
        }

        public static int getType(int tr, int tl, int br, int bl) {
            return tr + (tl << 1) + (br << 2) + (bl << 3);
        }
    }

    private static class PolygonNode {
        int active;
        boolean hole;
        VertexNode[] v = new VertexNode[2];
        PolygonNode next;
        PolygonNode proxy;

        public PolygonNode(PolygonNode next, double x, double y) {
            VertexNode vn;
            this.v[0] = vn = new VertexNode(x, y);
            this.v[1] = vn;
            this.next = next;
            this.proxy = this;
            this.active = 1;
        }

        public void add_right(double x, double y) {
            VertexNode nv;
            this.proxy.v[1].next = nv = new VertexNode(x, y);
            this.proxy.v[1] = nv;
        }

        public void add_left(double x, double y) {
            VertexNode nv = new VertexNode(x, y);
            nv.next = this.proxy.v[0];
            this.proxy.v[0] = nv;
        }
    }

    private static class ItNode {
        EdgeNode[] ie = new EdgeNode[2];
        Point2D.Double point = new Point2D.Double();
        ItNode next;

        public ItNode(EdgeNode edge0, EdgeNode edge1, double x, double y, ItNode next) {
            this.ie[0] = edge0;
            this.ie[1] = edge1;
            this.point.x = x;
            this.point.y = y;
            this.next = next;
        }
    }

    private static class ScanBeamTree {
        double y;
        ScanBeamTree less;
        ScanBeamTree more;

        public ScanBeamTree(double yvalue) {
            this.y = yvalue;
        }
    }

    private static class VertexNode {
        double x;
        double y;
        VertexNode next;

        public VertexNode(double x, double y) {
            this.x = x;
            this.y = y;
            this.next = null;
        }
    }
}

