/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.gp.symbolic.example;

import com.lagodiuk.gp.symbolic.SymbolicRegressionEngine;
import com.lagodiuk.gp.symbolic.SymbolicRegressionIterationListener;
import com.lagodiuk.gp.symbolic.TabulatedFunctionFitness;
import com.lagodiuk.gp.symbolic.Target;
import com.lagodiuk.gp.symbolic.interpreter.Expression;
import com.lagodiuk.gp.symbolic.interpreter.Functions;
import java.util.LinkedList;
import java.util.List;

public class Launcher2 {
    public static void main(String[] args) {
        TabulatedFunctionFitness fitnessFunction = new TabulatedFunctionFitness(new Target().when("x", 0.0).targetIs(0.0), new Target().when("x", 1.0).targetIs(2.0), new Target().when("x", 2.0).targetIs(6.0), new Target().when("x", 3.0).targetIs(12.0), new Target().when("x", 4.0).targetIs(20.0), new Target().when("x", 5.0).targetIs(30.0), new Target().when("x", 6.0).targetIs(42.0));
        SymbolicRegressionEngine engine = new SymbolicRegressionEngine(fitnessFunction, Launcher2.list("x"), Launcher2.list(Functions.values()));
        engine.addIterationListener(new SymbolicRegressionIterationListener(){
            private double prevFitValue = -1.0;

            @Override
            public void update(SymbolicRegressionEngine engine) {
                Expression bestSyntaxTree = engine.getBestSyntaxTree();
                double currFitValue = engine.fitness(bestSyntaxTree);
                if (Double.compare(currFitValue, this.prevFitValue) != 0) {
                    System.out.println("Func = " + bestSyntaxTree.print());
                }
                System.out.println(String.format("%s \t %s", engine.getIteration(), currFitValue));
                this.prevFitValue = currFitValue;
                if (currFitValue < 10.0) {
                    engine.terminate();
                }
            }
        });
        engine.evolve(200);
        System.out.println(engine.getBestSyntaxTree().print());
    }

    private static <T> List<T> list(T ... items) {
        LinkedList<T> list = new LinkedList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }
}

