/*
 * Decompiled with CFR 0.152.
 */
package com.lagodiuk.ga;

import com.lagodiuk.ga.Chromosome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Population<C extends Chromosome<C>>
implements Iterable<C> {
    private static final int DEFAULT_NUMBER_OF_CHROMOSOMES = 32;
    private List<C> chromosomes = new ArrayList<C>(32);
    private final Random random = new Random();

    public void addChromosome(C chromosome) {
        this.chromosomes.add(chromosome);
    }

    public int getSize() {
        return this.chromosomes.size();
    }

    public C getRandomChromosome() {
        int numOfChromosomes = this.chromosomes.size();
        int indx = this.random.nextInt(numOfChromosomes);
        return (C)((Chromosome)this.chromosomes.get(indx));
    }

    public C getChromosomeByIndex(int indx) {
        return (C)((Chromosome)this.chromosomes.get(indx));
    }

    public void sortPopulationByFitness(Comparator<C> chromosomesComparator) {
        Collections.shuffle(this.chromosomes);
        Collections.sort(this.chromosomes, chromosomesComparator);
    }

    public void trim(int len) {
        this.chromosomes = this.chromosomes.subList(0, len);
    }

    @Override
    public Iterator<C> iterator() {
        return this.chromosomes.iterator();
    }
}

