/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.shortestpath.MinimumSpanningForest2;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MinimumSpanningTreeDemo
extends JApplet {
    Graph<String, Number> graph;
    Forest<String, Number> tree;
    VisualizationViewer<String, Number> vv0;
    VisualizationViewer<String, Number> vv1;
    VisualizationViewer<String, Number> vv2;
    MutableTransformer layoutTransformer;
    Dimension preferredSize = new Dimension(300, 300);
    Dimension preferredLayoutSize = new Dimension(400, 400);
    Dimension preferredSizeRect = new Dimension(500, 250);

    public MinimumSpanningTreeDemo() {
        this.graph = TestGraphs.getDemoGraph();
        MinimumSpanningForest2<String, Number> prim = new MinimumSpanningForest2<String, Number>(this.graph, new DelegateForest(), DelegateTree.getFactory(), Functions.constant((Object)1.0));
        this.tree = prim.getForest();
        KKLayout<String, Number> layout0 = new KKLayout<String, Number>(this.graph);
        layout0.setSize(this.preferredLayoutSize);
        TreeLayout<String, Number> layout1 = new TreeLayout<String, Number>(this.tree);
        StaticLayout<String, Number> layout2 = new StaticLayout<String, Number>(this.graph, layout1);
        DefaultVisualizationModel<String, Number> vm0 = new DefaultVisualizationModel<String, Number>(layout0, this.preferredSize);
        DefaultVisualizationModel<String, Number> vm1 = new DefaultVisualizationModel<String, Number>(layout1, this.preferredSizeRect);
        DefaultVisualizationModel<String, Number> vm2 = new DefaultVisualizationModel<String, Number>(layout2, this.preferredSizeRect);
        this.vv0 = new VisualizationViewer<String, Number>(vm0, this.preferredSize);
        this.vv1 = new VisualizationViewer<String, Number>(vm1, this.preferredSizeRect);
        this.vv2 = new VisualizationViewer<String, Number>(vm2, this.preferredSizeRect);
        this.vv1.getRenderContext().setMultiLayerTransformer(this.vv0.getRenderContext().getMultiLayerTransformer());
        this.vv2.getRenderContext().setMultiLayerTransformer(this.vv0.getRenderContext().getMultiLayerTransformer());
        this.vv1.getRenderContext().setEdgeShapeTransformer(EdgeShape.line(this.graph));
        this.vv0.addChangeListener(this.vv1);
        this.vv1.addChangeListener(this.vv2);
        this.vv0.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        this.vv2.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        Color back = Color.decode("0xffffbb");
        this.vv0.setBackground(back);
        this.vv1.setBackground(back);
        this.vv2.setBackground(back);
        this.vv0.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv0.setForeground(Color.darkGray);
        this.vv1.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv1.setForeground(Color.darkGray);
        this.vv2.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv2.setForeground(Color.darkGray);
        MultiPickedState ps = new MultiPickedState();
        this.vv0.setPickedVertexState(ps);
        this.vv1.setPickedVertexState(ps);
        this.vv2.setPickedVertexState(ps);
        MultiPickedState pes = new MultiPickedState();
        this.vv0.setPickedEdgeState(pes);
        this.vv1.setPickedEdgeState(pes);
        this.vv2.setPickedEdgeState(pes);
        this.vv0.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.vv0.getPickedEdgeState(), Color.black, Color.red));
        this.vv0.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(this.vv0.getPickedVertexState(), Color.red, Color.yellow));
        this.vv1.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.vv1.getPickedEdgeState(), Color.black, Color.red));
        this.vv1.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(this.vv1.getPickedVertexState(), Color.red, Color.yellow));
        this.vv0.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv1.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv2.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv0.setLayout(new BorderLayout());
        this.vv1.setLayout(new BorderLayout());
        this.vv2.setLayout(new BorderLayout());
        Font font = this.vv0.getFont().deriveFont(1, 16.0f);
        JLabel vv0Label = new JLabel("<html>Original Graph<p>using KKLayout");
        vv0Label.setFont(font);
        JLabel vv1Label = new JLabel("Minimum Spanning Trees");
        vv1Label.setFont(font);
        JLabel vv2Label = new JLabel("Original Graph using TreeLayout");
        vv2Label.setFont(font);
        JPanel flow0 = new JPanel();
        flow0.setOpaque(false);
        JPanel flow1 = new JPanel();
        flow1.setOpaque(false);
        JPanel flow2 = new JPanel();
        flow2.setOpaque(false);
        flow0.add(vv0Label);
        flow1.add(vv1Label);
        flow2.add(vv2Label);
        this.vv0.add((Component)flow0, "North");
        this.vv1.add((Component)flow1, "North");
        this.vv2.add((Component)flow2, "North");
        Container content = this.getContentPane();
        JPanel grid = new JPanel(new GridLayout(0, 1));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new GraphZoomScrollPane(this.vv0), "West");
        grid.add(new GraphZoomScrollPane(this.vv1));
        grid.add(new GraphZoomScrollPane(this.vv2));
        panel.add(grid);
        content.add(panel);
        DefaultModalGraphMouse gm0 = new DefaultModalGraphMouse();
        DefaultModalGraphMouse gm1 = new DefaultModalGraphMouse();
        DefaultModalGraphMouse gm2 = new DefaultModalGraphMouse();
        this.vv0.setGraphMouse(gm0);
        this.vv1.setGraphMouse(gm1);
        this.vv2.setGraphMouse(gm2);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        this.vv0.scaleToLayout(scaler);
        this.vv1.scaleToLayout(scaler);
        this.vv2.scaleToLayout(scaler);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(MinimumSpanningTreeDemo.this.vv1, 1.1f, MinimumSpanningTreeDemo.this.vv1.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(MinimumSpanningTreeDemo.this.vv1, 0.9090909f, MinimumSpanningTreeDemo.this.vv1.getCenter());
            }
        });
        JPanel zoomPanel = new JPanel(new GridLayout(1, 2));
        zoomPanel.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        gm1.getModeComboBox().addItemListener(gm2.getModeListener());
        gm1.getModeComboBox().addItemListener(gm0.getModeListener());
        modePanel.add(gm1.getModeComboBox());
        JPanel controls = new JPanel();
        zoomPanel.add(plus);
        zoomPanel.add(minus);
        controls.add(zoomPanel);
        controls.add(modePanel);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new MinimumSpanningTreeDemo());
        f.pack();
        f.setVisible(true);
    }
}

