/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InternalFrameSatelliteViewDemo {
    static final String instructions = "<html><b><h2><center>Instructions for Mouse Listeners</center></h2></b><p>There are two modes, Transforming and Picking.<p>The modes are selected with a toggle button.<p><p><b>Transforming Mode:</b><ul><li>Mouse1+drag pans the graph<li>Mouse1+Shift+drag rotates the graph<li>Mouse1+CTRL(or Command)+drag shears the graph</ul><b>Picking Mode:</b><ul><li>Mouse1 on a Vertex selects the vertex<li>Mouse1 elsewhere unselects all Vertices<li>Mouse1+Shift on a Vertex adds/removes Vertex selection<li>Mouse1+drag on a Vertex moves all selected Vertices<li>Mouse1+drag elsewhere selects Vertices in a region<li>Mouse1+Shift+drag adds selection of Vertices in a new region<li>Mouse1+CTRL on a Vertex selects the vertex and centers the display on it</ul><b>Both Modes:</b><ul><li>Mousewheel scales the layout &gt; 1 and scales the view &lt; 1";
    Graph<String, Number> graph = TestGraphs.getOneComponentGraph();
    VisualizationViewer<String, Number> vv;
    VisualizationViewer<String, Number> satellite;
    JInternalFrame dialog;
    JDesktopPane desktop;

    public InternalFrameSatelliteViewDemo() {
        ISOMLayout<String, Number> layout = new ISOMLayout<String, Number>(this.graph);
        this.vv = new VisualizationViewer<String, Number>(layout, new Dimension(600, 600));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.vv.getPickedEdgeState(), Color.black, Color.cyan));
        this.vv.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(this.vv.getPickedVertexState(), Color.red, Color.yellow));
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.satellite = new SatelliteVisualizationViewer<String, Number>(this.vv, new Dimension(200, 200));
        this.satellite.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.satellite.getPickedEdgeState(), Color.black, Color.cyan));
        this.satellite.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(this.satellite.getPickedVertexState(), Color.red, Color.yellow));
        CrossoverScalingControl satelliteScaler = new CrossoverScalingControl();
        this.satellite.scaleToLayout(satelliteScaler);
        JFrame frame = new JFrame();
        this.desktop = new JDesktopPane();
        Container content = frame.getContentPane();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.desktop);
        content.add(panel);
        frame.setDefaultCloseOperation(3);
        JInternalFrame vvFrame = new JInternalFrame();
        vvFrame.getContentPane().add(this.vv);
        vvFrame.pack();
        vvFrame.setVisible(true);
        this.desktop.add(vvFrame);
        try {
            vvFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.dialog = new JInternalFrame();
        this.desktop.add(this.dialog);
        content = this.dialog.getContentPane();
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(InternalFrameSatelliteViewDemo.this.vv, 1.1f, InternalFrameSatelliteViewDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(InternalFrameSatelliteViewDemo.this.vv, 0.9090909f, InternalFrameSatelliteViewDemo.this.vv.getCenter());
            }
        });
        JButton dismiss = new JButton("Dismiss");
        dismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InternalFrameSatelliteViewDemo.this.dialog.setVisible(false);
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showInternalMessageDialog(InternalFrameSatelliteViewDemo.this.dialog, InternalFrameSatelliteViewDemo.instructions, "Instructions", -1);
            }
        });
        JPanel controls = new JPanel(new GridLayout(2, 2));
        controls.add(plus);
        controls.add(minus);
        controls.add(dismiss);
        controls.add(help);
        content.add(this.satellite);
        content.add((Component)controls, "South");
        JButton zoomer = new JButton("Show Satellite View");
        zoomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InternalFrameSatelliteViewDemo.this.dialog.pack();
                InternalFrameSatelliteViewDemo.this.dialog.setLocation(InternalFrameSatelliteViewDemo.this.desktop.getWidth() - InternalFrameSatelliteViewDemo.this.dialog.getWidth(), 0);
                InternalFrameSatelliteViewDemo.this.dialog.show();
                try {
                    InternalFrameSatelliteViewDemo.this.dialog.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        JComboBox<ModalGraphMouse.Mode> modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(((ModalGraphMouse)this.satellite.getGraphMouse()).getModeListener());
        JPanel p = new JPanel();
        p.add(zoomer);
        p.add(modeBox);
        frame.getContentPane().add((Component)p, "South");
        frame.setSize(800, 800);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        new InternalFrameSatelliteViewDemo();
    }
}

