/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml;

import edu.uci.ics.jung.io.graphml.Key;
import edu.uci.ics.jung.io.graphml.Metadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KeyMap {
    private final Map<Metadata.MetadataType, List<Key>> map = new HashMap<Metadata.MetadataType, List<Key>>();

    public void addKey(Key key) {
        switch (key.getForType()) {
            case EDGE: {
                this.getKeyList(Metadata.MetadataType.EDGE).add(key);
                break;
            }
            case ENDPOINT: {
                this.getKeyList(Metadata.MetadataType.ENDPOINT).add(key);
                break;
            }
            case GRAPH: {
                this.getKeyList(Metadata.MetadataType.GRAPH).add(key);
                break;
            }
            case HYPEREDGE: {
                this.getKeyList(Metadata.MetadataType.HYPEREDGE).add(key);
                break;
            }
            case NODE: {
                this.getKeyList(Metadata.MetadataType.NODE).add(key);
                break;
            }
            case PORT: {
                this.getKeyList(Metadata.MetadataType.PORT).add(key);
                break;
            }
            default: {
                this.getKeyList(Metadata.MetadataType.EDGE).add(key);
                this.getKeyList(Metadata.MetadataType.ENDPOINT).add(key);
                this.getKeyList(Metadata.MetadataType.GRAPH).add(key);
                this.getKeyList(Metadata.MetadataType.HYPEREDGE).add(key);
                this.getKeyList(Metadata.MetadataType.NODE).add(key);
                this.getKeyList(Metadata.MetadataType.PORT).add(key);
            }
        }
    }

    public void applyKeys(Metadata metadata) {
        List<Key> keys = this.getKeyList(metadata.getMetadataType());
        for (Key key : keys) {
            key.applyKey(metadata);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<Metadata.MetadataType, List<Key>>> entrySet() {
        return this.map.entrySet();
    }

    private List<Key> getKeyList(Metadata.MetadataType type) {
        List<Key> keys = this.map.get((Object)type);
        if (keys == null) {
            keys = new ArrayList<Key>();
            this.map.put(type, keys);
        }
        return keys;
    }
}

