/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.util.MapSettableTransformer;
import edu.uci.ics.jung.algorithms.util.SettableTransformer;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class PajekNetReader<G extends Graph<V, E>, V, E> {
    protected Supplier<V> vertex_factory;
    protected Supplier<E> edge_factory;
    protected SettableTransformer<V, String> vertex_labels = new MapSettableTransformer(new HashMap());
    protected SettableTransformer<V, Point2D> vertex_locations = new MapSettableTransformer(new HashMap());
    protected SettableTransformer<E, Number> edge_weights = new MapSettableTransformer(new HashMap());
    private static final Predicate<String> v_pred = new StartsWithPredicate("*vertices");
    private static final Predicate<String> a_pred = new StartsWithPredicate("*arcs");
    private static final Predicate<String> e_pred = new StartsWithPredicate("*edges");
    private static final Predicate<String> t_pred = new StartsWithPredicate("*");
    private static final Predicate<String> c_pred = Predicates.or(a_pred, e_pred);
    protected static final Predicate<String> l_pred = ListTagPred.getInstance();

    public PajekNetReader(Supplier<V> vertex_factory, Supplier<E> edge_factory) {
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
    }

    public PajekNetReader(Supplier<E> edge_factory) {
        this(null, edge_factory);
    }

    public G load(String filename, Supplier<? extends G> graph_factory) throws IOException {
        return (G)this.load((Reader)new FileReader(filename), (Graph)graph_factory.get());
    }

    public G load(Reader reader, Supplier<? extends G> graph_factory) throws IOException {
        return (G)this.load(reader, (Graph)graph_factory.get());
    }

    public G load(String filename, G g) throws IOException {
        if (g == null) {
            throw new IllegalArgumentException("Graph provided must be non-null");
        }
        return this.load((Reader)new FileReader(filename), g);
    }

    public G load(Reader reader, G g) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        String curLine = this.skip(br, v_pred);
        if (curLine == null) {
            return g;
        }
        StringTokenizer st = new StringTokenizer(curLine);
        st.nextToken();
        int num_vertices = Integer.parseInt(st.nextToken());
        ArrayList id = null;
        if (this.vertex_factory != null) {
            for (int i = 1; i <= num_vertices; ++i) {
                g.addVertex((Object)this.vertex_factory.get());
            }
            id = new ArrayList(g.getVertices());
        }
        curLine = null;
        while (br.ready() && (curLine = br.readLine()) != null && !t_pred.apply((Object)curLine)) {
            if (curLine == "") continue;
            try {
                this.readVertex(curLine, id, num_vertices);
            }
            catch (IllegalArgumentException iae) {
                br.close();
                reader.close();
                throw iae;
            }
        }
        curLine = this.readArcsOrEdges(curLine, br, (Graph<V, E>)g, id, this.edge_factory);
        this.readArcsOrEdges(curLine, br, (Graph<V, E>)g, id, this.edge_factory);
        br.close();
        reader.close();
        return g;
    }

    private void readVertex(String curLine, List<V> id, int num_vertices) {
        String index;
        String[] parts = null;
        int coord_idx = -1;
        String label = null;
        if (curLine.indexOf(34) != -1) {
            String[] initial_split = curLine.trim().split("\"");
            if (initial_split.length < 2 || initial_split.length > 3) {
                throw new IllegalArgumentException("Unbalanced (or too many) quote marks in " + curLine);
            }
            index = initial_split[0].trim();
            label = initial_split[1].trim();
            if (initial_split.length == 3) {
                parts = initial_split[2].trim().split("\\s+", -1);
            }
            coord_idx = 0;
        } else {
            parts = curLine.trim().split("\\s+", -1);
            index = parts[0];
            switch (parts.length) {
                case 1: {
                    break;
                }
                case 2: {
                    label = parts[1];
                    break;
                }
                case 3: {
                    coord_idx = 1;
                    break;
                }
                default: {
                    coord_idx = 2;
                }
            }
        }
        int v_id = Integer.parseInt(index) - 1;
        if (v_id >= num_vertices || v_id < 0) {
            throw new IllegalArgumentException("Vertex number " + v_id + "is not in the range [1," + num_vertices + "]");
        }
        Object v = id != null ? id.get(v_id) : new Integer(v_id);
        if (label != null && label.length() > 0 && this.vertex_labels != null) {
            this.vertex_labels.set(v, label);
        }
        if (coord_idx != -1 && parts != null && parts.length >= coord_idx + 2 && this.vertex_locations != null) {
            double x = Double.parseDouble(parts[coord_idx]);
            double y = Double.parseDouble(parts[coord_idx + 1]);
            this.vertex_locations.set(v, new Point2D.Double(x, y));
        }
    }

    private String readArcsOrEdges(String curLine, BufferedReader br, Graph<V, E> g, List<V> id, Supplier<E> edge_factory) throws IOException {
        String nextLine = curLine;
        if (!c_pred.apply((Object)curLine)) {
            nextLine = this.skip(br, c_pred);
        }
        boolean reading_arcs = false;
        boolean reading_edges = false;
        EdgeType directedness = null;
        if (a_pred.apply((Object)nextLine)) {
            if (g instanceof UndirectedGraph) {
                throw new IllegalArgumentException("Supplied undirected-only graph cannot be populated with directed edges");
            }
            reading_arcs = true;
            directedness = EdgeType.DIRECTED;
        }
        if (e_pred.apply((Object)nextLine)) {
            if (g instanceof DirectedGraph) {
                throw new IllegalArgumentException("Supplied directed-only graph cannot be populated with undirected edges");
            }
            reading_edges = true;
            directedness = EdgeType.UNDIRECTED;
        }
        if (!reading_arcs && !reading_edges) {
            return nextLine;
        }
        boolean is_list = l_pred.apply((Object)nextLine);
        while (br.ready() && (nextLine = br.readLine()) != null && !t_pred.apply((Object)nextLine)) {
            if (curLine == "") continue;
            StringTokenizer st = new StringTokenizer(nextLine.trim());
            int vid1 = Integer.parseInt(st.nextToken()) - 1;
            Object v1 = id != null ? id.get(vid1) : new Integer(vid1);
            if (is_list) {
                do {
                    this.createAddEdge(st, v1, directedness, g, id, edge_factory);
                } while (st.hasMoreTokens());
                continue;
            }
            E e = this.createAddEdge(st, v1, directedness, g, id, edge_factory);
            if (this.edge_weights == null || !st.hasMoreTokens()) continue;
            this.edge_weights.set(e, new Float(st.nextToken()));
        }
        return nextLine;
    }

    protected E createAddEdge(StringTokenizer st, V v1, EdgeType directed, Graph<V, E> g, List<V> id, Supplier<E> edge_factory) {
        int vid2 = Integer.parseInt(st.nextToken()) - 1;
        Object v2 = id != null ? id.get(vid2) : new Integer(vid2);
        Object e = edge_factory.get();
        g.addEdge(e, v1, v2, directed);
        return (E)e;
    }

    protected String skip(BufferedReader br, Predicate<String> p) throws IOException {
        String curLine;
        while (br.ready() && (curLine = br.readLine()) != null) {
            if (!p.apply((Object)(curLine = curLine.trim()))) continue;
            return curLine;
        }
        return null;
    }

    public SettableTransformer<V, Point2D> getVertexLocationTransformer() {
        return this.vertex_locations;
    }

    public void setVertexLocationTransformer(SettableTransformer<V, Point2D> vertex_locations) {
        this.vertex_locations = vertex_locations;
    }

    public SettableTransformer<V, String> getVertexLabeller() {
        return this.vertex_labels;
    }

    public void setVertexLabeller(SettableTransformer<V, String> vertex_labels) {
        this.vertex_labels = vertex_labels;
    }

    public SettableTransformer<E, Number> getEdgeWeightTransformer() {
        return this.edge_weights;
    }

    public void setEdgeWeightTransformer(SettableTransformer<E, Number> edge_weights) {
        this.edge_weights = edge_weights;
    }

    protected static class ListTagPred
    implements Predicate<String> {
        protected static ListTagPred instance;

        protected ListTagPred() {
        }

        protected static ListTagPred getInstance() {
            if (instance == null) {
                instance = new ListTagPred();
            }
            return instance;
        }

        public boolean apply(String s) {
            return s != null && s.toLowerCase().endsWith("list");
        }
    }

    protected static class StartsWithPredicate
    implements Predicate<String> {
        private String tag;

        protected StartsWithPredicate(String s) {
            this.tag = s;
        }

        public boolean apply(String str) {
            return str != null && str.toLowerCase().startsWith(this.tag);
        }
    }
}

