/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.collect.BiMap;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.algorithms.util.Indexer;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import junit.framework.TestCase;

public class TestShortestPath
extends TestCase {
    private DirectedGraph<String, Integer> dg;
    private UndirectedGraph<String, Integer> ug;
    private static int[][] edges = new int[][]{{1, 2, 2}, {1, 4, 1}, {2, 4, 3}, {2, 5, 10}, {3, 1, 4}, {3, 6, 5}, {4, 3, 2}, {4, 5, 2}, {4, 6, 8}, {4, 7, 4}, {5, 7, 6}, {7, 6, 1}, {8, 9, 4}, {9, 10, 1}, {10, 8, 2}};
    private static Integer[][] ug_incomingEdges = new Integer[][]{{null, new Integer(0), new Integer(6), new Integer(1), new Integer(7), new Integer(11), new Integer(9), null, null, null}, {new Integer(0), null, new Integer(6), new Integer(2), new Integer(7), new Integer(11), new Integer(9), null, null, null}, {new Integer(1), new Integer(2), null, new Integer(6), new Integer(7), new Integer(5), new Integer(9), null, null, null}, {new Integer(1), new Integer(2), new Integer(6), null, new Integer(7), new Integer(11), new Integer(9), null, null, null}, {new Integer(1), new Integer(2), new Integer(6), new Integer(7), null, new Integer(11), new Integer(10), null, null, null}, {new Integer(1), new Integer(2), new Integer(5), new Integer(9), new Integer(10), null, new Integer(11), null, null, null}, {new Integer(1), new Integer(2), new Integer(5), new Integer(9), new Integer(10), new Integer(11), null, null, null, null}, {null, null, null, null, null, null, null, null, new Integer(13), new Integer(14)}, {null, null, null, null, null, null, null, new Integer(14), null, new Integer(13)}, {null, null, null, null, null, null, null, new Integer(14), new Integer(13), null}};
    private static Integer[][] dg_incomingEdges = new Integer[][]{{null, new Integer(0), new Integer(6), new Integer(1), new Integer(7), new Integer(11), new Integer(9), null, null, null}, {new Integer(4), null, new Integer(6), new Integer(2), new Integer(7), new Integer(11), new Integer(9), null, null, null}, {new Integer(4), new Integer(0), null, new Integer(1), new Integer(7), new Integer(5), new Integer(9), null, null, null}, {new Integer(4), new Integer(0), new Integer(6), null, new Integer(7), new Integer(11), new Integer(9), null, null, null}, {null, null, null, null, null, new Integer(11), new Integer(10), null, null, null}, {null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, new Integer(11), null, null, null, null}, {null, null, null, null, null, null, null, null, new Integer(12), new Integer(13)}, {null, null, null, null, null, null, null, new Integer(14), null, new Integer(13)}, {null, null, null, null, null, null, null, new Integer(14), new Integer(12), null}};
    private static double[][] dg_distances = new double[][]{{0.0, 2.0, 3.0, 1.0, 3.0, 6.0, 5.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {9.0, 0.0, 5.0, 3.0, 5.0, 8.0, 7.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {4.0, 6.0, 0.0, 5.0, 7.0, 5.0, 9.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {6.0, 8.0, 2.0, 0.0, 2.0, 5.0, 4.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 7.0, 6.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 4.0, 5.0}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 3.0, 0.0, 1.0}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 2.0, 6.0, 0.0}};
    private static double[][] ug_distances = new double[][]{{0.0, 2.0, 3.0, 1.0, 3.0, 6.0, 5.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {2.0, 0.0, 5.0, 3.0, 5.0, 8.0, 7.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {3.0, 5.0, 0.0, 2.0, 4.0, 5.0, 6.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {1.0, 3.0, 2.0, 0.0, 2.0, 5.0, 4.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {3.0, 5.0, 4.0, 2.0, 0.0, 7.0, 6.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {6.0, 8.0, 5.0, 5.0, 7.0, 0.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {5.0, 7.0, 6.0, 4.0, 6.0, 1.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 3.0, 2.0}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 3.0, 0.0, 1.0}, {Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 2.0, 1.0, 0.0}};
    private static Integer[][] shortestPaths1 = new Integer[][]{null, {new Integer(0)}, {new Integer(1), new Integer(6)}, {new Integer(1)}, {new Integer(1), new Integer(7)}, {new Integer(1), new Integer(9), new Integer(11)}, {new Integer(1), new Integer(9)}, null, null, null};
    private Map<Graph<String, Integer>, Integer[]> edgeArrays;
    private Map<Integer, Number> edgeWeights;
    private Function<Integer, Number> nev;
    private Supplier<String> vertexFactoryDG = new Supplier<String>(){
        int count = 0;

        public String get() {
            return "V" + this.count++;
        }
    };
    private Supplier<String> vertexFactoryUG = new Supplier<String>(){
        int count = 0;

        public String get() {
            return "U" + this.count++;
        }
    };
    BiMap<String, Integer> did;
    BiMap<String, Integer> uid;

    protected void setUp() {
        this.edgeWeights = new HashMap<Integer, Number>();
        this.nev = Functions.forMap(this.edgeWeights);
        this.dg = new DirectedSparseMultigraph<String, Integer>();
        for (int i = 0; i < dg_distances.length; ++i) {
            this.dg.addVertex((String)this.vertexFactoryDG.get());
        }
        this.did = Indexer.create(this.dg.getVertices(), 1);
        Integer[] dg_array = new Integer[edges.length];
        this.addEdges(this.dg, this.did, dg_array);
        this.ug = new UndirectedSparseMultigraph<String, Integer>();
        for (int i = 0; i < ug_distances.length; ++i) {
            this.ug.addVertex((String)this.vertexFactoryUG.get());
        }
        this.uid = Indexer.create(this.ug.getVertices(), 1);
        Integer[] ug_array = new Integer[edges.length];
        this.addEdges(this.ug, this.uid, ug_array);
        this.edgeArrays = new HashMap<Graph<String, Integer>, Integer[]>();
        this.edgeArrays.put(this.dg, dg_array);
        this.edgeArrays.put(this.ug, ug_array);
    }

    protected void tearDown() throws Exception {
    }

    public void exceptionTest(Graph<String, Integer> g, BiMap<String, Integer> indexer, int index) {
        DijkstraShortestPath<String, Integer> dsp = new DijkstraShortestPath<String, Integer>(g, this.nev);
        String start = (String)indexer.inverse().get((Object)index);
        Integer e = null;
        String v = "NOT IN GRAPH";
        try {
            dsp.getDistance(start, v);
            TestShortestPath.fail((String)"getDistance(): illegal destination vertex");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getDistance(v, start);
            TestShortestPath.fail((String)"getDistance(): illegal source vertex");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getDistanceMap(v, 1);
            TestShortestPath.fail((String)"getDistanceMap(): illegal source vertex");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getDistanceMap(start, 0);
            TestShortestPath.fail((String)"getDistanceMap(): too few vertices requested");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getDistanceMap(start, g.getVertexCount() + 1);
            TestShortestPath.fail((String)"getDistanceMap(): too many vertices requested");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getIncomingEdge(start, v);
            TestShortestPath.fail((String)"getIncomingEdge(): illegal destination vertex");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getIncomingEdge(v, start);
            TestShortestPath.fail((String)"getIncomingEdge(): illegal source vertex");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getIncomingEdgeMap(v, 1);
            TestShortestPath.fail((String)"getIncomingEdgeMap(): illegal source vertex");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getIncomingEdgeMap(start, 0);
            TestShortestPath.fail((String)"getIncomingEdgeMap(): too few vertices requested");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            dsp.getDistanceMap(start, g.getVertexCount() + 1);
            TestShortestPath.fail((String)"getIncomingEdgeMap(): too many vertices requested");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            String v1 = (String)indexer.inverse().get((Object)1);
            String v2 = (String)indexer.inverse().get((Object)7);
            e = g.getEdgeCount() + 1;
            g.addEdge(e, v1, v2);
            this.edgeWeights.put(e, -2);
            dsp.reset();
            dsp.getDistanceMap(start);
            TestShortestPath.fail((String)"DijkstraShortestPath should not accept negative edge weights");
        }
        catch (IllegalArgumentException iae) {
            g.removeEdge(e);
        }
    }

    public void testDijkstra() {
        int i;
        this.setUp();
        this.exceptionTest(this.dg, this.did, 1);
        this.setUp();
        this.exceptionTest(this.ug, this.uid, 1);
        this.setUp();
        this.getPathTest(this.dg, this.did, 1);
        this.setUp();
        this.getPathTest(this.ug, this.uid, 1);
        for (i = 1; i <= dg_distances.length; ++i) {
            this.setUp();
            this.weightedTest(this.dg, this.did, i, true);
            this.setUp();
            this.weightedTest(this.dg, this.did, i, false);
        }
        for (i = 1; i <= ug_distances.length; ++i) {
            this.setUp();
            this.weightedTest(this.ug, this.uid, i, true);
            this.setUp();
            this.weightedTest(this.ug, this.uid, i, false);
        }
    }

    private void getPathTest(Graph<String, Integer> g, BiMap<String, Integer> indexer, int index) {
        DijkstraShortestPath<String, Integer> dsp = new DijkstraShortestPath<String, Integer>(g, this.nev);
        String start = (String)indexer.inverse().get((Object)index);
        Integer[] edge_array = this.edgeArrays.get(g);
        Integer[] incomingEdges1 = null;
        if (g instanceof DirectedGraph) {
            incomingEdges1 = dg_incomingEdges[index - 1];
        }
        if (g instanceof UndirectedGraph) {
            incomingEdges1 = ug_incomingEdges[index - 1];
        }
        TestShortestPath.assertEquals((int)incomingEdges1.length, (int)g.getVertexCount());
        dsp.reset();
        for (int i = 1; i <= incomingEdges1.length; ++i) {
            List<Integer> shortestPath = dsp.getPath(start, (String)indexer.inverse().get((Object)i));
            Integer[] indices = shortestPaths1[i - 1];
            ListIterator<Integer> iter = shortestPath.listIterator();
            while (iter.hasNext()) {
                int j = iter.nextIndex();
                Integer e = iter.next();
                if (e != null) {
                    TestShortestPath.assertEquals((Object)edge_array[indices[j]], (Object)e);
                    continue;
                }
                TestShortestPath.assertNull((Object)indices[j]);
            }
        }
    }

    private void weightedTest(Graph<String, Integer> g, BiMap<String, Integer> indexer, int index, boolean cached) {
        int i;
        int i2;
        String v;
        int i3;
        String start = (String)indexer.inverse().get((Object)index);
        double[] distances1 = null;
        Integer[] incomingEdges1 = null;
        if (g instanceof DirectedGraph) {
            distances1 = dg_distances[index - 1];
            incomingEdges1 = dg_incomingEdges[index - 1];
        }
        if (g instanceof UndirectedGraph) {
            distances1 = ug_distances[index - 1];
            incomingEdges1 = ug_incomingEdges[index - 1];
        }
        TestShortestPath.assertEquals((int)distances1.length, (int)g.getVertexCount());
        TestShortestPath.assertEquals((int)incomingEdges1.length, (int)g.getVertexCount());
        DijkstraShortestPath<String, Integer> dsp = new DijkstraShortestPath<String, Integer>(g, this.nev, cached);
        Integer[] edge_array = this.edgeArrays.get(g);
        for (i3 = 1; i3 <= distances1.length; ++i3) {
            v = (String)indexer.inverse().get((Object)i3);
            Number n = dsp.getDistance(start, v);
            double d = distances1[i3 - 1];
            double dist = n == null ? Double.POSITIVE_INFINITY : n.doubleValue();
            TestShortestPath.assertEquals((double)d, (double)dist, (double)0.001);
        }
        dsp.reset();
        for (i3 = 1; i3 <= incomingEdges1.length; ++i3) {
            v = (String)indexer.inverse().get((Object)i3);
            Integer e = dsp.getIncomingEdge(start, v);
            if (e != null) {
                TestShortestPath.assertEquals((Object)edge_array[incomingEdges1[i3 - 1]], (Object)e);
                continue;
            }
            TestShortestPath.assertNull((Object)incomingEdges1[i3 - 1]);
        }
        dsp.reset();
        Map<String, Number> distances = dsp.getDistanceMap(start);
        TestShortestPath.assertTrue((distances.size() <= g.getVertexCount() ? 1 : 0) != 0);
        double d_prev = 0.0;
        HashSet<String> reachable = new HashSet<String>();
        for (String cur : distances.keySet()) {
            double d_cur = (Double)distances.get(cur);
            TestShortestPath.assertTrue((d_cur >= d_prev ? 1 : 0) != 0);
            d_prev = d_cur;
            i2 = (Integer)indexer.get((Object)cur);
            TestShortestPath.assertEquals((double)distances1[i2 - 1], (double)d_cur, (double)0.001);
            reachable.add(cur);
        }
        for (String v2 : g.getVertices()) {
            TestShortestPath.assertEquals((boolean)reachable.contains(v2), (boolean)distances.keySet().contains(v2));
        }
        dsp.reset();
        Map<String, Integer> incomingEdgeMap = dsp.getIncomingEdgeMap(start);
        TestShortestPath.assertTrue((incomingEdgeMap.size() <= g.getVertexCount() ? 1 : 0) != 0);
        for (String v3 : incomingEdgeMap.keySet()) {
            Integer e = incomingEdgeMap.get(v3);
            i2 = (Integer)indexer.get((Object)v3);
            if (e != null) {
                TestShortestPath.assertEquals((Object)edge_array[incomingEdges1[i2 - 1]], (Object)e);
                continue;
            }
            TestShortestPath.assertNull((Object)incomingEdges1[i2 - 1]);
        }
        dsp.reset();
        for (i = 1; i <= distances1.length; ++i) {
            distances = dsp.getDistanceMap(start, i);
            TestShortestPath.assertTrue((distances.size() <= i ? 1 : 0) != 0);
            d_prev = 0.0;
            reachable.clear();
            for (String cur : distances.keySet()) {
                double d_cur = (Double)distances.get(cur);
                TestShortestPath.assertTrue((d_cur >= d_prev ? 1 : 0) != 0);
                d_prev = d_cur;
                int j = (Integer)indexer.get((Object)cur);
                TestShortestPath.assertEquals((double)distances1[j - 1], (double)d_cur, (double)0.001);
                reachable.add(cur);
            }
            for (String v4 : g.getVertices()) {
                TestShortestPath.assertEquals((boolean)reachable.contains(v4), (boolean)distances.keySet().contains(v4));
            }
        }
        dsp.reset();
        for (i = 1; i <= incomingEdges1.length; ++i) {
            incomingEdgeMap = dsp.getIncomingEdgeMap(start, i);
            TestShortestPath.assertTrue((incomingEdgeMap.size() <= i ? 1 : 0) != 0);
            for (String v4 : incomingEdgeMap.keySet()) {
                Integer e = incomingEdgeMap.get(v4);
                int j = (Integer)indexer.get((Object)v4);
                if (e != null) {
                    TestShortestPath.assertEquals((Object)edge_array[incomingEdges1[j - 1]], (Object)e);
                    continue;
                }
                TestShortestPath.assertNull((Object)incomingEdges1[j - 1]);
            }
        }
    }

    public void addEdges(Graph<String, Integer> g, BiMap<String, Integer> indexer, Integer[] edge_array) {
        for (int i = 0; i < edges.length; ++i) {
            int[] edge = edges[i];
            Integer e = i;
            g.addEdge((Integer)i, (String)indexer.inverse().get((Object)edge[0]), (String)indexer.inverse().get((Object)edge[1]));
            edge_array[i] = e;
            if (edge.length <= 2) continue;
            this.edgeWeights.put(e, edge[2]);
        }
    }
}

