/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.scoring.PageRank;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPageRank
extends TestCase {
    private Map<Integer, Number> edgeWeights;
    private DirectedGraph<Integer, Integer> graph;
    private Supplier<Integer> edgeFactory;

    public static Test suite() {
        return new TestSuite(TestPageRank.class);
    }

    protected void setUp() {
        this.edgeWeights = new HashMap<Integer, Number>();
        this.edgeFactory = new Supplier<Integer>(){
            int i = 0;

            public Integer get() {
                return this.i++;
            }
        };
    }

    private void addEdge(Graph<Integer, Integer> G, Integer v1, Integer v2, double weight) {
        Integer edge = (Integer)this.edgeFactory.get();
        this.graph.addEdge(edge, v1, v2);
        this.edgeWeights.put(edge, weight);
    }

    public void testRanker() {
        this.graph = new DirectedSparseMultigraph<Integer, Integer>();
        for (int i = 0; i < 4; ++i) {
            this.graph.addVertex(i);
        }
        this.addEdge(this.graph, 0, 1, 1.0);
        this.addEdge(this.graph, 1, 2, 1.0);
        this.addEdge(this.graph, 2, 3, 0.5);
        this.addEdge(this.graph, 3, 1, 1.0);
        this.addEdge(this.graph, 2, 1, 0.5);
        PageRank<Integer, Integer> pr = new PageRank<Integer, Integer>((Hypergraph<Integer, Integer>)this.graph, (Function<Integer, Number>)Functions.forMap(this.edgeWeights), 0.0);
        pr.evaluate();
        Assert.assertEquals((double)((Double)pr.getVertexScore(0)), (double)0.0, (double)pr.getTolerance());
        Assert.assertEquals((double)((Double)pr.getVertexScore(1)), (double)0.4, (double)pr.getTolerance());
        Assert.assertEquals((double)((Double)pr.getVertexScore(2)), (double)0.4, (double)pr.getTolerance());
        Assert.assertEquals((double)((Double)pr.getVertexScore(3)), (double)0.2, (double)pr.getTolerance());
    }
}

