/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.HITS;
import edu.uci.ics.jung.algorithms.scoring.HITSWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.ScoringUtils;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestHITSWithPriors
extends TestCase {
    DirectedGraph<Number, Number> graph;
    Set<Number> roots;

    public static Test suite() {
        return new TestSuite(TestHITSWithPriors.class);
    }

    protected void setUp() {
        this.graph = new DirectedSparseMultigraph<Number, Number>();
        for (int i = 0; i < 4; ++i) {
            this.graph.addVertex(i);
        }
        int j = 0;
        this.graph.addEdge((Number)j++, 0, 1);
        this.graph.addEdge((Number)j++, 1, 2);
        this.graph.addEdge((Number)j++, 2, 3);
        this.graph.addEdge((Number)j++, 3, 0);
        this.graph.addEdge((Number)j++, 2, 1);
        this.roots = new HashSet<Number>();
        this.roots.add(2);
    }

    public void testRankings() {
        HITSWithPriors<Number, Number> ranker = new HITSWithPriors<Number, Number>((Hypergraph<Number, Number>)this.graph, ScoringUtils.getHITSUniformRootPrior(this.roots), 0.3);
        ranker.evaluate();
        double[] expected_auth = new double[]{0.0, 0.765, 0.365, 0.53};
        double[] expected_hub = new double[]{0.398, 0.19, 0.897, 0.0};
        double hub_sum = 0.0;
        double auth_sum = 0.0;
        for (Number n : this.graph.getVertices()) {
            int i = n.intValue();
            double auth = ((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)i))).authority;
            double hub = ((HITS.Scores)ranker.getVertexScore(Integer.valueOf((int)i))).hub;
            Assert.assertEquals((double)auth, (double)expected_auth[i], (double)0.001);
            Assert.assertEquals((double)hub, (double)expected_hub[i], (double)0.001);
            hub_sum += hub * hub;
            auth_sum += auth * auth;
        }
        Assert.assertEquals((double)1.0, (double)hub_sum, (double)0.001);
        Assert.assertEquals((double)1.0, (double)auth_sum, (double)0.001);
    }
}

