/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import edu.uci.ics.jung.algorithms.metrics.TriadicCensus;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import junit.framework.TestCase;

public class TestTriad
extends TestCase {
    public void testConfigurationFromPaper() {
        DirectedSparseMultigraph<Character, Integer> g = new DirectedSparseMultigraph<Character, Integer>();
        char u = 'u';
        g.addVertex(Character.valueOf(u));
        char v = 'v';
        g.addVertex(Character.valueOf(v));
        char w = 'w';
        g.addVertex(Character.valueOf(w));
        g.addEdge(Integer.valueOf(0), Character.valueOf(w), Character.valueOf(u));
        g.addEdge(Integer.valueOf(1), Character.valueOf(u), Character.valueOf(v));
        g.addEdge(Integer.valueOf(2), Character.valueOf(v), Character.valueOf(u));
        TestTriad.assertEquals((int)35, (int)TriadicCensus.triCode(g, Character.valueOf(u), Character.valueOf(v), Character.valueOf(w)));
        TestTriad.assertEquals((int)7, (int)TriadicCensus.triType(35));
        TestTriad.assertEquals((String)"111D", (String)TriadicCensus.TRIAD_NAMES[7]);
        TestTriad.assertEquals((int)7, (int)TriadicCensus.triType(TriadicCensus.triCode(g, Character.valueOf(u), Character.valueOf(w), Character.valueOf(v))));
        TestTriad.assertEquals((int)7, (int)TriadicCensus.triType(TriadicCensus.triCode(g, Character.valueOf(v), Character.valueOf(u), Character.valueOf(w))));
        long[] counts = TriadicCensus.getCounts(g);
        for (int i = 1; i <= 16; ++i) {
            if (i == 7) {
                TestTriad.assertEquals((long)1L, (long)counts[i]);
                continue;
            }
            TestTriad.assertEquals((long)0L, (long)counts[i]);
        }
    }

    public void testFourVertexGraph() {
        int i;
        DirectedSparseMultigraph<Character, Integer> g = new DirectedSparseMultigraph<Character, Integer>();
        char u = 'u';
        g.addVertex(Character.valueOf(u));
        char v = 'v';
        g.addVertex(Character.valueOf(v));
        char w = 'w';
        g.addVertex(Character.valueOf(w));
        char t = 't';
        g.addVertex(Character.valueOf(t));
        g.addEdge(Integer.valueOf(0), Character.valueOf(t), Character.valueOf(u));
        g.addEdge(Integer.valueOf(1), Character.valueOf(u), Character.valueOf(v));
        long[] counts = TriadicCensus.getCounts(g);
        for (i = 1; i <= 16; ++i) {
            if (i == 2) {
                TestTriad.assertEquals((String)("On " + i), (long)2L, (long)counts[i]);
                continue;
            }
            if (i == 6 || i == 1) {
                TestTriad.assertEquals((String)("On " + i), (long)1L, (long)counts[i]);
                continue;
            }
            TestTriad.assertEquals((long)0L, (long)counts[i]);
        }
        g.addEdge(Integer.valueOf(2), Character.valueOf(v), Character.valueOf(t));
        g.addEdge(Integer.valueOf(3), Character.valueOf(w), Character.valueOf(u));
        g.addEdge(Integer.valueOf(4), Character.valueOf(v), Character.valueOf(w));
        counts = TriadicCensus.getCounts(g);
        for (i = 1; i <= 16; ++i) {
            if (i == 10) {
                TestTriad.assertEquals((String)("On " + i), (long)2L, (long)counts[i]);
                continue;
            }
            if (i == 4 || i == 5) {
                TestTriad.assertEquals((String)("On " + i), (long)1L, (long)counts[i]);
                continue;
            }
            TestTriad.assertEquals((String)("On " + i), (long)0L, (long)counts[i]);
        }
    }

    public void testThreeDotsThreeDashes() {
        int i;
        DirectedSparseMultigraph<Character, Integer> g = new DirectedSparseMultigraph<Character, Integer>();
        char u = 'u';
        g.addVertex(Character.valueOf(u));
        char v = 'v';
        g.addVertex(Character.valueOf(v));
        char w = 'w';
        g.addVertex(Character.valueOf(w));
        long[] counts = TriadicCensus.getCounts(g);
        for (i = 1; i <= 16; ++i) {
            if (i == 1) {
                TestTriad.assertEquals((long)1L, (long)counts[i]);
                continue;
            }
            TestTriad.assertEquals((long)0L, (long)counts[i]);
        }
        g.addEdge(Integer.valueOf(0), Character.valueOf(v), Character.valueOf(u));
        g.addEdge(Integer.valueOf(1), Character.valueOf(u), Character.valueOf(v));
        g.addEdge(Integer.valueOf(2), Character.valueOf(v), Character.valueOf(w));
        g.addEdge(Integer.valueOf(3), Character.valueOf(w), Character.valueOf(v));
        g.addEdge(Integer.valueOf(4), Character.valueOf(u), Character.valueOf(w));
        g.addEdge(Integer.valueOf(5), Character.valueOf(w), Character.valueOf(u));
        counts = TriadicCensus.getCounts(g);
        for (i = 1; i <= 16; ++i) {
            if (i == 16) {
                TestTriad.assertEquals((long)1L, (long)counts[i]);
                continue;
            }
            TestTriad.assertEquals((String)("Count on " + i + " failed"), (long)0L, (long)counts[i]);
        }
    }

    public void testNull() {
        DirectedSparseMultigraph g = new DirectedSparseMultigraph();
        long[] counts = TriadicCensus.getCounts(g);
        for (int i = 1; i < TriadicCensus.MAX_TRIADS; ++i) {
            TestTriad.assertEquals((String)"Empty Graph doesn't have count 0", (long)0L, (long)counts[i]);
        }
    }

    public void testOneVertex() {
        DirectedSparseMultigraph g = new DirectedSparseMultigraph();
        g.addVertex(Character.valueOf('u'));
        long[] counts = TriadicCensus.getCounts(g);
        for (int i = 1; i < TriadicCensus.MAX_TRIADS; ++i) {
            TestTriad.assertEquals((String)"One vertex Graph doesn't have count 0", (long)0L, (long)counts[i]);
        }
    }

    public void testTwoVertices() {
        DirectedSparseMultigraph<Character, Integer> g = new DirectedSparseMultigraph<Character, Integer>();
        char v1 = 'u';
        g.addVertex(Character.valueOf('u'));
        char v2 = 'v';
        g.addVertex(Character.valueOf('v'));
        g.addEdge(Integer.valueOf(0), Character.valueOf(v1), Character.valueOf(v2));
        long[] counts = TriadicCensus.getCounts(g);
        for (int i = 1; i < TriadicCensus.MAX_TRIADS; ++i) {
            TestTriad.assertEquals((String)"Two vertex Graph doesn't have count 0", (long)0L, (long)counts[i]);
        }
    }
}

