/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.importance.WeightedNIPaths;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestWeightedNIPaths
extends TestCase {
    Supplier<String> vertexFactory;
    Supplier<Number> edgeFactory;

    public static Test suite() {
        return new TestSuite(TestWeightedNIPaths.class);
    }

    protected void setUp() {
        this.vertexFactory = new Supplier<String>(){
            char a = (char)65;

            public String get() {
                char c = this.a;
                this.a = (char)(c + '\u0001');
                return Character.toString(c);
            }
        };
        this.edgeFactory = new Supplier<Number>(){
            int count;

            public Number get() {
                return this.count++;
            }
        };
    }

    public void testRanker() {
        DirectedSparseMultigraph<Object, Object> graph = new DirectedSparseMultigraph<Object, Object>();
        for (int i = 0; i < 5; ++i) {
            graph.addVertex(this.vertexFactory.get());
        }
        graph.addEdge(this.edgeFactory.get(), "A", "B");
        graph.addEdge(this.edgeFactory.get(), "A", "C");
        graph.addEdge(this.edgeFactory.get(), "A", "D");
        graph.addEdge(this.edgeFactory.get(), "B", "A");
        graph.addEdge(this.edgeFactory.get(), "B", "E");
        graph.addEdge(this.edgeFactory.get(), "B", "D");
        graph.addEdge(this.edgeFactory.get(), "C", "A");
        graph.addEdge(this.edgeFactory.get(), "C", "E");
        graph.addEdge(this.edgeFactory.get(), "C", "D");
        graph.addEdge(this.edgeFactory.get(), "D", "A");
        graph.addEdge(this.edgeFactory.get(), "D", "B");
        graph.addEdge(this.edgeFactory.get(), "D", "C");
        graph.addEdge(this.edgeFactory.get(), "D", "E");
        HashSet<String> priors = new HashSet<String>();
        priors.add("A");
        WeightedNIPaths<String, Number> ranker = new WeightedNIPaths<String, Number>(graph, this.vertexFactory, this.edgeFactory, 2.0, 3, priors);
        ranker.evaluate();
        Assert.assertEquals((double)ranker.getRankings().get((int)0).rankScore, (double)0.277787, (double)1.0E-4);
        Assert.assertEquals((double)ranker.getRankings().get((int)1).rankScore, (double)0.222222, (double)1.0E-4);
        Assert.assertEquals((double)ranker.getRankings().get((int)2).rankScore, (double)0.166676, (double)1.0E-4);
        Assert.assertEquals((double)ranker.getRankings().get((int)3).rankScore, (double)0.166676, (double)1.0E-4);
        Assert.assertEquals((double)ranker.getRankings().get((int)4).rankScore, (double)0.166676, (double)1.0E-4);
    }
}

