/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.KStepMarkov;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestKStepMarkov
extends TestCase {
    public static final String EDGE_WEIGHT = "edu.uci.ics.jung.edge_weight";
    DirectedGraph<Number, Number> mGraph;
    double[][] mTransitionMatrix;
    Map<Number, Number> edgeWeights = new HashMap<Number, Number>();

    public static Test suite() {
        return new TestSuite(TestKStepMarkov.class);
    }

    protected void setUp() {
        int i;
        this.mGraph = new DirectedSparseMultigraph<Number, Number>();
        this.mTransitionMatrix = new double[][]{{0.0, 0.5, 0.5}, {0.3333333333333333, 0.0, 0.6666666666666666}, {0.3333333333333333, 0.6666666666666666, 0.0}};
        for (i = 0; i < this.mTransitionMatrix.length; ++i) {
            this.mGraph.addVertex(i);
        }
        for (i = 0; i < this.mTransitionMatrix.length; ++i) {
            for (int j = 0; j < this.mTransitionMatrix[i].length; ++j) {
                if (!(this.mTransitionMatrix[i][j] > 0.0)) continue;
                int edge = i * this.mTransitionMatrix.length + j;
                this.mGraph.addEdge((Number)edge, i, j);
                this.edgeWeights.put(edge, this.mTransitionMatrix[i][j]);
            }
        }
    }

    public void testRanker() {
        HashSet<Integer> priors = new HashSet<Integer>();
        priors.add(1);
        priors.add(2);
        KStepMarkov<Number, Number> ranker = new KStepMarkov<Number, Number>(this.mGraph, priors, 2, this.edgeWeights);
        for (int i = 0; i < 10; ++i) {
            ranker.step();
        }
        List<Ranking<?>> rankings = ranker.getRankings();
    }
}

