/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.BetweennessCentrality;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBetweennessCentrality
extends TestCase {
    public static Test suite() {
        return new TestSuite(TestBetweennessCentrality.class);
    }

    protected void setUp() {
    }

    public void testRanker() {
        UndirectedSparseGraph<Integer, Integer> graph = new UndirectedSparseGraph<Integer, Integer>();
        for (int i = 0; i < 9; ++i) {
            graph.addVertex(i);
        }
        int edge = 0;
        graph.addEdge(Integer.valueOf(edge++), 0, 1);
        graph.addEdge(Integer.valueOf(edge++), 0, 6);
        graph.addEdge(Integer.valueOf(edge++), 1, 2);
        graph.addEdge(Integer.valueOf(edge++), 1, 3);
        graph.addEdge(Integer.valueOf(edge++), 2, 4);
        graph.addEdge(Integer.valueOf(edge++), 3, 4);
        graph.addEdge(Integer.valueOf(edge++), 4, 5);
        graph.addEdge(Integer.valueOf(edge++), 5, 8);
        graph.addEdge(Integer.valueOf(edge++), 7, 8);
        graph.addEdge(Integer.valueOf(edge++), 6, 7);
        BetweennessCentrality bc = new BetweennessCentrality(graph);
        bc.setRemoveRankScoresOnFinalize(false);
        bc.evaluate();
        Assert.assertEquals((double)(bc.getVertexRankScore(0) / 28.0), (double)0.2142, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(1) / 28.0), (double)0.2797, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(2) / 28.0), (double)0.0892, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(3) / 28.0), (double)0.0892, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(4) / 28.0), (double)0.2797, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(5) / 28.0), (double)0.2142, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(6) / 28.0), (double)0.1666, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(7) / 28.0), (double)0.1428, (double)0.001);
        Assert.assertEquals((double)(bc.getVertexRankScore(8) / 28.0), (double)0.1666, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(0, 1)), (double)10.66666, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(0, 1)), (double)10.66666, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(0, 6)), (double)9.33333, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(1, 2)), (double)6.5, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(1, 3)), (double)6.5, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(2, 4)), (double)6.5, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(3, 4)), (double)6.5, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(4, 5)), (double)10.66666, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(5, 8)), (double)9.33333, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(6, 7)), (double)8.0, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(7, 8)), (double)8.0, (double)0.001);
    }

    public void testRankerDirected() {
        DirectedSparseGraph<Integer, Integer> graph = new DirectedSparseGraph<Integer, Integer>();
        for (int i = 0; i < 5; ++i) {
            graph.addVertex(i);
        }
        int edge = 0;
        graph.addEdge(Integer.valueOf(edge++), 0, 1);
        graph.addEdge(Integer.valueOf(edge++), 1, 2);
        graph.addEdge(Integer.valueOf(edge++), 3, 1);
        graph.addEdge(Integer.valueOf(edge++), 4, 2);
        BetweennessCentrality bc = new BetweennessCentrality(graph);
        bc.setRemoveRankScoresOnFinalize(false);
        bc.evaluate();
        Assert.assertEquals((double)bc.getVertexRankScore(0), (double)0.0, (double)0.001);
        Assert.assertEquals((double)bc.getVertexRankScore(1), (double)2.0, (double)0.001);
        Assert.assertEquals((double)bc.getVertexRankScore(2), (double)0.0, (double)0.001);
        Assert.assertEquals((double)bc.getVertexRankScore(3), (double)0.0, (double)0.001);
        Assert.assertEquals((double)bc.getVertexRankScore(4), (double)0.0, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(0, 1)), (double)2.0, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(1, 2)), (double)3.0, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(3, 1)), (double)2.0, (double)0.001);
        Assert.assertEquals((double)bc.getEdgeRankScore(graph.findEdge(4, 2)), (double)1.0, (double)0.001);
    }
}

