/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.random.ErdosRenyiGenerator;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestErdosRenyi
extends TestCase {
    Supplier<UndirectedGraph<String, Number>> graphFactory;
    Supplier<String> vertexFactory;
    Supplier<Number> edgeFactory;

    public static Test suite() {
        return new TestSuite(TestErdosRenyi.class);
    }

    protected void setUp() {
        this.graphFactory = new Supplier<UndirectedGraph<String, Number>>(){

            public UndirectedGraph<String, Number> get() {
                return new UndirectedSparseMultigraph<String, Number>();
            }
        };
        this.vertexFactory = new Supplier<String>(){
            int count;

            public String get() {
                return Character.toString((char)(65 + this.count++));
            }
        };
        this.edgeFactory = new Supplier<Number>(){
            int count;

            public Number get() {
                return this.count++;
            }
        };
    }

    public void test() {
        int numVertices = 100;
        int total = 0;
        for (int i = 1; i <= 10; ++i) {
            ErdosRenyiGenerator<String, Number> generator = new ErdosRenyiGenerator<String, Number>(this.graphFactory, this.vertexFactory, this.edgeFactory, numVertices, 0.1);
            generator.setSeed(0L);
            Object graph = generator.get();
            Assert.assertTrue((graph.getVertexCount() == numVertices ? 1 : 0) != 0);
            total += graph.getEdgeCount();
        }
        Assert.assertTrue(((total = (int)((double)total / 10.0)) > 445 && total < 545 ? 1 : 0) != 0);
    }
}

