/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.CacheHashTable;
import org.mapdb.DataInput2;
import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;

public class SnapshotEngine
extends EngineWrapper {
    protected static final byte[] NOT_EXIST = new byte[0];
    private final int cacheSize;
    protected Collection<Snapshot> snapshots = new HashSet<Snapshot>();
    protected final ReentrantReadWriteLock snapshotsLock = new ReentrantReadWriteLock();

    public SnapshotEngine(Engine engine, int cacheSize) {
        super(engine);
        this.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long ret = super.put(value, serializer);
        this.snapshotsLock.readLock().lock();
        try {
            for (Snapshot s : this.snapshots) {
                s.oldRecords.putIfAbsent(ret, NOT_EXIST);
            }
            long l = ret;
            return l;
        }
        finally {
            this.snapshotsLock.readLock().unlock();
        }
    }

    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.updateOldRec(recid);
        super.update(recid, value, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOldRec(long recid) {
        this.snapshotsLock.readLock().lock();
        try {
            byte[] prevValue = NOT_EXIST;
            for (Snapshot s : this.snapshots) {
                if (prevValue == NOT_EXIST) {
                    if (s.oldRecords.containsKey(recid)) continue;
                    prevValue = (byte[])super.get(recid, Serializer.BYTE_ARRAY_SERIALIZER);
                    s.oldRecords.putIfAbsent(recid, prevValue);
                    continue;
                }
                s.oldRecords.putIfAbsent(recid, prevValue);
            }
        }
        finally {
            this.snapshotsLock.readLock().unlock();
        }
    }

    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        this.updateOldRec(recid);
        return super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
    }

    @Override
    public void delete(long recid) {
        this.updateOldRec(recid);
        super.delete(recid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Engine snapshot() {
        this.snapshotsLock.writeLock().lock();
        try {
            EngineWrapper ret = new Snapshot(this);
            this.snapshots.add((Snapshot)ret);
            if (this.cacheSize > 0) {
                ret = new CacheHashTable(ret, this.cacheSize);
                ret = new EngineWrapper.ReadOnlyEngine(ret);
            }
            EngineWrapper e = this;
            while (e.getWrappedEngine() instanceof EngineWrapper) {
                e = (EngineWrapper)e.getWrappedEngine();
            }
            EngineWrapper engineWrapper = ret;
            return engineWrapper;
        }
        finally {
            this.snapshotsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean locked = this.snapshotsLock.isWriteLocked();
        if (!locked) {
            this.snapshotsLock.readLock().lock();
        }
        try {
            for (Snapshot s : this.snapshots) {
                s.close();
            }
        }
        finally {
            this.snapshots = null;
            if (!locked) {
                this.snapshotsLock.readLock().unlock();
            }
        }
        super.close();
    }

    public static Engine createSnapshotFor(Engine engine) {
        Engine engineOrig = engine;
        while (!(engine instanceof SnapshotEngine)) {
            if (engine instanceof EngineWrapper) {
                engine = ((EngineWrapper)engine).getWrappedEngine();
                continue;
            }
            throw new InternalError("Could not create snapshot for Engine: " + engineOrig);
        }
        return ((SnapshotEngine)engine).snapshot();
    }

    protected static class Snapshot
    extends EngineWrapper.ReadOnlyEngine {
        protected LongConcurrentHashMap<byte[]> oldRecords = new LongConcurrentHashMap();

        protected Snapshot(SnapshotEngine engine) {
            super(engine);
        }

        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            byte[] b = this.oldRecords.get(recid);
            if (b == NOT_EXIST) {
                return null;
            }
            if (b == null) {
                return super.get(recid, serializer);
            }
            DataInput2 in = new DataInput2(b);
            try {
                return serializer.deserialize(in, b.length);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            SnapshotEngine se = (SnapshotEngine)this.engine;
            se.snapshotsLock.writeLock().lock();
            try {
                se.snapshots.remove(this);
            }
            finally {
                se.snapshotsLock.writeLock().unlock();
            }
            this.engine = null;
            this.oldRecords = null;
        }
    }
}

