/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.Engine;
import org.mapdb.EngineWrapper;
import org.mapdb.Serializer;
import org.mapdb.Utils;

public class CacheHashTableSynchronized
extends EngineWrapper
implements Engine {
    private static final int CONCURRENCY_FACTOR = 16;
    protected final Object[] locks;
    protected HashItem[] items;
    protected final int cacheMaxSize;

    public CacheHashTableSynchronized(Engine engine, int cacheMaxSize) {
        super(engine);
        this.items = new HashItem[cacheMaxSize];
        this.cacheMaxSize = cacheMaxSize;
        this.locks = new Object[16];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Object();
        }
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid = this.engine.put(value, serializer);
        this.items[this.position((long)recid)] = new HashItem(recid, value);
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        int pos = this.position(recid);
        HashItem item = this.items[pos];
        if (item != null && recid == item.key) {
            return (A)item.val;
        }
        Object object = this.locks[pos % 16];
        synchronized (object) {
            A value = this.engine.get(recid, serializer);
            if (value != null) {
                this.items[pos] = new HashItem(recid, value);
            }
            return value;
        }
    }

    private int position(long recid) {
        return Math.abs(Utils.longHash(recid)) % this.cacheMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        int pos = this.position(recid);
        Object object = this.locks[pos % 16];
        synchronized (object) {
            this.items[pos] = new HashItem(recid, value);
            this.engine.update(recid, value, serializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long recid) {
        int pos = this.position(recid);
        Object object = this.locks[pos % 16];
        synchronized (object) {
            this.engine.delete(recid);
            HashItem item = this.items[pos];
            if (item != null && recid == item.key) {
                this.items[pos] = null;
            }
        }
    }

    @Override
    public void close() {
        this.engine.close();
        this.engine = null;
        this.items = null;
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
        this.engine.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        int pos = this.position(recid);
        Object object = this.locks[pos % 16];
        synchronized (object) {
            HashItem item = this.items[pos];
            if (item != null && item.key == recid && (item.val == expectedOldValue || item.val.equals(expectedOldValue))) {
                this.items[pos] = new HashItem(recid, newValue);
                this.engine.update(recid, newValue, serializer);
                return true;
            }
            boolean ret = this.engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
            if (ret) {
                this.items[pos] = new HashItem(recid, newValue);
            }
            return ret;
        }
    }

    private static class HashItem {
        final long key;
        final Object val;

        private HashItem(long key, Object val) {
            this.key = key;
            this.val = val;
        }
    }
}

