/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.CacheLRU;
import org.mapdb.Engine;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;

public class CacheHardRef
extends CacheLRU {
    static final int CHECK_EVERY_N = 10000;
    int counter = 0;

    public CacheHardRef(Engine engine, int initialCapacity) {
        super(engine, (LongMap<Object>)((Object)new LongConcurrentHashMap(initialCapacity)));
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        this.checkFreeMem();
        return super.get(recid, serializer);
    }

    private void checkFreeMem() {
        if (this.counter++ % 10000 == 0) {
            Runtime r = Runtime.getRuntime();
            long max = r.maxMemory();
            if (max == Long.MAX_VALUE) {
                return;
            }
            double free = r.freeMemory();
            double total = r.totalMemory();
            if ((free += (double)max - total) < 1.0E7 || free * 4.0 < (double)max) {
                this.cache.clear();
            }
        }
    }

    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.checkFreeMem();
        super.update(recid, value, serializer);
    }

    @Override
    public void delete(long recid) {
        this.checkFreeMem();
        super.delete(recid);
    }

    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        this.checkFreeMem();
        return super.compareAndSwap(recid, expectedOldValue, newValue, serializer);
    }
}

