/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import org.mapdb.BTreeMap;
import org.mapdb.CompressLZF;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;

public abstract class BTreeKeySerializer<KEY, KEYS> {
    public static final BTreeKeySerializer<Object, Object[]> BASIC = new BasicKeySerializer(Serializer.BASIC, Fun.COMPARATOR);
    public static final BTreeKeySerializer<Long, long[]> LONG = new BTreeKeySerializer<Long, long[]>(){

        @Override
        public void serialize(DataOutput out, long[] keys) throws IOException {
            DataIO.DataOutputByteArray out2 = (DataIO.DataOutputByteArray)out;
            long prev = keys[0];
            out2.packLong(prev);
            for (int i = 1; i < keys.length; ++i) {
                long curr = keys[i];
                out2.packLong(curr - prev);
                prev = curr;
            }
        }

        @Override
        public long[] deserialize(DataInput in, int nodeSize) throws IOException {
            DataIO.DataInputInternal in2 = (DataIO.DataInputInternal)in;
            return in2.unpackLongArrayDeltaCompression(nodeSize);
        }

        @Override
        public int compare(long[] keys, int pos1, int pos2) {
            return Fun.compareLong(keys[pos1], keys[pos2]);
        }

        @Override
        public int compare(long[] keys, int pos, Long preDigestedKey) {
            return Fun.compareLong(keys[pos], preDigestedKey);
        }

        @Override
        public boolean compareIsSmaller(long[] keys, int pos, Long key) {
            return keys[pos] < key;
        }

        @Override
        public Long getKey(long[] keys, int pos) {
            return new Long(keys[pos]);
        }

        @Override
        public Comparator<?> comparator() {
            return Fun.COMPARATOR;
        }

        @Override
        public long[] emptyKeys() {
            return new long[0];
        }

        @Override
        public int length(long[] keys) {
            return keys.length;
        }

        @Override
        public long[] putKey(long[] keys, int pos, Long newKey) {
            long[] ret = Arrays.copyOf(keys, keys.length + 1);
            if (pos < keys.length) {
                System.arraycopy(keys, pos, ret, pos + 1, keys.length - pos);
            }
            ret[pos] = newKey;
            return ret;
        }

        @Override
        public long[] copyOfRange(long[] keys, int from, int to) {
            return Arrays.copyOfRange(keys, from, to);
        }

        @Override
        public long[] arrayToKeys(Object[] keys) {
            long[] ret = new long[keys.length];
            for (int i = keys.length - 1; i >= 0; --i) {
                ret[i] = (Long)keys[i];
            }
            return ret;
        }

        @Override
        public long[] deleteKey(long[] keys, int pos) {
            long[] keys2 = new long[keys.length - 1];
            System.arraycopy(keys, 0, keys2, 0, pos);
            System.arraycopy(keys, pos + 1, keys2, pos, keys2.length - pos);
            return keys2;
        }

        @Override
        public final int findChildren(BTreeMap.BNode node, Object key) {
            long[] keys = (long[])node.keys;
            long key2 = (Long)key;
            int left = 0;
            int right = keys.length;
            do {
                int middle;
                if ((middle = (left + right) / 2) == keys.length) {
                    return middle + node.leftEdgeInc();
                }
                if (keys[middle] < key2) {
                    left = middle + 1;
                    continue;
                }
                right = middle;
            } while (left < right);
            return right + node.leftEdgeInc();
        }

        @Override
        public final int findChildren2(BTreeMap.BNode node, Object key) {
            long[] keys = (long[])node.keys;
            long key2 = (Long)key;
            int left = 0;
            int right = keys.length;
            do {
                int middle;
                if ((middle = (left + right) / 2) == keys.length) {
                    return -1 - (middle + node.leftEdgeInc());
                }
                if (keys[middle] == key2) {
                    if (!node.isRightEdge() && middle == keys.length - 1 && middle > 0 && keys[middle - 1] == key2) {
                        --middle;
                    }
                    return middle + node.leftEdgeInc();
                }
                if (keys[middle] < key2) {
                    left = middle + 1;
                    continue;
                }
                right = middle;
            } while (left < right);
            return -1 - (right + node.leftEdgeInc());
        }
    };
    public static final BTreeKeySerializer ZERO_OR_POSITIVE_LONG = LONG;
    public static final BTreeKeySerializer<Integer, int[]> INTEGER = new BTreeKeySerializer<Integer, int[]>(){

        @Override
        public void serialize(DataOutput out, int[] keys) throws IOException {
            int prev = keys[0];
            DataIO.packIntBigger(out, prev);
            for (int i = 1; i < keys.length; ++i) {
                int curr = keys[i];
                DataIO.packInt(out, curr - prev);
                prev = curr;
            }
        }

        @Override
        public int[] deserialize(DataInput in, int nodeSize) throws IOException {
            int[] ret = new int[nodeSize];
            int prev = 0;
            for (int i = 0; i < nodeSize; ++i) {
                ret[i] = prev += DataIO.unpackInt(in);
            }
            return ret;
        }

        @Override
        public int compare(int[] keys, int pos1, int pos2) {
            return Fun.compareInt(keys[pos1], keys[pos2]);
        }

        @Override
        public int compare(int[] keys, int pos, Integer preDigestedKey) {
            return Fun.compareInt(keys[pos], preDigestedKey);
        }

        @Override
        public boolean compareIsSmaller(int[] keys, int pos, Integer key) {
            return keys[pos] < key;
        }

        @Override
        public Integer getKey(int[] keys, int pos) {
            return new Integer(keys[pos]);
        }

        @Override
        public Comparator<?> comparator() {
            return Fun.COMPARATOR;
        }

        @Override
        public int[] emptyKeys() {
            return new int[0];
        }

        @Override
        public int length(int[] keys) {
            return keys.length;
        }

        @Override
        public int[] putKey(int[] keys, int pos, Integer newKey) {
            int[] ret = Arrays.copyOf(keys, keys.length + 1);
            if (pos < keys.length) {
                System.arraycopy(keys, pos, ret, pos + 1, keys.length - pos);
            }
            ret[pos] = newKey;
            return ret;
        }

        @Override
        public int[] copyOfRange(int[] keys, int from, int to) {
            return Arrays.copyOfRange(keys, from, to);
        }

        @Override
        public int[] arrayToKeys(Object[] keys) {
            int[] ret = new int[keys.length];
            for (int i = keys.length - 1; i >= 0; --i) {
                ret[i] = (Integer)keys[i];
            }
            return ret;
        }

        @Override
        public int[] deleteKey(int[] keys, int pos) {
            int[] keys2 = new int[keys.length - 1];
            System.arraycopy(keys, 0, keys2, 0, pos);
            System.arraycopy(keys, pos + 1, keys2, pos, keys2.length - pos);
            return keys2;
        }

        @Override
        public final int findChildren(BTreeMap.BNode node, Object key) {
            int[] keys = (int[])node.keys;
            int key2 = (Integer)key;
            int left = 0;
            int right = keys.length;
            do {
                int middle;
                if ((middle = (left + right) / 2) == keys.length) {
                    return middle + node.leftEdgeInc();
                }
                if (keys[middle] < key2) {
                    left = middle + 1;
                    continue;
                }
                right = middle;
            } while (left < right);
            return right + node.leftEdgeInc();
        }

        @Override
        public final int findChildren2(BTreeMap.BNode node, Object key) {
            int[] keys = (int[])node.keys;
            int key2 = (Integer)key;
            int left = 0;
            int right = keys.length;
            do {
                int middle;
                if ((middle = (left + right) / 2) == keys.length) {
                    return -1 - (middle + node.leftEdgeInc());
                }
                if (keys[middle] == key2) {
                    if (!node.isRightEdge() && middle == keys.length - 1 && middle > 0 && keys[middle - 1] == key2) {
                        --middle;
                    }
                    return middle + node.leftEdgeInc();
                }
                if (keys[middle] < key2) {
                    left = middle + 1;
                    continue;
                }
                right = middle;
            } while (left < right);
            return -1 - (right + node.leftEdgeInc());
        }
    };
    public static final BTreeKeySerializer ZERO_OR_POSITIVE_INT = INTEGER;
    public static final BTreeKeySerializer ARRAY2 = new ArrayKeySerializer(new Comparator[]{Fun.COMPARATOR, Fun.COMPARATOR}, new Serializer[]{Serializer.BASIC, Serializer.BASIC});
    public static final BTreeKeySerializer ARRAY3 = new ArrayKeySerializer(new Comparator[]{Fun.COMPARATOR, Fun.COMPARATOR, Fun.COMPARATOR}, new Serializer[]{Serializer.BASIC, Serializer.BASIC, Serializer.BASIC});
    public static final BTreeKeySerializer ARRAY4 = new ArrayKeySerializer(new Comparator[]{Fun.COMPARATOR, Fun.COMPARATOR, Fun.COMPARATOR, Fun.COMPARATOR}, new Serializer[]{Serializer.BASIC, Serializer.BASIC, Serializer.BASIC, Serializer.BASIC});
    public static final BTreeKeySerializer<UUID, long[]> UUID = new BTreeKeySerializer<UUID, long[]>(){

        @Override
        public void serialize(DataOutput out, long[] longs) throws IOException {
            for (long l : longs) {
                out.writeLong(l);
            }
        }

        @Override
        public long[] deserialize(DataInput in, int nodeSize) throws IOException {
            long[] ret = new long[nodeSize << 1];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = in.readLong();
            }
            return ret;
        }

        @Override
        public int compare(long[] longs, int pos1, int pos2) {
            int r;
            pos1 <<= 1;
            pos2 <<= 1;
            if ((r = Fun.compareLong(longs[pos1++], longs[pos2++])) != 0) {
                return r;
            }
            return Fun.compareLong(longs[pos1], longs[pos2]);
        }

        @Override
        public int compare(long[] longs, int pos, UUID uuid) {
            int r;
            pos <<= 1;
            if ((r = Fun.compareLong(longs[pos++], uuid.getMostSignificantBits())) != 0) {
                return r;
            }
            return Fun.compareLong(longs[pos], uuid.getLeastSignificantBits());
        }

        @Override
        public UUID getKey(long[] longs, int pos) {
            pos <<= 1;
            return new UUID(longs[pos++], longs[pos]);
        }

        @Override
        public Comparator<?> comparator() {
            return Fun.COMPARATOR;
        }

        @Override
        public long[] emptyKeys() {
            return new long[0];
        }

        @Override
        public int length(long[] longs) {
            return longs.length / 2;
        }

        @Override
        public long[] putKey(long[] keys, int pos, UUID newKey) {
            long[] ret = new long[keys.length + 2];
            System.arraycopy(keys, 0, ret, 0, pos <<= 1);
            ret[pos++] = newKey.getMostSignificantBits();
            ret[pos++] = newKey.getLeastSignificantBits();
            System.arraycopy(keys, pos - 2, ret, pos, ret.length - pos);
            return ret;
        }

        @Override
        public long[] arrayToKeys(Object[] keys) {
            long[] ret = new long[keys.length << 1];
            int i = 0;
            for (Object o : keys) {
                UUID u = (UUID)o;
                ret[i++] = u.getMostSignificantBits();
                ret[i++] = u.getLeastSignificantBits();
            }
            return ret;
        }

        @Override
        public long[] copyOfRange(long[] longs, int from, int to) {
            return Arrays.copyOfRange(longs, from << 1, to << 1);
        }

        @Override
        public long[] deleteKey(long[] keys, int pos) {
            long[] ret = new long[keys.length - 2];
            System.arraycopy(keys, 0, ret, 0, pos <<= 1);
            System.arraycopy(keys, pos + 2, ret, pos, ret.length - pos);
            return ret;
        }
    };
    public static final BTreeKeySerializer<String, char[][]> STRING2 = new BTreeKeySerializer<String, char[][]>(){

        @Override
        public void serialize(DataOutput out, char[][] chars) throws IOException {
            boolean unicode = false;
            for (char[] b : chars) {
                DataIO.packInt(out, b.length);
                if (unicode) continue;
                for (char cc : b) {
                    if (cc <= '\u007f') continue;
                    unicode = true;
                }
            }
            int prefixLen = 4.commonPrefixLen(chars);
            DataIO.packInt(out, prefixLen << 1 | (unicode ? 1 : 0));
            for (int i = 0; i < prefixLen; ++i) {
                DataIO.packInt(out, chars[0][i]);
            }
            for (char[] b : chars) {
                for (int i = prefixLen; i < b.length; ++i) {
                    DataIO.packInt(out, b[i]);
                }
            }
        }

        @Override
        public char[][] deserialize(DataInput in, int nodeSize) throws IOException {
            int i;
            char[][] ret = new char[nodeSize][];
            for (int i2 = 0; i2 < ret.length; ++i2) {
                int len = DataIO.unpackInt(in);
                ret[i2] = new char[len];
            }
            int prefixLen = DataIO.unpackInt(in);
            boolean unicode = 1 == (prefixLen & 1);
            prefixLen >>>= 1;
            for (i = 0; i < prefixLen; ++i) {
                ret[0][i] = (char)in.readByte();
            }
            for (i = 1; i < ret.length; ++i) {
                System.arraycopy(ret[0], 0, ret[i], 0, prefixLen);
            }
            for (char[] b : ret) {
                for (int j = prefixLen; j < b.length; ++j) {
                    b[j] = (char)DataIO.unpackInt(in);
                }
            }
            return ret;
        }

        int compare(char[] c1, char[] c2) {
            int end = c1.length <= c2.length ? c1.length : c2.length;
            for (int i = 0; i < end; ++i) {
                int ret = c1[i] - c2[i];
                if (ret == 0) continue;
                return ret;
            }
            return c1.length - c2.length;
        }

        int compare(char[] c1, String c2) {
            int end = Math.min(c1.length, c2.length());
            for (int i = 0; i < end; ++i) {
                int ret = c1[i] - c2.charAt(i);
                if (ret == 0) continue;
                return ret;
            }
            return c1.length - c2.length();
        }

        @Override
        public int compare(char[][] chars, int pos1, int pos2) {
            return this.compare(chars[pos1], chars[pos2]);
        }

        @Override
        public int compare(char[][] chars, int pos, String key) {
            return this.compare(chars[pos], key);
        }

        @Override
        public String getKey(char[][] chars, int pos) {
            return new String(chars[pos]);
        }

        @Override
        public Comparator<?> comparator() {
            return Fun.COMPARATOR;
        }

        @Override
        public char[][] emptyKeys() {
            return new char[0][];
        }

        @Override
        public int length(char[][] chars) {
            return chars.length;
        }

        @Override
        public char[][] putKey(char[][] keys, int pos, String newKey) {
            return (char[][])BTreeMap.arrayPut((Object[])keys, pos, newKey.toCharArray());
        }

        @Override
        public char[][] copyOfRange(char[][] keys, int from, int to) {
            return (char[][])Arrays.copyOfRange(keys, from, to);
        }

        @Override
        public char[][] arrayToKeys(Object[] keys) {
            char[][] ret = new char[keys.length][];
            for (int i = keys.length - 1; i >= 0; --i) {
                ret[i] = ((String)keys[i]).toCharArray();
            }
            return ret;
        }

        @Override
        public char[][] deleteKey(char[][] keys, int pos) {
            char[][] keys2 = new char[keys.length - 1][];
            System.arraycopy(keys, 0, keys2, 0, pos);
            System.arraycopy(keys, pos + 1, keys2, pos, keys2.length - pos);
            return keys2;
        }
    };
    public static final BTreeKeySerializer<String, StringArrayKeys> STRING = new BTreeKeySerializer<String, StringArrayKeys>(){

        @Override
        public void serialize(DataOutput out, StringArrayKeys keys) throws IOException {
            int offset = 0;
            for (int o : keys.getOffset()) {
                DataIO.packInt(out, o - offset);
                offset = o;
            }
            int unicode = keys.hasUnicodeChars() ? 1 : 0;
            int prefixLen = keys.commonPrefixLen();
            DataIO.packInt(out, prefixLen << 1 | unicode);
            keys.serialize(out, prefixLen);
        }

        @Override
        public StringArrayKeys deserialize(DataInput in, int nodeSize) throws IOException {
            int[] offsets = new int[nodeSize];
            int old = 0;
            for (int i = 0; i < nodeSize; ++i) {
                offsets[i] = old += DataIO.unpackInt(in);
            }
            int prefixLen = DataIO.unpackInt(in);
            boolean useUnicode = 0 != (prefixLen & 1);
            return useUnicode ? new CharArrayKeys(in, offsets, prefixLen) : new ByteArrayKeys(in, offsets, prefixLen >>>= 1);
        }

        @Override
        public int compare(StringArrayKeys byteArrayKeys, int pos1, int pos2) {
            return byteArrayKeys.compare(pos1, pos2);
        }

        @Override
        public int compare(StringArrayKeys byteArrayKeys, int pos1, String string) {
            return byteArrayKeys.compare(pos1, string);
        }

        @Override
        public String getKey(StringArrayKeys byteArrayKeys, int pos) {
            return byteArrayKeys.getKeyString(pos);
        }

        @Override
        public Comparator<?> comparator() {
            return Fun.COMPARATOR;
        }

        @Override
        public ByteArrayKeys emptyKeys() {
            return new ByteArrayKeys(new int[0], new byte[0]);
        }

        @Override
        public int length(StringArrayKeys byteArrayKeys) {
            return byteArrayKeys.length();
        }

        @Override
        public StringArrayKeys putKey(StringArrayKeys byteArrayKeys, int pos, String string) {
            return byteArrayKeys.putKey(pos, string);
        }

        @Override
        public StringArrayKeys arrayToKeys(Object[] keys) {
            if (keys.length == 0) {
                return this.emptyKeys();
            }
            boolean unicode = false;
            int[] offsets = new int[keys.length];
            int old = 0;
            for (int i = 0; i < keys.length; ++i) {
                String b = (String)keys[i];
                if (!unicode && ByteArrayKeys.containsUnicode(b)) {
                    unicode = true;
                }
                offsets[i] = old += b.length();
            }
            return unicode ? new CharArrayKeys(offsets, keys) : new ByteArrayKeys(offsets, keys);
        }

        @Override
        public StringArrayKeys copyOfRange(StringArrayKeys byteArrayKeys, int from, int to) {
            return byteArrayKeys.copyOfRange(from, to);
        }

        @Override
        public StringArrayKeys deleteKey(StringArrayKeys byteArrayKeys, int pos) {
            return byteArrayKeys.deleteKey(pos);
        }
    };
    public static final BTreeKeySerializer<byte[], byte[][]> BYTE_ARRAY2 = new BTreeKeySerializer<byte[], byte[][]>(){

        @Override
        public void serialize(DataOutput out, byte[][] chars) throws IOException {
            for (byte[] b : chars) {
                DataIO.packInt(out, b.length);
            }
            int prefixLen = 6.commonPrefixLen(chars);
            DataIO.packInt(out, prefixLen);
            out.write(chars[0], 0, prefixLen);
            for (byte[] b : chars) {
                out.write(b, prefixLen, b.length - prefixLen);
            }
        }

        @Override
        public byte[][] deserialize(DataInput in, int nodeSize) throws IOException {
            byte[][] ret = new byte[nodeSize][];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new byte[DataIO.unpackInt(in)];
            }
            int prefixLen = DataIO.unpackInt(in);
            in.readFully(ret[0], 0, prefixLen);
            for (int i = 1; i < ret.length; ++i) {
                System.arraycopy(ret[0], 0, ret[i], 0, prefixLen);
            }
            for (byte[] aRet : ret) {
                in.readFully(aRet, prefixLen, aRet.length - prefixLen);
            }
            return ret;
        }

        int compare(byte[] c1, byte[] c2) {
            int end = c1.length <= c2.length ? c1.length : c2.length;
            for (int i = 0; i < end; ++i) {
                int ret = c1[i] - c2[i];
                if (ret == 0) continue;
                return ret;
            }
            return c1.length - c2.length;
        }

        @Override
        public int compare(byte[][] chars, int pos1, int pos2) {
            return this.compare(chars[pos1], chars[pos2]);
        }

        @Override
        public int compare(byte[][] chars, int pos, byte[] key) {
            return this.compare(chars[pos], key);
        }

        @Override
        public byte[] getKey(byte[][] chars, int pos) {
            return chars[pos];
        }

        @Override
        public Comparator<?> comparator() {
            return Fun.BYTE_ARRAY_COMPARATOR;
        }

        @Override
        public byte[][] emptyKeys() {
            return new byte[0][];
        }

        @Override
        public int length(byte[][] chars) {
            return chars.length;
        }

        @Override
        public byte[][] putKey(byte[][] keys, int pos, byte[] newKey) {
            return (byte[][])BTreeMap.arrayPut((Object[])keys, pos, newKey);
        }

        @Override
        public byte[][] copyOfRange(byte[][] keys, int from, int to) {
            return (byte[][])Arrays.copyOfRange(keys, from, to);
        }

        @Override
        public byte[][] arrayToKeys(Object[] keys) {
            byte[][] ret = new byte[keys.length][];
            for (int i = keys.length - 1; i >= 0; --i) {
                ret[i] = (byte[])keys[i];
            }
            return ret;
        }

        @Override
        public byte[][] deleteKey(byte[][] keys, int pos) {
            byte[][] keys2 = new byte[keys.length - 1][];
            System.arraycopy(keys, 0, keys2, 0, pos);
            System.arraycopy(keys, pos + 1, keys2, pos, keys2.length - pos);
            return keys2;
        }
    };
    public static final BTreeKeySerializer<byte[], ByteArrayKeys> BYTE_ARRAY = new BTreeKeySerializer<byte[], ByteArrayKeys>(){

        @Override
        public void serialize(DataOutput out, ByteArrayKeys keys) throws IOException {
            int offset = 0;
            for (int o : keys.offset) {
                DataIO.packInt(out, o - offset);
                offset = o;
            }
            int prefixLen = keys.commonPrefixLen();
            DataIO.packInt(out, prefixLen);
            out.write(keys.array, 0, prefixLen);
            offset = prefixLen;
            for (int o : keys.offset) {
                out.write(keys.array, offset, o - offset);
                offset = o + prefixLen;
            }
        }

        @Override
        public ByteArrayKeys deserialize(DataInput in, int nodeSize) throws IOException {
            int[] offsets = new int[nodeSize];
            int old = 0;
            for (int i = 0; i < nodeSize; ++i) {
                offsets[i] = old += DataIO.unpackInt(in);
            }
            byte[] bb = new byte[old];
            int prefixLen = DataIO.unpackInt(in);
            in.readFully(bb, 0, prefixLen);
            for (int i = 0; i < offsets.length - 1; ++i) {
                System.arraycopy(bb, 0, bb, offsets[i], prefixLen);
            }
            int offset = prefixLen;
            for (int o : offsets) {
                in.readFully(bb, offset, o - offset);
                offset = o + prefixLen;
            }
            return new ByteArrayKeys(offsets, bb);
        }

        @Override
        public int compare(ByteArrayKeys byteArrayKeys, int pos1, int pos2) {
            return byteArrayKeys.compare(pos1, pos2);
        }

        @Override
        public int compare(ByteArrayKeys byteArrayKeys, int pos1, byte[] string) {
            return byteArrayKeys.compare(pos1, string);
        }

        @Override
        public byte[] getKey(ByteArrayKeys byteArrayKeys, int pos) {
            return byteArrayKeys.getKey(pos);
        }

        @Override
        public Comparator<?> comparator() {
            return Fun.BYTE_ARRAY_COMPARATOR;
        }

        @Override
        public ByteArrayKeys emptyKeys() {
            return new ByteArrayKeys(new int[0], new byte[0]);
        }

        @Override
        public int length(ByteArrayKeys byteArrayKeys) {
            return byteArrayKeys.length();
        }

        @Override
        public ByteArrayKeys putKey(ByteArrayKeys byteArrayKeys, int pos, byte[] newKey) {
            return byteArrayKeys.putKey(pos, newKey);
        }

        @Override
        public ByteArrayKeys arrayToKeys(Object[] keys) {
            int[] offsets = new int[keys.length];
            int old = 0;
            for (int i = 0; i < keys.length; ++i) {
                byte[] b = (byte[])keys[i];
                offsets[i] = old += b.length;
            }
            byte[] bb = new byte[old];
            old = 0;
            for (int i = 0; i < keys.length; ++i) {
                int curr = offsets[i];
                System.arraycopy(keys[i], 0, bb, old, curr - old);
                old = curr;
            }
            return new ByteArrayKeys(offsets, bb);
        }

        @Override
        public ByteArrayKeys copyOfRange(ByteArrayKeys byteArrayKeys, int from, int to) {
            return byteArrayKeys.copyOfRange(from, to);
        }

        @Override
        public ByteArrayKeys deleteKey(ByteArrayKeys byteArrayKeys, int pos) {
            return byteArrayKeys.deleteKey(pos);
        }
    };

    public abstract void serialize(DataOutput var1, KEYS var2) throws IOException;

    public abstract KEYS deserialize(DataInput var1, int var2) throws IOException;

    public abstract int compare(KEYS var1, int var2, int var3);

    public abstract int compare(KEYS var1, int var2, KEY var3);

    public boolean compareIsSmaller(KEYS keys, int pos, KEY key) {
        return this.compare(keys, pos, key) < 0;
    }

    public abstract KEY getKey(KEYS var1, int var2);

    public abstract Comparator<?> comparator();

    public abstract KEYS emptyKeys();

    public abstract int length(KEYS var1);

    public abstract KEYS putKey(KEYS var1, int var2, KEY var3);

    public abstract KEYS copyOfRange(KEYS var1, int var2, int var3);

    public abstract KEYS deleteKey(KEYS var1, int var2);

    public int findChildren(BTreeMap.BNode node, Object key) {
        Object keys = node.keys;
        int keylen = this.length(keys);
        int left = 0;
        int right = keylen;
        do {
            int middle;
            if ((middle = (left + right) / 2) == keylen) {
                return middle + node.leftEdgeInc();
            }
            if (this.compareIsSmaller(keys, middle, key)) {
                left = middle + 1;
                continue;
            }
            right = middle;
        } while (left < right);
        return right + node.leftEdgeInc();
    }

    public int findChildren2(BTreeMap.BNode node, Object key) {
        Object keys = node.keys;
        int keylen = this.length(keys);
        int left = 0;
        int right = keylen;
        do {
            int middle;
            if ((middle = (left + right) / 2) == keylen) {
                return -1 - (middle + node.leftEdgeInc());
            }
            int comp = this.compare(keys, middle, key);
            if (comp == 0) {
                if (!node.isRightEdge() && middle == keylen - 1 && middle > 0 && this.compare(keys, middle - 1, key) == 0) {
                    --middle;
                }
                return middle + node.leftEdgeInc();
            }
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            right = middle;
        } while (left < right);
        return -1 - (right + node.leftEdgeInc());
    }

    public abstract KEYS arrayToKeys(Object[] var1);

    public Object[] keysToArray(KEYS keys) {
        Object[] ret = new Object[this.length(keys)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getKey(keys, i);
        }
        return ret;
    }

    public boolean isTrusted() {
        return false;
    }

    protected static int commonPrefixLen(byte[][] bytes) {
        int ret = 0;
        while (bytes[0].length != ret) {
            byte byt = bytes[0][ret];
            for (int i = 1; i < bytes.length; ++i) {
                if (bytes[i].length != ret && byt == bytes[i][ret]) continue;
                return ret;
            }
            ++ret;
        }
        return ret;
    }

    protected static int commonPrefixLen(char[][] chars) {
        int ret = 0;
        while (chars[0].length != ret) {
            char byt = chars[0][ret];
            for (int i = 1; i < chars.length; ++i) {
                if (chars[i].length != ret && byt == chars[i][ret]) continue;
                return ret;
            }
            ++ret;
        }
        return ret;
    }

    public static class Compress
    extends BTreeKeySerializer {
        final BTreeKeySerializer wrapped;
        final CompressLZF lzf = new CompressLZF();

        public Compress(BTreeKeySerializer wrapped) {
            if (wrapped == null) {
                throw new NullPointerException();
            }
            this.wrapped = wrapped;
        }

        protected Compress(SerializerBase serializerBase, DataInput in, SerializerBase.FastArrayList objectStack) throws IOException {
            objectStack.add(this);
            this.wrapped = (BTreeKeySerializer)serializerBase.deserialize(in, objectStack);
            if (this.wrapped == null) {
                throw new NullPointerException();
            }
        }

        public void serialize(DataOutput out, Object o) throws IOException {
            DataIO.DataOutputByteArray out2 = new DataIO.DataOutputByteArray();
            this.wrapped.serialize(out2, o);
            DataIO.packInt(out, out2.pos);
            byte[] out3 = new byte[out2.pos + 100];
            int compSize = this.lzf.compress(out2.buf, out2.pos, out3, 0);
            out.write(out3, 0, compSize);
        }

        public Object deserialize(DataInput in, int nodeSize) throws IOException {
            int unpackSize = DataIO.unpackInt(in);
            byte[] in2 = new byte[unpackSize];
            this.lzf.expand(in, in2, 0, in2.length);
            return this.wrapped.deserialize(new DataIO.DataInputByteArray(in2), nodeSize);
        }

        public int compare(Object o, int pos1, int pos2) {
            return this.wrapped.compare(o, pos1, pos2);
        }

        public int compare(Object o, int pos, Object o2) {
            return this.wrapped.compare(o, pos, o2);
        }

        public boolean compareIsSmaller(Object o, int pos, Object o2) {
            return this.wrapped.compareIsSmaller(o, pos, o2);
        }

        public Object getKey(Object o, int pos) {
            return this.wrapped.getKey(o, pos);
        }

        @Override
        public Comparator<?> comparator() {
            return this.wrapped.comparator();
        }

        public Object emptyKeys() {
            return this.wrapped.emptyKeys();
        }

        public int length(Object o) {
            return this.wrapped.length(o);
        }

        public Object putKey(Object o, int pos, Object newKey) {
            return this.wrapped.putKey(o, pos, newKey);
        }

        public Object copyOfRange(Object o, int from, int to) {
            return this.wrapped.copyOfRange(o, from, to);
        }

        public Object deleteKey(Object o, int pos) {
            return this.wrapped.deleteKey(o, pos);
        }

        @Override
        public int findChildren(BTreeMap.BNode node, Object key) {
            return this.wrapped.findChildren(node, key);
        }

        @Override
        public int findChildren2(BTreeMap.BNode node, Object key) {
            return this.wrapped.findChildren2(node, key);
        }

        public Object arrayToKeys(Object[] keys) {
            return this.wrapped.arrayToKeys(keys);
        }

        public Object[] keysToArray(Object o) {
            return this.wrapped.keysToArray(o);
        }
    }

    public static final class CharArrayKeys
    implements StringArrayKeys {
        final int[] offset;
        final char[] array;

        CharArrayKeys(int[] offset, char[] array) {
            this.offset = offset;
            this.array = array;
            if (array.length != 0 && array.length != offset[offset.length - 1]) {
                throw new DBException.DataCorruption("inconsistent array size");
            }
        }

        public CharArrayKeys(DataInput in, int[] offsets, int prefixLen) throws IOException {
            this.offset = offsets;
            this.array = new char[offsets[offsets.length - 1]];
            this.inReadFully(in, 0, prefixLen);
            for (int i = 0; i < offsets.length - 1; ++i) {
                System.arraycopy(this.array, 0, this.array, offsets[i], prefixLen);
            }
            int offset = prefixLen;
            for (int o : offsets) {
                this.inReadFully(in, offset, o);
                offset = o + prefixLen;
            }
        }

        CharArrayKeys(int[] offsets, Object[] keys) {
            this.offset = offsets;
            this.array = new char[offsets[offsets.length - 1]];
            int bbOffset = 0;
            for (Object key : keys) {
                String str = (String)key;
                str.getChars(0, str.length(), this.array, bbOffset);
                bbOffset += str.length();
            }
        }

        private void inReadFully(DataInput in, int from, int to) throws IOException {
            for (int i = from; i < to; ++i) {
                this.array[i] = (char)DataIO.unpackInt(in);
            }
        }

        @Override
        public int commonPrefixLen() {
            int lenMinus1 = this.offset.length - 1;
            int ret = 0;
            while (this.offset[0] != ret) {
                char byt = this.array[ret];
                for (int i = 0; i < lenMinus1; ++i) {
                    int o = this.offset[i] + ret;
                    if (o != this.offset[i + 1] && this.array[o] == byt) continue;
                    return ret;
                }
                ++ret;
            }
            return ret;
        }

        @Override
        public int length() {
            return this.offset.length;
        }

        @Override
        public int[] getOffset() {
            return this.offset;
        }

        @Override
        public CharArrayKeys deleteKey(int pos) {
            int split = pos == 0 ? 0 : this.offset[pos - 1];
            int next = this.offset[pos];
            char[] bb = new char[this.array.length - (next - split)];
            int[] offsets = new int[this.offset.length - 1];
            System.arraycopy(this.array, 0, bb, 0, split);
            System.arraycopy(this.array, next, bb, split, this.array.length - next);
            int minus = 0;
            int plusI = 0;
            for (int i = 0; i < offsets.length; ++i) {
                if (i == pos) {
                    plusI = 1;
                    minus = next - split;
                }
                offsets[i] = this.offset[i + plusI] - minus;
            }
            return new CharArrayKeys(offsets, bb);
        }

        @Override
        public CharArrayKeys copyOfRange(int from, int to) {
            int start = from == 0 ? 0 : this.offset[from - 1];
            int end = to == 0 ? 0 : this.offset[to - 1];
            char[] bb = Arrays.copyOfRange(this.array, start, end);
            int[] offsets = new int[to - from];
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = this.offset[i + from] - start;
            }
            return new CharArrayKeys(offsets, bb);
        }

        @Override
        public CharArrayKeys putKey(int pos, String newKey) {
            int strLen = newKey.length();
            char[] bb = new char[this.array.length + strLen];
            int split1 = pos == 0 ? 0 : this.offset[pos - 1];
            System.arraycopy(this.array, 0, bb, 0, split1);
            newKey.getChars(0, strLen, bb, split1);
            System.arraycopy(this.array, split1, bb, split1 + strLen, this.array.length - split1);
            int[] offsets = new int[this.offset.length + 1];
            int plus = 0;
            int plusI = 0;
            for (int i = 0; i < this.offset.length; ++i) {
                if (i == pos) {
                    plus = strLen;
                    plusI = 1;
                }
                offsets[i + plusI] = this.offset[i] + plus;
            }
            offsets[pos] = split1 + strLen;
            return new CharArrayKeys(offsets, bb);
        }

        public static StringArrayKeys putKey(ByteArrayKeys kk, int pos, String newKey) {
            int i;
            int strLen = newKey.length();
            char[] bb = new char[kk.array.length + strLen];
            int split1 = pos == 0 ? 0 : kk.offset[pos - 1];
            for (i = 0; i < split1; ++i) {
                bb[i] = (char)kk.array[i];
            }
            newKey.getChars(0, strLen, bb, split1);
            for (i = split1; i < kk.array.length; ++i) {
                bb[i + strLen] = (char)kk.array[i];
            }
            int[] offsets = new int[kk.offset.length + 1];
            int plus = 0;
            int plusI = 0;
            for (int i2 = 0; i2 < kk.offset.length; ++i2) {
                if (i2 == pos) {
                    plus = strLen;
                    plusI = 1;
                }
                offsets[i2 + plusI] = kk.offset[i2] + plus;
            }
            offsets[pos] = split1 + strLen;
            return new CharArrayKeys(offsets, bb);
        }

        @Override
        public int compare(int pos1, String string) {
            int strLen = string.length();
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = 0;
            int len1 = this.offset[pos1] - start1;
            int len = Math.min(len1, strLen);
            while (len-- != 0) {
                char b2;
                char b1;
                if ((b1 = this.array[start1++]) == (b2 = string.charAt(start2++))) continue;
                return b1 - b2;
            }
            return len1 - strLen;
        }

        @Override
        public int compare(int pos1, int pos2) {
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = pos2 == 0 ? 0 : this.offset[pos2 - 1];
            int len1 = this.offset[pos1] - start1;
            int len2 = this.offset[pos2] - start2;
            int len = Math.min(len1, len2);
            while (len-- != 0) {
                char b2;
                char b1;
                if ((b1 = this.array[start1++]) == (b2 = this.array[start2++])) continue;
                return b1 - b2;
            }
            return len1 - len2;
        }

        @Override
        public String getKeyString(int pos) {
            int from = pos == 0 ? 0 : this.offset[pos - 1];
            int len = this.offset[pos] - from;
            return new String(this.array, from, len);
        }

        @Override
        public boolean hasUnicodeChars() {
            for (char c : this.array) {
                if (c <= '\u007f') continue;
                return true;
            }
            return false;
        }

        @Override
        public void serialize(DataOutput out, int prefixLen) throws IOException {
            this.outWrite(out, 0, prefixLen);
            int aa = prefixLen;
            for (int o : this.offset) {
                this.outWrite(out, aa, o);
                aa = o + prefixLen;
            }
        }

        private void outWrite(DataOutput out, int from, int to) throws IOException {
            for (int i = from; i < to; ++i) {
                DataIO.packInt(out, this.array[i]);
            }
        }
    }

    public static final class ByteArrayKeys
    implements StringArrayKeys {
        final int[] offset;
        final byte[] array;

        ByteArrayKeys(int[] offset, byte[] array) {
            this.offset = offset;
            this.array = array;
            if (array.length != 0 && array.length != offset[offset.length - 1]) {
                throw new DBException.DataCorruption("inconsistent array size");
            }
        }

        ByteArrayKeys(DataInput in, int[] offsets, int prefixLen) throws IOException {
            this.offset = offsets;
            this.array = new byte[offsets[offsets.length - 1]];
            in.readFully(this.array, 0, prefixLen);
            for (int i = 0; i < offsets.length - 1; ++i) {
                System.arraycopy(this.array, 0, this.array, offsets[i], prefixLen);
            }
            int offset = prefixLen;
            for (int o : offsets) {
                in.readFully(this.array, offset, o - offset);
                offset = o + prefixLen;
            }
        }

        ByteArrayKeys(int[] offsets, Object[] keys) {
            this.offset = offsets;
            this.array = new byte[offsets[offsets.length - 1]];
            int bbOffset = 0;
            for (Object key : keys) {
                String str = (String)key;
                for (int j = 0; j < str.length(); ++j) {
                    this.array[bbOffset++] = (byte)str.charAt(j);
                }
            }
        }

        @Override
        public int commonPrefixLen() {
            int lenMinus1 = this.offset.length - 1;
            int ret = 0;
            while (this.offset[0] != ret) {
                byte byt = this.array[ret];
                for (int i = 0; i < lenMinus1; ++i) {
                    int o = this.offset[i] + ret;
                    if (o != this.offset[i + 1] && this.array[o] == byt) continue;
                    return ret;
                }
                ++ret;
            }
            return ret;
        }

        @Override
        public int length() {
            return this.offset.length;
        }

        @Override
        public int[] getOffset() {
            return this.offset;
        }

        @Override
        public ByteArrayKeys deleteKey(int pos) {
            int split = pos == 0 ? 0 : this.offset[pos - 1];
            int next = this.offset[pos];
            byte[] bb = new byte[this.array.length - (next - split)];
            int[] offsets = new int[this.offset.length - 1];
            System.arraycopy(this.array, 0, bb, 0, split);
            System.arraycopy(this.array, next, bb, split, this.array.length - next);
            int minus = 0;
            int plusI = 0;
            for (int i = 0; i < offsets.length; ++i) {
                if (i == pos) {
                    plusI = 1;
                    minus = next - split;
                }
                offsets[i] = this.offset[i + plusI] - minus;
            }
            return new ByteArrayKeys(offsets, bb);
        }

        @Override
        public ByteArrayKeys copyOfRange(int from, int to) {
            int start = from == 0 ? 0 : this.offset[from - 1];
            int end = to == 0 ? 0 : this.offset[to - 1];
            byte[] bb = Arrays.copyOfRange(this.array, start, end);
            int[] offsets = new int[to - from];
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = this.offset[i + from] - start;
            }
            return new ByteArrayKeys(offsets, bb);
        }

        @Override
        public StringArrayKeys putKey(int pos, String newKey) {
            if (ByteArrayKeys.containsUnicode(newKey)) {
                return CharArrayKeys.putKey(this, pos, newKey);
            }
            return this.putKey(pos, newKey.getBytes());
        }

        static final boolean containsUnicode(String str) {
            int strLen = str.length();
            for (int i = 0; i < strLen; ++i) {
                if (str.charAt(i) <= '\u007f') continue;
                return true;
            }
            return false;
        }

        public ByteArrayKeys putKey(int pos, byte[] newKey) {
            byte[] bb = new byte[this.array.length + newKey.length];
            int split1 = pos == 0 ? 0 : this.offset[pos - 1];
            System.arraycopy(this.array, 0, bb, 0, split1);
            System.arraycopy(newKey, 0, bb, split1, newKey.length);
            System.arraycopy(this.array, split1, bb, split1 + newKey.length, this.array.length - split1);
            int[] offsets = new int[this.offset.length + 1];
            int plus = 0;
            int plusI = 0;
            for (int i = 0; i < this.offset.length; ++i) {
                if (i == pos) {
                    plus = newKey.length;
                    plusI = 1;
                }
                offsets[i + plusI] = this.offset[i] + plus;
            }
            offsets[pos] = split1 + newKey.length;
            return new ByteArrayKeys(offsets, bb);
        }

        public byte[] getKey(int pos) {
            int from = pos == 0 ? 0 : this.offset[pos - 1];
            int to = this.offset[pos];
            return Arrays.copyOfRange(this.array, from, to);
        }

        public int compare(int pos1, byte[] string) {
            int strLen = string.length;
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = 0;
            int len1 = this.offset[pos1] - start1;
            int len = Math.min(len1, strLen);
            while (len-- != 0) {
                byte b2;
                byte b1;
                if ((b1 = this.array[start1++]) == (b2 = string[start2++])) continue;
                return b1 - b2;
            }
            return len1 - strLen;
        }

        @Override
        public int compare(int pos1, String string) {
            int strLen = string.length();
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = 0;
            int len1 = this.offset[pos1] - start1;
            int len = Math.min(len1, strLen);
            while (len-- != 0) {
                char b2;
                char b1;
                if ((b1 = (char)(this.array[start1++] & 0xFF)) == (b2 = string.charAt(start2++))) continue;
                return b1 - b2;
            }
            return len1 - strLen;
        }

        @Override
        public int compare(int pos1, int pos2) {
            int start1 = pos1 == 0 ? 0 : this.offset[pos1 - 1];
            int start2 = pos2 == 0 ? 0 : this.offset[pos2 - 1];
            int len1 = this.offset[pos1] - start1;
            int len2 = this.offset[pos2] - start2;
            int len = Math.min(len1, len2);
            while (len-- != 0) {
                byte b2;
                byte b1;
                if ((b1 = this.array[start1++]) == (b2 = this.array[start2++])) continue;
                return b1 - b2;
            }
            return len1 - len2;
        }

        @Override
        public String getKeyString(int pos) {
            byte[] ret = this.getKey(pos);
            StringBuilder sb = new StringBuilder(ret.length);
            for (byte b : ret) {
                sb.append((char)b);
            }
            return sb.toString();
        }

        @Override
        public boolean hasUnicodeChars() {
            return false;
        }

        @Override
        public void serialize(DataOutput out, int prefixLen) throws IOException {
            out.write(this.array, 0, prefixLen);
            int aa = prefixLen;
            for (int o : this.offset) {
                out.write(this.array, aa, o - aa);
                aa = o + prefixLen;
            }
        }
    }

    public static interface StringArrayKeys {
        public int commonPrefixLen();

        public int length();

        public int[] getOffset();

        public StringArrayKeys deleteKey(int var1);

        public StringArrayKeys copyOfRange(int var1, int var2);

        public StringArrayKeys putKey(int var1, String var2);

        public int compare(int var1, String var2);

        public int compare(int var1, int var2);

        public String getKeyString(int var1);

        public boolean hasUnicodeChars();

        public void serialize(DataOutput var1, int var2) throws IOException;
    }

    public static final class ArrayKeySerializer
    extends BTreeKeySerializer<Object[], Object[]>
    implements Serializable {
        private static final long serialVersionUID = 998929894238939892L;
        protected final int tsize;
        protected final Comparator[] comparators;
        protected final Serializer[] serializers;
        protected final Comparator comparator;

        public ArrayKeySerializer(Comparator[] comparators, Serializer[] serializers) {
            if (comparators.length != serializers.length) {
                throw new IllegalArgumentException("array sizes do not match");
            }
            this.tsize = comparators.length;
            this.comparators = comparators;
            this.serializers = serializers;
            this.comparator = new Fun.ArrayComparator(comparators);
        }

        public ArrayKeySerializer(SerializerBase serializerBase, DataInput is, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.tsize = DataIO.unpackInt(is);
            this.comparators = new Comparator[this.tsize];
            this.serializers = new Serializer[this.tsize];
            for (int i = 0; i < this.tsize; ++i) {
                this.comparators[i] = (Comparator)serializerBase.deserialize(is, objectStack);
                this.serializers[i] = (Serializer)serializerBase.deserialize(is, objectStack);
            }
            this.comparator = new Fun.ArrayComparator(this.comparators);
        }

        @Override
        public void serialize(DataOutput out, Object[] keys) throws IOException {
            int[] counts = new int[this.tsize - 1];
            for (int i = 0; i < keys.length; i += this.tsize) {
                int j;
                for (j = 0; j < this.tsize - 1; ++j) {
                    if (counts[j] != 0) continue;
                    Object orig = keys[i + j];
                    this.serializers[j].serialize(out, orig);
                    counts[j] = 1;
                    while (i + j + counts[j] * this.tsize < keys.length && this.comparators[j].compare(orig, keys[i + j + counts[j] * this.tsize]) == 0) {
                        int n = j;
                        counts[n] = counts[n] + 1;
                    }
                    DataIO.packInt(out, counts[j]);
                }
                this.serializers[this.serializers.length - 1].serialize(out, keys[i + this.tsize - 1]);
                j = counts.length - 1;
                while (j >= 0) {
                    int n = j--;
                    counts[n] = counts[n] - 1;
                }
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int nodeSize) throws IOException {
            Object[] ret = new Object[nodeSize * this.tsize];
            Object[] curr = new Object[this.tsize];
            int[] counts = new int[this.tsize - 1];
            for (int i = 0; i < ret.length; i += this.tsize) {
                int j;
                for (j = 0; j < this.tsize - 1; ++j) {
                    if (counts[j] != 0) continue;
                    curr[j] = this.serializers[j].deserialize(in, -1);
                    counts[j] = DataIO.unpackInt(in);
                }
                curr[this.tsize - 1] = this.serializers[this.tsize - 1].deserialize(in, -1);
                System.arraycopy(curr, 0, ret, i, this.tsize);
                j = counts.length - 1;
                while (j >= 0) {
                    int n = j--;
                    counts[n] = counts[n] - 1;
                }
            }
            for (int j : counts) {
                if (j == 0) continue;
                throw new DBException.DataCorruption("inconsistent counts");
            }
            return ret;
        }

        @Override
        public int compare(Object[] keys, int pos1, int pos2) {
            pos1 *= this.tsize;
            pos2 *= this.tsize;
            for (Comparator c : this.comparators) {
                int res;
                if ((res = c.compare(keys[pos1++], keys[pos2++])) == 0) continue;
                return res;
            }
            return 0;
        }

        @Override
        public int compare(Object[] keys, int pos, Object[] tuple) {
            pos *= this.tsize;
            int len = Math.min(tuple.length, this.tsize);
            for (int i = 0; i < len; ++i) {
                int r;
                Object tval = tuple[i];
                if (tval == null) {
                    return -1;
                }
                if ((r = this.comparators[i].compare(keys[pos++], tval)) == 0) continue;
                return r;
            }
            return Fun.compareInt(this.tsize, tuple.length);
        }

        @Override
        public Object[] getKey(Object[] keys, int pos) {
            return Arrays.copyOfRange(keys, pos *= this.tsize, pos + this.tsize);
        }

        @Override
        public Comparator<?> comparator() {
            return this.comparator;
        }

        @Override
        public Object[] emptyKeys() {
            return new Object[0];
        }

        @Override
        public int length(Object[] objects) {
            return objects.length / this.tsize;
        }

        @Override
        public Object[] putKey(Object[] keys, int pos, Object[] newKey) {
            if (newKey.length != this.tsize) {
                throw new DBException.DataCorruption("inconsistent size");
            }
            Object[] ret = new Object[keys.length + this.tsize];
            System.arraycopy(keys, 0, ret, 0, pos *= this.tsize);
            System.arraycopy(newKey, 0, ret, pos, this.tsize);
            System.arraycopy(keys, pos, ret, pos + this.tsize, keys.length - pos);
            return ret;
        }

        @Override
        public Object[] arrayToKeys(Object[] keys) {
            Object[] ret = new Object[keys.length * this.tsize];
            int pos = 0;
            for (Object o : keys) {
                if (((Object[])o).length != this.tsize) {
                    throw new DBException.DataCorruption("keys have wrong size");
                }
                System.arraycopy(o, 0, ret, pos, this.tsize);
                pos += this.tsize;
            }
            return ret;
        }

        @Override
        public Object[] copyOfRange(Object[] keys, int from, int to) {
            return Arrays.copyOfRange(keys, from *= this.tsize, to *= this.tsize);
        }

        @Override
        public Object[] deleteKey(Object[] keys, int pos) {
            Object[] ret = new Object[keys.length - this.tsize];
            System.arraycopy(keys, 0, ret, 0, pos *= this.tsize);
            System.arraycopy(keys, pos + this.tsize, ret, pos, ret.length - pos);
            return ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayKeySerializer that = (ArrayKeySerializer)o;
            if (this.tsize != that.tsize) {
                return false;
            }
            if (!Arrays.equals(this.comparators, that.comparators)) {
                return false;
            }
            return Arrays.equals(this.serializers, that.serializers);
        }

        public int hashCode() {
            int result = this.tsize;
            result = 31 * result + Arrays.hashCode(this.comparators);
            result = 31 * result + Arrays.hashCode(this.serializers);
            return result;
        }
    }

    public static final class BasicKeySerializer
    extends BTreeKeySerializer<Object, Object[]>
    implements Serializable {
        private static final long serialVersionUID = 1654710710946309279L;
        protected final Serializer serializer;
        protected final Comparator comparator;

        public BasicKeySerializer(Serializer serializer, Comparator comparator) {
            if (serializer == null || comparator == null) {
                throw new NullPointerException();
            }
            this.serializer = serializer;
            this.comparator = comparator;
        }

        BasicKeySerializer(SerializerBase serializerBase, DataInput is, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.serializer = (Serializer)serializerBase.deserialize(is, objectStack);
            this.comparator = (Comparator)serializerBase.deserialize(is, objectStack);
            if (this.serializer == null || this.comparator == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void serialize(DataOutput out, Object[] keys) throws IOException {
            for (Object o : keys) {
                this.serializer.serialize(out, o);
            }
        }

        @Override
        public Object[] deserialize(DataInput in, int nodeSize) throws IOException {
            Object[] keys = new Object[nodeSize];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.serializer.deserialize(in, -1);
            }
            return keys;
        }

        @Override
        public int compare(Object[] keys, int pos1, int pos2) {
            return this.comparator.compare(keys[pos1], keys[pos2]);
        }

        @Override
        public int compare(Object[] keys, int pos, Object key) {
            return this.comparator.compare(keys[pos], key);
        }

        @Override
        public Object getKey(Object[] keys, int pos) {
            return keys[pos];
        }

        @Override
        public Comparator<?> comparator() {
            return this.comparator;
        }

        @Override
        public Object[] emptyKeys() {
            return new Object[0];
        }

        @Override
        public int length(Object[] keys) {
            return keys.length;
        }

        @Override
        public Object[] putKey(Object[] keys, int pos, Object newKey) {
            return BTreeMap.arrayPut(keys, pos, newKey);
        }

        @Override
        public Object[] arrayToKeys(Object[] keys) {
            return keys;
        }

        @Override
        public Object[] copyOfRange(Object[] keys, int from, int to) {
            return Arrays.copyOfRange(keys, from, to);
        }

        @Override
        public Object[] deleteKey(Object[] keys, int pos) {
            Object[] keys2 = new Object[keys.length - 1];
            System.arraycopy(keys, 0, keys2, 0, pos);
            System.arraycopy(keys, pos + 1, keys2, pos, keys2.length - pos);
            return keys2;
        }
    }
}

