/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.Feature;
import debuxter.PointFinder;
import java.awt.Rectangle;

class Template
extends Feature {
    Rectangle matchBox;

    public Template(Rectangle bbox, PointFinder parent) {
        super(bbox, parent);
    }

    public double dist(Feature other, int dx, int dy) throws ArrayIndexOutOfBoundsException {
        int othery = other.markPos.y - (this.markPos.y - this.matchBox.y) + dy;
        int otherx = other.markPos.x - (this.markPos.x - this.matchBox.x) + dx;
        int myind = this.matchBox.y * this.tWidth + this.matchBox.x;
        int otherind = othery * other.tWidth + otherx;
        int sum = 0;
        if (otherx < 0 || othery < 0) {
            return Double.POSITIVE_INFINITY;
        }
        for (int y = 0; y < this.matchBox.height; ++y) {
            for (int x = 0; x < this.matchBox.width; ++x) {
                if (!(this.tPixels[myind + x] > this.blackThresh ^ other.tPixels[otherind + x] > this.blackThresh)) continue;
                ++sum;
            }
            myind += this.tWidth;
            otherind += other.tWidth;
        }
        return (double)sum / (double)(this.matchBox.height * this.matchBox.width);
    }

    public double[] dist(Feature other, int dx, int dy, int recursionLevel) throws Exception {
        double down;
        double up;
        double left;
        if (recursionLevel > 8) {
            throw new Exception("Recursion too deep");
        }
        double here = this.dist(other, dx, dy);
        if (here > 1.0) {
            return new double[]{here, dx, dy};
        }
        double right = this.dist(other, dx + 1, dy);
        double mm = Math.min(right, Math.min(left = this.dist(other, dx - 1, dy), Math.min(up = this.dist(other, dx, dy - 1), down = this.dist(other, dx, dy + 1))));
        if (mm < here) {
            if (mm == right) {
                return this.dist(other, dx + 1, dy, recursionLevel++);
            }
            if (mm == left) {
                return this.dist(other, dx - 1, dy, recursionLevel++);
            }
            if (mm == up) {
                return this.dist(other, dx, dy - 1, recursionLevel++);
            }
            if (mm == down) {
                return this.dist(other, dx, dy + 1, recursionLevel++);
            }
        }
        return new double[]{here, dx, dy};
    }

    public double[] dist(Feature other) {
        try {
            return this.dist(other, 0, 0, 0);
        }
        catch (Exception e) {
            return new double[]{Double.POSITIVE_INFINITY, 0.0, 0.0};
        }
    }

    protected void computeMatchBox() {
        int upper = 0;
        int lower = this.tHeight;
        int left = 0;
        int right = this.tWidth;
        int[] blobd = this.findBlob(this.vwidths);
        if (blobd[0] > 0 && blobd[0] < this.markPos.y) {
            upper = blobd[0];
        }
        if (blobd[1] > 0 && blobd[1] > this.markPos.y) {
            lower = blobd[1];
        }
        if ((blobd = this.findBlob(this.hheights))[0] > 0 && blobd[0] < this.markPos.x) {
            left = blobd[0];
        }
        if (blobd[1] > 0 && blobd[1] > this.markPos.x) {
            right = blobd[1];
        }
        this.matchBox = new Rectangle(left, upper, right - left, lower - upper);
        if (this.debug) {
            System.out.println("mb " + this.matchBox);
        }
    }

    @Override
    protected void computeProps() {
        super.computeProps();
        this.computeMatchBox();
    }
}

