/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.ScrollImScrollBar;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class ScrollImWithRubber
extends Canvas
implements MouseListener,
MouseMotionListener {
    Image embeddedImage;
    ScrollImScrollBar parent;
    boolean imageAvailable;
    boolean eraseit = false;
    Point bandStart;
    Point bandEnd;
    boolean onIndexedDisplay;
    Point leftUpper;
    Point lastLeftUpper;
    int im_lastupdate = 0;
    static final long serialVersionUID = 20060308L;

    public ScrollImWithRubber(ScrollImScrollBar parent, Image embeddedImage, boolean onIndexedDisplay) {
        this.parent = parent;
        this.embeddedImage = embeddedImage;
        this.onIndexedDisplay = onIndexedDisplay;
        if (this.embeddedImage.getHeight(this) == -1) {
            this.imageAvailable = false;
        } else {
            this.imageAvailable = true;
            this.repaint();
        }
        this.bandStart = new Point(0, 0);
        this.bandEnd = new Point(0, 0);
        this.leftUpper = new Point(0, 0);
        this.lastLeftUpper = new Point(0, 0);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (this.imageAvailable) {
            this.doLayout();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.eraseit) {
            this.rubberDraw();
            this.eraseit = false;
        }
        this.bandStart = this.toCanvCoo(new Point(e.getX(), e.getY()));
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.bandEnd = this.toCanvCoo(new Point(e.getX(), e.getY()));
        this.selectionFinished();
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.eraseit) {
            this.rubberDraw();
        }
        this.bandEnd = this.toCanvCoo(new Point(e.getX(), e.getY()));
        this.rubberDraw();
        this.scrollCheck();
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected Point toCanvCoo(Point p) {
        p.translate(-this.leftUpper.x, -this.leftUpper.y);
        return p;
    }

    protected synchronized void drawBand(Graphics g) {
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        int x = Math.min(this.bandStart.x, this.bandEnd.x);
        int y = Math.min(this.bandStart.y, this.bandEnd.y);
        int w = Math.abs(this.bandStart.x - this.bandEnd.x);
        int h = Math.abs(this.bandStart.y - this.bandEnd.y);
        g.drawRect(x, y, w, h);
        this.lastLeftUpper = new Point(this.leftUpper.x, this.leftUpper.y);
    }

    protected synchronized void rubberDraw() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                g.translate(this.leftUpper.x, this.leftUpper.y);
                this.drawBand(g);
                this.eraseit = true;
            }
            finally {
                g.dispose();
            }
        }
    }

    public void selectionFinished() {
        int x0 = this.bandStart.x;
        int x1 = this.bandEnd.x;
        int y0 = this.bandStart.y;
        int y1 = this.bandEnd.y;
        int width = Math.abs(x0 - x1);
        int height = Math.abs(y0 - y1);
        if (x0 > x1) {
            x0 = x1;
        }
        if (y0 > y1) {
            y0 = y1;
        }
        Rectangle selectedRegion = new Rectangle(x0, y0, width, height);
        this.parent.notifySelection(selectedRegion);
    }

    public void setx0(int x0) {
        this.leftUpper.x = this.cropPoint((Point)new Point((int)(-x0), (int)0)).x;
        this.repaint();
    }

    public int getx0() {
        return this.leftUpper.x;
    }

    public void sety0(int y0) {
        this.leftUpper.y = this.cropPoint((Point)new Point((int)0, (int)(-y0))).y;
        this.repaint();
    }

    public int gety0() {
        return this.leftUpper.y;
    }

    protected Rectangle getVisibleArea() {
        return new Rectangle(this.leftUpper, this.getSize());
    }

    protected void scrollCheck() {
        Rectangle vis = this.getVisibleArea();
        Point cm = this.bandEnd;
        boolean changed = false;
        if (cm.x < -this.leftUpper.x + 20) {
            this.leftUpper.translate(20, 0);
            changed = true;
        }
        if (cm.x > -vis.x + vis.width - 20) {
            this.leftUpper.translate(-20, 0);
            changed = true;
        }
        if (cm.y < -this.leftUpper.y + 20) {
            this.leftUpper.translate(0, 20);
            changed = true;
        }
        if (cm.y > -vis.y + vis.height - 20) {
            this.leftUpper.translate(0, -20);
            changed = true;
        }
        if (changed) {
            this.leftUpper = this.cropPoint(this.leftUpper);
            if (!this.leftUpper.equals(this.lastLeftUpper)) {
                this.repaint();
                this.parent.updateScrollbars();
            }
        }
    }

    protected Point cropPoint(Point p) {
        int maxx = this.getPreferredSize().width - this.getSize().width;
        int maxy = this.getPreferredSize().height - this.getSize().height;
        if (maxx > 0 && p.x < -maxx) {
            p.x = -maxx;
        }
        if (maxy > 0 && p.y < -maxy) {
            p.y = -maxy;
        }
        if (maxx <= 0) {
            p.x = 0;
        }
        if (maxy <= 0) {
            p.y = 0;
        }
        if (p.x > 0) {
            p.x = 0;
        }
        if (p.y > 0) {
            p.y = 0;
        }
        return p;
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (!this.imageAvailable) {
            g.drawString("Retrieving image. Please stand by...", 10, 10);
        }
        if (this.eraseit) {
            Graphics f = g.create();
            f.translate(this.lastLeftUpper.x, this.lastLeftUpper.y);
            this.drawBand(f);
            f.dispose();
        }
        g.translate(this.leftUpper.x, this.leftUpper.y);
        g.drawImage(this.embeddedImage, 0, 0, this);
        if (this.eraseit) {
            this.drawBand(g);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.imageAvailable) {
            return new Dimension(this.embeddedImage.getWidth(this), this.embeddedImage.getHeight(this));
        }
        return new Dimension(400, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean imageUpdate(Image im, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 8) != 0) {
            if (y + height - this.im_lastupdate < 100) {
                return true;
            }
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    g.drawString("Retrieving image. Please stand by...", 10, 10);
                    g.clipRect(x, this.im_lastupdate, width, y + height - this.im_lastupdate);
                    g.drawImage(im, 0, 0, this);
                    this.im_lastupdate = y + height;
                }
                finally {
                    g.dispose();
                }
            }
        }
        if ((infoflags & 0x20) != 0) {
            System.out.println("Image ready.");
            this.imageAvailable = true;
            this.repaint();
            this.parent.notifyChangedSize();
            return false;
        }
        return true;
    }
}

