/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.Feature;
import debuxter.ImageWithPoints;
import debuxter.Recogniser;
import debuxter.RecogniserSettings;
import debuxter.Template;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

class PointFinder
extends Recogniser {
    Point startPoint;
    double distThresh;
    Template markerTemplate;

    public PointFinder(ImageWithPoints parent, RecogniserSettings settings) {
        super(parent, settings);
        this.distThresh = settings.getDoubleProp("PointFinderThresh");
    }

    @Override
    public synchronized boolean putCoordinate(Point p) {
        this.startPoint = p;
        this.notify();
        return false;
    }

    private void floodFill(int ind, Rectangle bbox) {
        int y = ind / this.px_w;
        if (y < bbox.y) {
            bbox.y = y;
        }
        if (y > bbox.y + bbox.height) {
            bbox.height = y - bbox.y;
        }
        int stopat = ind - ind % this.px_w;
        while (ind >= stopat && this.pixels[ind] >= 0 && this.pixels[ind] < this.blackThresh) {
            --ind;
        }
        if (this.pixels[ind] >= this.blackThresh) {
            ++ind;
        }
        if (bbox.x > ind % this.px_w) {
            bbox.x = ind % this.px_w;
        }
        stopat = ind + (ind - ind % this.px_w);
        int lineDown = this.px_w;
        int lineUp = -this.px_w;
        Vector<Integer> upInds = new Vector<Integer>(5);
        Vector<Integer> downInds = new Vector<Integer>(5);
        if (ind + lineDown >= this.px_max) {
            lineDown = 0;
        }
        if (ind + lineUp < 0) {
            lineUp = 0;
        }
        boolean checkDown = true;
        boolean checkUp = true;
        while (ind < stopat && this.pixels[ind] >= 0 && this.pixels[ind] < this.blackThresh) {
            this.pixels[ind] = (byte)(-this.pixels[ind] - 1);
            if (this.pixels[ind + lineDown] >= 0 && this.pixels[ind + lineDown] < this.blackThresh) {
                if (checkDown) {
                    downInds.addElement(new Integer(ind + lineDown));
                    checkDown = false;
                } else {
                    checkDown = true;
                }
            }
            if (this.pixels[ind + lineUp] >= 0 && this.pixels[ind + lineUp] < this.blackThresh) {
                if (checkUp) {
                    upInds.addElement(new Integer(ind + lineUp));
                    checkUp = false;
                } else {
                    checkUp = true;
                }
            }
            ++ind;
        }
        if (ind % this.px_w > bbox.x + bbox.width) {
            bbox.width = ind % this.px_w - bbox.x;
        }
        Enumeration cts = upInds.elements();
        while (cts.hasMoreElements()) {
            this.floodFill((Integer)cts.nextElement(), bbox);
        }
        cts = downInds.elements();
        while (cts.hasMoreElements()) {
            this.floodFill((Integer)cts.nextElement(), bbox);
        }
    }

    protected void clearNegPix(Rectangle bbox) {
        for (int y = bbox.y; y < bbox.y + bbox.height; ++y) {
            int ind;
            int stopat = ind + bbox.width;
            for (ind = y * this.px_w + bbox.x; ind < stopat; ++ind) {
                if (this.pixels[ind] >= 0) continue;
                this.pixels[ind] = 127;
            }
        }
    }

    protected void findTemplate(Point p) {
        Rectangle bbox = new Rectangle(p.x, p.y, 1, 1);
        int ind = p.x + p.y * this.px_w;
        this.floodFill(ind, bbox);
        if (this.debug) {
            System.out.println("tpl-bbox" + bbox);
            this.parent.getGraphics().drawRect(bbox.x, bbox.y, bbox.width, bbox.height);
        }
        this.markerTemplate = new Template(bbox, this);
        this.parent.addPoint(new Point(bbox.x + this.markerTemplate.markPos.x, bbox.y + this.markerTemplate.markPos.y));
    }

    protected void checkMatch(int ind) {
        double[] dist;
        Feature feat = null;
        Rectangle bbox = new Rectangle(ind % this.px_w, ind / this.px_w, 1, 1);
        this.floodFill(ind, bbox);
        if (bbox.width > this.px_w / 2 || bbox.height > this.px_h / 2) {
            if (this.debug) {
                System.out.println(bbox + " too large -- skipping");
            }
            this.clearNegPix(bbox);
            return;
        }
        if (this.debug) {
            System.out.println("Checking " + bbox);
        }
        try {
            feat = new Feature(bbox, this, 2);
            dist = this.markerTemplate.dist(feat);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        if (this.debug) {
            System.out.println("d=" + dist[0] + ", x=" + ((double)(bbox.x + feat.markPos.x) + dist[1]) + ", y=" + ((double)(bbox.y + feat.markPos.y) + dist[2]));
            this.parent.getGraphics().drawRect(bbox.x, bbox.y, bbox.width, bbox.height);
        }
        if (dist[0] < this.distThresh) {
            this.parent.addPoint(new Point(bbox.x + feat.markPos.x + (int)Math.round(dist[1]), bbox.y + feat.markPos.y + (int)Math.round(dist[2])));
        }
    }

    protected int findBlack(int ind) {
        int stopat;
        if (this.pixels[ind] > this.blackThresh) {
            stopat = Math.min(ind + 20, this.px_max);
            while (ind < stopat && this.pixels[ind] > this.blackThresh) {
                ++ind;
            }
        }
        if (this.pixels[ind] > this.blackThresh) {
            stopat = Math.max(0, ind - 20);
            for (ind = this.startPoint.x + this.startPoint.y * this.px_w; ind > stopat && this.pixels[ind] > this.blackThresh; --ind) {
            }
        }
        if (this.pixels[ind] > this.blackThresh) {
            stopat = Math.max(0, ind - 20 * this.px_w);
            for (ind = this.startPoint.x + this.startPoint.y * this.px_w; ind > stopat && this.pixels[ind] > this.blackThresh; ind -= this.px_w) {
            }
        }
        if (this.pixels[ind] > this.blackThresh) {
            stopat = Math.min(this.px_max, ind + 20 * this.px_w);
            for (ind = this.startPoint.x + this.startPoint.y * this.px_w; ind < stopat && this.pixels[ind] > this.blackThresh; ind += this.px_w) {
            }
        }
        if (this.pixels[ind] > this.blackThresh) {
            return -1;
        }
        return ind;
    }

    @Override
    protected boolean analyseIt() {
        int ind = this.findBlack(this.startPoint.x + this.startPoint.y * this.px_w);
        if (ind == -1) {
            return false;
        }
        this.startPoint.x = ind % this.px_w;
        this.startPoint.y = ind / this.px_w;
        if (this.debug) {
            System.out.println("Start Point " + this.startPoint);
        }
        this.findTemplate(new Point(this.startPoint));
        return true;
    }

    @Override
    protected void recogniseIt() throws Exception {
        for (int y = this.axisTop; y < this.axisBottom; ++y) {
            int ind = y * this.px_w + this.axisLeft;
            int x = this.axisLeft;
            while (x < this.axisRight) {
                if (this.pixels[ind] >= 0 && this.pixels[ind] < this.blackThresh) {
                    this.checkMatch(ind);
                }
                ++x;
                ++ind;
            }
        }
    }
}

