/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.ImageWithPoints;
import debuxter.Recogniser;
import debuxter.RecogniserSettings;
import java.awt.Point;

class LineTracer
extends Recogniser {
    Point startPoint;
    int yThresh = 3;
    int pointSpacing;

    public LineTracer(ImageWithPoints parent, RecogniserSettings settings) {
        super(parent, settings);
        this.pointSpacing = settings.getIntProp("LineTracerSpacing");
        if (this.pointSpacing < 0 || this.pointSpacing > 1 && this.pointSpacing < 5) {
            System.out.println("Invalid point Spacing -- resetting to 0");
            this.pointSpacing = 0;
        }
    }

    public boolean followLine(int dx, boolean drawFirst) throws Exception {
        Point curpoint = new Point(this.startPoint);
        Point lastmax = null;
        Point lastmin = null;
        boolean minPlotted = false;
        boolean maxPlotted = false;
        int targy = curpoint.y;
        int lastdY = 0;
        int lastY = curpoint.y;
        int lastXDrawn = curpoint.x;
        if (!this.debug && drawFirst) {
            this.parent.addPoint(curpoint);
        }
        while (this.nextY(curpoint, targy, dx)) {
            if (this.debug) {
                System.out.println("----" + curpoint.x + " " + curpoint.y + " " + lastdY + " " + (lastY - curpoint.y) + " la" + lastmax + " li" + lastmin);
            }
            if (this.stopMe) {
                throw new Exception("Ignore");
            }
            int dY = lastY - curpoint.y;
            if (!this.debug && (Math.abs(lastXDrawn - curpoint.x) > this.pointSpacing || lastdY != 0 && Math.abs(lastdY - dY) > 3)) {
                this.parent.addPoint(curpoint);
                lastXDrawn = curpoint.x;
            } else if (this.debug) {
                System.out.println("s" + curpoint);
            }
            if (lastmax != null && lastmax.y - curpoint.y > this.yThresh) {
                this.parent.addPoint(lastmax);
                lastmax = null;
                if (this.debug) {
                    System.out.println("s" + lastmax);
                }
            }
            if (lastmin != null && curpoint.y - lastmin.y > this.yThresh) {
                this.parent.addPoint(lastmin);
                lastmin = null;
                if (this.debug) {
                    System.out.println("s" + lastmax);
                }
            }
            if (lastdY * dY <= 0) {
                if (lastdY > 0) {
                    if (lastmin == null) {
                        lastmin = new Point(curpoint);
                    } else if (lastmin.y > curpoint.y) {
                        lastmin = new Point(curpoint);
                    }
                }
                if (lastdY < 0) {
                    if (lastmax == null) {
                        lastmax = new Point(curpoint);
                    } else if (lastmax.y < curpoint.y) {
                        lastmax = new Point(curpoint);
                    }
                }
            }
            lastdY = dY;
            lastY = curpoint.y;
            targy = lastY - dY * dx;
            curpoint.x += dx;
            if (curpoint.x > this.axisLeft && curpoint.x < this.axisRight && curpoint.y >= this.axisTop && curpoint.y <= this.axisBottom) continue;
        }
        if (!this.debug) {
            this.parent.addPoint(new Point(curpoint.x - dx, lastY));
        }
        return true;
    }

    @Override
    public synchronized boolean putCoordinate(Point p) {
        this.startPoint = p;
        this.notify();
        return false;
    }

    @Override
    protected boolean analyseIt() {
        int ind;
        this.yThresh = this.px_h / 50 + 1;
        if (this.pixels[ind] > this.blackThresh) {
            int stopat = Math.min(ind + 20, this.px_max);
            for (ind = this.startPoint.x + this.startPoint.y * this.px_w; ind < stopat && this.pixels[ind] > this.blackThresh; ++ind) {
            }
            if (this.pixels[ind] > this.blackThresh) {
                stopat = Math.max(0, ind - 20);
                for (ind = this.startPoint.x + this.startPoint.y * this.px_w; ind > stopat && this.pixels[ind] > this.blackThresh; --ind) {
                }
            }
            if (this.pixels[ind] > this.blackThresh) {
                stopat = Math.max(0, ind - 20 * this.px_w);
                for (ind = this.startPoint.x + this.startPoint.y * this.px_w; ind > stopat && this.pixels[ind] > this.blackThresh; ind -= this.px_w) {
                }
            }
            if (this.pixels[ind] > this.blackThresh) {
                stopat = Math.min(this.px_max, ind + 20 * this.px_w);
                for (ind = this.startPoint.x + this.startPoint.y * this.px_w; ind < stopat && this.pixels[ind] > this.blackThresh; ind += this.px_w) {
                }
            }
            if (this.pixels[ind] > this.blackThresh) {
                return false;
            }
            this.startPoint.x = ind % this.px_w;
            this.startPoint.y = ind / this.px_w;
        }
        if (this.pointSpacing == 0) {
            this.pointSpacing = this.px_w / 20;
        }
        return true;
    }

    @Override
    protected void recogniseIt() throws Exception {
        this.followLine(-1, true);
        this.followLine(1, false);
    }
}

