/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.AutoAxisFinder;
import debuxter.DExtractor;
import debuxter.Datapoint;
import debuxter.DoublePoint;
import debuxter.Gauge;
import debuxter.LineTracer;
import debuxter.MagGlass;
import debuxter.PointFinder;
import debuxter.Recogniser;
import debuxter.RecogniserSettings;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class ImageWithPoints
extends Canvas {
    Image figure;
    Vector<Datapoint> points;
    Gauge tmpgauge = null;
    Recogniser myRecogniser;
    public Gauge hgauge = null;
    public Gauge vgauge = null;
    Color pointColor = new Color(0, 180, 0);
    int imszx;
    int imszy;
    boolean imageAvailable = false;
    ImageWithPoints me = this;
    boolean userMouseActive = false;
    MagGlass magGlass = null;
    RecogniserSettings recSettings;
    DExtractor parent;
    Image backStore = null;
    static final long serialVersionUID = 20060308L;
    MouseAdapter normalMouseAction = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Enumeration<Datapoint> pts = ImageWithPoints.this.points.elements();
            while (pts.hasMoreElements() && !e.isConsumed()) {
                pts.nextElement().mouseClicked(e);
            }
            if (e.isConsumed()) {
                return;
            }
            if (!e.isShiftDown()) {
                if ((e.getModifiers() & 0x10) == 16) {
                    ImageWithPoints.this.addPoint(new Point(x, y));
                    e.consume();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Enumeration<Datapoint> pts = ImageWithPoints.this.points.elements();
            if (ImageWithPoints.this.hgauge != null) {
                ImageWithPoints.this.hgauge.mousePressed(e);
            }
            if (ImageWithPoints.this.vgauge != null && !e.isConsumed()) {
                ImageWithPoints.this.vgauge.mousePressed(e);
            }
            while (pts.hasMoreElements() && !e.isConsumed()) {
                pts.nextElement().mousePressed(e);
            }
            if (e.isConsumed()) {
                return;
            }
            ImageWithPoints.this.tmpgauge = new Gauge(ImageWithPoints.this.me, e.getX(), e.getY(), e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Enumeration<Datapoint> pts = ImageWithPoints.this.points.elements();
            if (ImageWithPoints.this.hgauge != null) {
                ImageWithPoints.this.hgauge.mouseReleased(e);
            }
            if (ImageWithPoints.this.vgauge != null && !e.isConsumed()) {
                ImageWithPoints.this.vgauge.mouseReleased(e);
            }
            while (pts.hasMoreElements() && !e.isConsumed()) {
                pts.nextElement().mouseReleased(e);
            }
            if (e.isConsumed()) {
                return;
            }
            if (ImageWithPoints.this.tmpgauge == null) {
                return;
            }
            if (ImageWithPoints.this.tmpgauge.length() < 20.0) {
                Rectangle obox = ImageWithPoints.this.tmpgauge.bbox();
                ImageWithPoints.this.repaint(obox.x, obox.y, obox.width, obox.height);
                ImageWithPoints.this.tmpgauge = null;
                return;
            }
            ImageWithPoints.this.tmpgauge.setEnd(e.getX(), e.getY());
            ImageWithPoints.this.setGauge(ImageWithPoints.this.tmpgauge.start, ImageWithPoints.this.tmpgauge.end);
            ImageWithPoints.this.tmpgauge.paint(ImageWithPoints.this.getGraphics());
            ImageWithPoints.this.tmpgauge = null;
            e.consume();
        }
    };
    MouseMotionAdapter normalMouseMotion = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent e) {
            Enumeration<Datapoint> pts = ImageWithPoints.this.points.elements();
            ImageWithPoints.this.newMousePos(e.getPoint());
            if (ImageWithPoints.this.hgauge != null) {
                ImageWithPoints.this.hgauge.mouseDragged(e);
            }
            if (ImageWithPoints.this.vgauge != null && !e.isConsumed()) {
                ImageWithPoints.this.vgauge.mouseDragged(e);
            }
            while (pts.hasMoreElements() && !e.isConsumed()) {
                pts.nextElement().mouseDragged(e);
            }
            if (e.isConsumed() || ImageWithPoints.this.tmpgauge == null) {
                return;
            }
            Rectangle obox = ImageWithPoints.this.tmpgauge.bbox();
            ImageWithPoints.this.repaint(obox.x, obox.y, obox.width, obox.height);
            ImageWithPoints.this.tmpgauge.setEnd(e.getX(), e.getY());
            ImageWithPoints.this.tmpgauge.paint(ImageWithPoints.this.getGraphics());
            e.consume();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ImageWithPoints.this.newMousePos(e.getPoint());
        }
    };
    MouseAdapter userInputMouse = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ImageWithPoints.this.myRecogniser != null && ImageWithPoints.this.myRecogniser.putCoordinate(e.getPoint())) {
                return;
            }
            ImageWithPoints.this.userMouseToNormMouse();
        }
    };
    MouseMotionAdapter userInputMotion = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            ImageWithPoints.this.newMousePos(e.getPoint());
        }
    };

    ImageWithPoints(DExtractor parent, MagGlass magGlass, RecogniserSettings recSettings) {
        this.parent = parent;
        this.magGlass = magGlass;
        this.recSettings = recSettings;
        this.points = new Vector();
        this.setCursor(new Cursor(1));
        this.addMouseListener(this.normalMouseAction);
        this.addMouseMotionListener(this.normalMouseMotion);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.backStore == null) {
            this.createBackStore();
        }
    }

    public synchronized void setImage(Image im) {
        this.figure = im;
        if (im.getWidth(this) == -1) {
            this.backStore = null;
            this.magGlass.setImage(im);
            this.imageAvailable = false;
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    g.setColor(Color.black);
                    g.drawString("Retrieving image. Please stand by...", 10, 10);
                }
                finally {
                    g.dispose();
                }
            }
        } else {
            this.imageAvailable = true;
            this.createBackStore();
        }
        this.repaint();
    }

    public void setGauge(Gauge gauge) {
        Rectangle uprect = null;
        if (gauge.horiz) {
            if (this.hgauge != null) {
                uprect = this.hgauge.bbox();
            }
            this.hgauge = gauge;
        } else {
            if (this.vgauge != null) {
                uprect = this.vgauge.bbox();
            }
            this.vgauge = gauge;
        }
        try {
            this.parent.computeTransform();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uprect != null) {
            this.makeImage(uprect);
        }
        this.makeImage(gauge.bbox());
    }

    public void setGauge(Point p1, Point p2) {
        Gauge mygauge = new Gauge(this, p1.x, p1.y, p2.x, p2.y);
        mygauge.normalise();
        this.setGauge(mygauge);
    }

    void paintPoints(Graphics g) {
        Iterator<Datapoint> it = this.points.iterator();
        while (it.hasNext()) {
            it.next().paint(g);
        }
    }

    void paintTmpGauge(Graphics g) {
        if (this.tmpgauge != null) {
            this.tmpgauge.paint(g);
        }
    }

    void paintGauges(Graphics g) {
        if (this.hgauge != null) {
            this.hgauge.paint(g);
        }
        if (this.vgauge != null) {
            this.vgauge.paint(g);
        }
    }

    public void makeImage(Rectangle bbox) {
        if (this.backStore == null) {
            return;
        }
        Graphics backGraphics = this.backStore.getGraphics();
        if (backGraphics == null) {
            return;
        }
        if (bbox != null) {
            backGraphics.setClip(bbox.x, bbox.y, bbox.width, bbox.height);
        } else {
            bbox = new Rectangle(0, 0, this.backStore.getWidth(this), this.backStore.getHeight(this));
            backGraphics.setClip(0, 0, bbox.width, bbox.height);
        }
        backGraphics.drawImage(this.figure, 0, 0, this);
        this.paintPoints(backGraphics);
        this.paintGauges(backGraphics);
        backGraphics.dispose();
        this.repaint(bbox.x, bbox.y, bbox.width, bbox.height);
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.backStore != null) {
            g.drawImage(this.backStore, 0, 0, this);
            this.paintTmpGauge(g);
        } else {
            g.drawImage(this.figure, 0, 0, this);
            this.paintPoints(g);
            this.paintGauges(g);
            this.paintTmpGauge(g);
            if (!this.imageAvailable) {
                g.setColor(Color.black);
                g.drawString("Retrieving image. Please stand by...", 10, 10);
            }
        }
    }

    public void newScale(int oldscale, int newscale) {
        if (this.vgauge != null) {
            this.vgauge.newScale(oldscale, newscale);
        }
        if (this.hgauge != null) {
            this.hgauge.newScale(oldscale, newscale);
        }
        Iterator<Datapoint> it = this.points.iterator();
        while (it.hasNext()) {
            it.next().newScale(oldscale, newscale);
        }
    }

    public int findClosest(int x, int y) {
        int ind = -1;
        double mindist = Double.MAX_VALUE;
        for (int i = 0; i < this.points.size(); ++i) {
            Point pt = this.points.elementAt(i).getCenter();
            double dist = ((double)x - (double)pt.x) * ((double)x - (double)pt.x) + ((double)y - (double)pt.y) * ((double)y - (double)pt.y);
            if (!(dist <= mindist)) continue;
            ind = i;
            mindist = dist;
        }
        return ind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean imageUpdate(Image targIm, int infoflags, int x, int y, int width, int height) {
        Graphics g;
        if (targIm != this.figure) {
            return false;
        }
        if ((infoflags & 8) == 8 && (g = this.getGraphics()) != null) {
            try {
                g.setClip(x, y, width, height);
                g.drawImage(targIm, 0, 0, this);
                g.drawString("Retrieving image. Please stand by...", 10, 10);
            }
            finally {
                g.dispose();
            }
        }
        if ((infoflags & 0x20) != 0) {
            this.imageAvailable = true;
            this.createBackStore();
            this.parent.resizeToPreferredSize();
            this.repaint();
            return false;
        }
        return true;
    }

    private void createBackStore() {
        if (this.imageAvailable) {
            this.backStore = this.createImage(this.figure.getWidth(this), this.figure.getHeight(this));
            if (this.backStore == null) {
                return;
            }
            this.magGlass.setImage(this.backStore);
            this.makeImage(null);
        }
    }

    @Override
    public synchronized void update(Graphics g) {
        this.paint(g);
    }

    void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void userMouseToNormMouse() {
        this.removeMouseListener(this.userInputMouse);
        this.removeMouseMotionListener(this.userInputMotion);
        this.userMouseActive = false;
        this.addMouseListener(this.normalMouseAction);
        this.addMouseMotionListener(this.normalMouseMotion);
        this.setCursor(new Cursor(1));
        this.parent.releaseStatusLine();
    }

    public void askUserPoint(String msg) {
        this.parent.allocStatusLine(msg);
        this.removeMouseListener(this.normalMouseAction);
        this.removeMouseMotionListener(this.normalMouseMotion);
        this.addMouseListener(this.userInputMouse);
        this.addMouseMotionListener(this.userInputMotion);
        this.userMouseActive = true;
        this.setCursor(new Cursor(12));
    }

    public void removePoint(Datapoint dp) {
        Rectangle bbox = dp.bbox;
        this.points.removeElement(dp);
        this.makeImage(bbox);
    }

    public boolean startRecogniser(String recName) {
        if (this.myRecogniser != null) {
            return false;
        }
        if (recName == "LineTracer") {
            LineTracer l = new LineTracer(this, this.recSettings);
            l.start();
            this.askUserPoint("Please click on the line you want to trace");
            this.myRecogniser = l;
            return true;
        }
        if (recName == "PointFinder") {
            PointFinder l = new PointFinder(this, this.recSettings);
            l.start();
            this.askUserPoint("Please click on a template point");
            this.myRecogniser = l;
            return true;
        }
        if (recName == "AxisFinder") {
            AutoAxisFinder l = new AutoAxisFinder(this, this.recSettings);
            l.start();
            l.putCoordinate(new Point(0, 0));
            this.myRecogniser = l;
            return true;
        }
        return false;
    }

    public void recogniserStopped() {
        if (this.userMouseActive) {
            this.userMouseToNormMouse();
        }
        this.myRecogniser = null;
        this.parent.recogniserStopped();
        this.repaint();
    }

    public void stopRecogniser() {
        if (this.myRecogniser == null) {
            return;
        }
        this.myRecogniser.stopRecogniser();
        this.parent.releaseStatusLine();
    }

    public void addPoint(Point p) {
        Datapoint dp = new Datapoint(p.x, p.y, this.pointColor, this);
        this.points.addElement(dp);
        this.makeImage(dp.bbox);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.imageAvailable) {
            return new Dimension(this.figure.getWidth(this), this.figure.getHeight(this));
        }
        return new Dimension(500, 300);
    }

    public Point makeParallelToAxes(Datapoint pt, Point targ) {
        Gauge gauge = null;
        int dx = targ.x - pt.getScrX();
        int dy = targ.y - pt.getScrY();
        gauge = Math.abs(dx) >= Math.abs(dy) ? this.hgauge : this.vgauge;
        if (gauge == null) {
            return null;
        }
        double xproj = (double)(gauge.end.x - gauge.start.x) / gauge.length();
        double yproj = (double)(gauge.end.y - gauge.start.y) / gauge.length();
        double projlen = xproj * (double)dx + yproj * (double)dy;
        return new Point((int)Math.round((double)pt.getScrX() + xproj * projlen), (int)Math.round((double)pt.getScrY() + yproj * projlen));
    }

    public Datapoint[] getPoints() {
        Object[] ptArr = new Datapoint[this.points.size()];
        this.points.copyInto(ptArr);
        return ptArr;
    }

    public DoublePoint transformPhysicalToLogical(Point p) {
        return this.parent.transformPhysicalToLogical(p);
    }

    public void delAllPoints() {
        this.points = new Vector();
        this.makeImage(null);
    }

    public Image getRecImage() {
        return this.figure;
    }

    protected void newMousePos(Point newPos) {
        if (this.magGlass != null) {
            this.magGlass.setCoords(newPos);
        }
        this.parent.displayMousePos(newPos);
    }

    public void print() {
        Iterator<Datapoint> it = this.points.iterator();
        while (it.hasNext()) {
            System.out.println(it.next().center);
        }
    }
}

