/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

class ByteGrabber
implements ImageConsumer {
    ImageProducer prod;
    byte[] pixels;
    int px_w;
    int readPixels = 0;
    boolean errorOccurred = false;

    ByteGrabber() {
    }

    @Override
    public void setDimensions(int w, int h) {
    }

    public void setProperties(Hashtable props) {
    }

    @Override
    public void setHints(int hintflags) {
    }

    @Override
    public void setColorModel(ColorModel model) {
    }

    public synchronized byte[] retrievePixels(Image im, int w, int h) throws Exception {
        this.prod = im.getSource();
        this.px_w = w;
        this.pixels = new byte[w * h];
        int expectPixels = w * h;
        this.prod.startProduction(this);
        try {
            while (this.readPixels < expectPixels && !this.errorOccurred) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.errorOccurred) {
            throw new Exception("Could not retrieve pixels");
        }
        return this.pixels;
    }

    @Override
    public synchronized void imageComplete(int s) {
        switch (s) {
            case 2: 
            case 3: {
                this.errorOccurred = false;
                break;
            }
            default: {
                this.errorOccurred = true;
            }
        }
        this.prod.removeConsumer(this);
        this.notifyAll();
    }

    @Override
    public synchronized void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pix, int off, int scansize) {
        for (int dy = 0; dy < h; ++dy) {
            int si = off + dy * scansize;
            int di = (y + dy) * this.px_w + x;
            int dx = 0;
            while (dx < w) {
                this.pixels[di] = (byte)(model.getRed(pix[si]) / 2);
                ++this.readPixels;
                ++dx;
                ++si;
                ++di;
            }
        }
    }

    @Override
    public synchronized void setPixels(int x, int y, int w, int h, ColorModel model, int[] pix, int off, int scansize) {
        for (int dy = 0; dy < h; ++dy) {
            int si = off + dy * scansize;
            int di = (y + dy) * this.px_w + x;
            int dx = 0;
            while (dx < w) {
                this.pixels[di] = (byte)((pix[si] & 0xFF) / 2);
                ++dx;
                ++si;
                ++di;
            }
        }
    }
}

