/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.DoublePoint;
import debuxter.MissingData;
import debuxter.TwoDMatrix;
import java.awt.Point;

public class AffineTrafo {
    private DoublePoint preTrafoTranslation = null;
    private DoublePoint postTrafoTranslation = null;
    private TwoDMatrix trafoMatrix = null;
    boolean isLogX;
    boolean isLogY;

    AffineTrafo(Point xZeroPhys, Point yZeroPhys, Point xAxisPhys, Point yAxisPhys, double xMin, double xMax, double yMin, double yMax, boolean isLogX, boolean isLogY) throws MissingData {
        this.isLogX = isLogX;
        this.isLogY = isLogY;
        if (isLogX) {
            xMin = Math.log(xMin);
            xMax = Math.log(xMax);
        }
        if (isLogY) {
            yMin = Math.log(yMin);
            yMax = Math.log(yMax);
        }
        this.checkArguments(xZeroPhys, yZeroPhys, xAxisPhys, yAxisPhys, xMin, xMax, yMin, yMax);
        this.computeTransform(new DoublePoint(xZeroPhys), new DoublePoint(yZeroPhys), new DoublePoint(xAxisPhys), new DoublePoint(yAxisPhys), xMin, xMax, yMin, yMax);
    }

    private void checkArguments(Point xZeroPhys, Point yZeroPhys, Point xAxisPhys, Point yAxisPhys, double xMin, double xMax, double yMin, double yMax) throws MissingData {
        if (xZeroPhys == null || yZeroPhys == null || xAxisPhys == null || yAxisPhys == null) {
            throw new MissingData("You need to specify all axes\nto get results.");
        }
        if (Double.isNaN(xMin) || Double.isNaN(xMax) || Double.isNaN(yMin) || Double.isNaN(yMax)) {
            throw new MissingData("Invalid input for gauges.\nWith log axes, labels must be positive.");
        }
    }

    private void computeTransform(DoublePoint x0, DoublePoint y0, DoublePoint x1, DoublePoint y1, double xMin, double xMax, double yMin, double yMax) {
        DoublePoint unitX = x1.minus(x0).times(1.0 / (xMax - xMin));
        DoublePoint unitY = y1.minus(y0).times(1.0 / (yMax - yMin));
        DoublePoint lIntersectionPoint = new TwoDMatrix(unitX.times(-1.0), unitY).getInverse().mul(x0.minus(y0));
        this.preTrafoTranslation = x0.plus(unitX.times(lIntersectionPoint.getX()));
        this.postTrafoTranslation = lIntersectionPoint.plus(new DoublePoint(xMin, yMin));
        this.trafoMatrix = new TwoDMatrix(unitX, unitY).getInverse();
    }

    public DoublePoint transformPhysicalToLogical(Point physCoo) {
        DoublePoint result = new DoublePoint(physCoo);
        result = this.trafoMatrix.mul(result.minus(this.preTrafoTranslation)).plus(this.postTrafoTranslation);
        if (this.isLogX) {
            result = new DoublePoint(Math.exp(result.getX()), result.getY());
        }
        if (this.isLogY) {
            result = new DoublePoint(result.getX(), Math.exp(result.getY()));
        }
        return result;
    }
}

