/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.McellCode;
import cambria.RuleAnalyzer;
import cambria.RuleTable;
import cambria.VNRuleFileIO;
import cambria.VNRuleString;
import cambria.VonNeumann;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.util.Random;

public class VNRule
extends CARule {
    public int statePerCell;
    public static final int maxNeighbor = 5;
    Random rand = new Random(System.currentTimeMillis());
    public byte[] ruleArray;
    int maxRuleEntry;
    private String RuleContent;
    private McellCode mcellCode;
    private RuleAnalyzer ruleAnalyzer;
    private RuleTable ruleTable;

    @Override
    public void setRule(String RuleString, String filename) {
        int spc;
        if (RuleString == null) {
            VNRuleFileIO vnRuleFileIO = new VNRuleFileIO(filename);
            RuleString = vnRuleFileIO.buff.toString();
        }
        if ((spc = VNRuleString.getStatePerCell(RuleString)) > 0) {
            if (this.statePerCell == 0) {
                this.statePerCell = spc;
                this.initializeArrays();
            } else {
                if (this.statePerCell != spc) {
                    System.out.println("VNRule: Impossible to reset state-per-cell");
                    return;
                }
                this.initializeArrays();
            }
        } else {
            System.out.println("VNRule: Invalid statePerCell of RuleString");
            return;
        }
        this.RuleContent = MyString.stripBack(RuleString, ';');
        this.ruleArray = VNRuleString.getRuleArray(this.RuleContent, this.statePerCell);
    }

    @Override
    public int getStatePerCell() {
        return this.statePerCell;
    }

    @Override
    public int getMaxNeighbor() {
        return 5;
    }

    private void initializeArrays() {
        this.maxRuleEntry = MyMath.ipow(this.statePerCell, 5);
        this.ruleArray = new byte[this.maxRuleEntry];
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            this.ruleArray[i] = 0;
        }
    }

    @Override
    public int output(BlockOfCells boc) {
        VonNeumann neighbor = (VonNeumann)boc;
        return this.output(neighbor.getHomeState(), neighbor.getNorthState(), neighbor.getEastState(), neighbor.getSouthState(), neighbor.getWestState());
    }

    public int output(int homeState, int northState, int eastState, int southState, int westState) {
        int sum = 0;
        sum += homeState * MyMath.ipow(this.statePerCell, 4);
        sum += northState * MyMath.ipow(this.statePerCell, 3);
        sum += eastState * MyMath.ipow(this.statePerCell, 2);
        sum += southState * this.statePerCell;
        return this.ruleArray[sum += westState];
    }
}

