/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.BlockVN;
import cambria.BlockVNRule;
import cambria.Dosable;
import cambria.PartitionRule;
import cambria.PartitionRuleIO;
import cambria.PartitionRuleString;
import cambria.StochasticRuleUnit;
import cambria.misc.MyFileWriter;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.awt.Button;
import java.awt.TextArea;
import java.util.Random;

public class VNDoseRule
extends BlockVNRule
implements Dosable {
    private int statePerCell;
    private static final int maxNeighbor = 5;
    private int[] ruleArray;
    private int maxRuleEntry;
    private String RuleString = null;
    private Button adoptButton;
    private TextArea ruleTA;
    private static final int startIndex = 2;
    private Random rand = new Random(System.currentTimeMillis());
    private double doseRate = 1.0;
    private double fitness;
    private double selectionProbability;

    @Override
    public double getDoseRate() {
        return this.doseRate;
    }

    @Override
    public void setDoseRate(double doseRate) {
        this.doseRate = doseRate;
    }

    @Override
    public void setRule(String RuleString, String filename) {
        if (RuleString == null) {
            if (filename == null) {
                throw new IllegalArgumentException("null arguments");
            }
            PartitionRuleIO partitionRuleIO = new PartitionRuleIO(filename);
            RuleString = partitionRuleIO.buff.toString();
        }
        if (PartitionRuleString.isStochastic(RuleString)) {
            throw new RuntimeException("Stochastic rule is found.");
        }
        this.RuleString = RuleString;
        this.statePerCell = Integer.parseInt(MyString.lindex(RuleString, 0));
        if (5 != Integer.parseInt(MyString.lindex(RuleString, 1))) {
            throw new RuntimeException("Illega maxNeighbor.");
        }
        this.maxRuleEntry = MyMath.ipow(this.statePerCell, 5);
        this.ruleArray = new int[this.maxRuleEntry];
        String RuleContent = MyString.stripHeader(RuleString, 2);
        StochasticRuleUnit[] stochasticRuleArray = PartitionRuleString.createRuleArray(this.statePerCell, 5, RuleContent);
        for (int i = 0; i < this.ruleArray.length; ++i) {
            this.ruleArray[i] = stochasticRuleArray[i].output;
        }
    }

    @Override
    public void saveRuleFile(String filename) {
        StringBuffer buff = new StringBuffer();
        buff.append(Integer.toString(this.statePerCell));
        buff.append(" ");
        buff.append(Integer.toString(5));
        buff.append(System.getProperty("line.separator"));
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            buff.append(Integer.toString(i));
            buff.append(":");
            buff.append(Integer.toString(this.ruleArray[i]));
            buff.append(System.getProperty("line.separator"));
        }
        MyFileWriter.saveString(filename, buff.toString());
    }

    @Override
    public String getRuleString() {
        return this.RuleString;
    }

    @Override
    public BlockOfCells outputBlock(BlockOfCells boc) {
        BlockVN neighbor = (BlockVN)boc;
        int ruleEntry = this.getRuleEntry(neighbor);
        return this.getPartition(ruleEntry);
    }

    private int getRuleEntry(BlockVN partition) {
        int sum = 0;
        sum += MyMath.ipow(this.statePerCell, 4) * partition.getHomeState();
        sum += MyMath.ipow(this.statePerCell, 3) * partition.getNorthState();
        sum += MyMath.ipow(this.statePerCell, 2) * partition.getEastState();
        sum += this.statePerCell * partition.getSouthState();
        return sum += partition.getWestState();
    }

    private int getConservationOutputAtRandom(int ruleEntry) {
        BlockVN partition = this.int2Partition(ruleEntry);
        partition.relocateParticlesAtRandom();
        return this.getRuleEntry(partition);
    }

    private BlockVN int2Partition(int entry) {
        BlockVN partition = new BlockVN();
        int j = MyMath.ipow(this.statePerCell, 4);
        partition.setHomeState((byte)MyMath.idiv(entry, j));
        entry -= partition.getHomeState() * j;
        j = MyMath.ipow(this.statePerCell, 3);
        partition.setNorthState((byte)MyMath.idiv(entry, j));
        entry -= partition.getNorthState() * j;
        j = MyMath.ipow(this.statePerCell, 2);
        partition.setEastState((byte)MyMath.idiv(entry, j));
        partition.setSouthState((byte)MyMath.idiv(entry -= partition.getEastState() * j, this.statePerCell));
        partition.setWestState((byte)(entry -= partition.getSouthState() * this.statePerCell));
        return partition;
    }

    private BlockVN getPartition(int ruleEntry) {
        int out = this.ruleArray[ruleEntry];
        return this.int2Partition(out);
    }

    @Override
    public double getMu() {
        int j = 0;
        for (int i = 0; i < this.ruleArray.length; ++i) {
            if (this.ruleArray[i] == i) continue;
            ++j;
        }
        return (double)j / (double)this.ruleArray.length;
    }

    @Override
    public int getRuleArray(int entry) {
        return this.ruleArray[entry];
    }

    @Override
    public void setRuleArray(int entry, int output) {
        this.ruleArray[entry] = output;
    }

    public void copyRule(PartitionRule source) {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            this.setRuleArray(i, source.getRuleArray(i));
        }
    }

    @Override
    public String getDefaultThread() {
        return "MCSThread";
    }

    @Override
    public int getStatePerCell() {
        return this.statePerCell;
    }

    @Override
    public int getMaxNeighbor() {
        return 5;
    }

    @Override
    public int getMaxRuleEntry() {
        return this.maxRuleEntry;
    }

    @Override
    public void randomizeChromosome() {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            this.randomizeChromosome(i);
        }
    }

    @Override
    public void mutation(double rate) {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            if (!(this.rand.nextDouble() < rate)) continue;
            this.randomizeChromosome(i);
        }
    }

    private void randomizeChromosome(int position) {
        this.setAnotherConservedTransition(position);
    }

    private void setAnotherConservedTransition(int entry) {
        BlockVN partition = this.getPartition(entry);
        int a0 = partition.getMass(0);
        partition.relocateParticlesAtRandom();
        int b0 = partition.getMass(0);
        if (a0 != b0) {
            throw new RuntimeException("Cell 0 in relocateParticlesAtRandom() is not conservative.");
        }
        this.setRuleArray(entry, this.getRuleEntry(partition));
    }

    @Override
    public int getChromosomeLength() {
        return this.maxRuleEntry;
    }

    @Override
    public int getMaxChromosomeState() {
        return this.maxRuleEntry;
    }

    @Override
    public int[] getChromosome() {
        int[] chromosome = new int[this.maxRuleEntry];
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            chromosome[i] = this.ruleArray[i];
        }
        return chromosome;
    }

    @Override
    public double getFitness() {
        return this.fitness;
    }

    @Override
    public void copyChromosome(int[] chromosome) {
        if (this.getChromosomeLength() != chromosome.length) {
            throw new IllegalArgumentException("Chromosome lengths do not match. ");
        }
        for (int i = 0; i < this.getChromosomeLength(); ++i) {
            this.ruleArray[i] = chromosome[i];
        }
    }

    @Override
    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    @Override
    public void setSelectionProbability(double selectionProbability) {
        this.selectionProbability = selectionProbability;
    }

    @Override
    public double getSelectionProbability() {
        return this.selectionProbability;
    }
}

