/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.Partition;
import cambria.PartitionIF;
import cambria.PartitionRuleIO;
import cambria.PartitionRuleString;
import cambria.StochasticRuleUnit;
import cambria.misc.MyFileWriter;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.util.Random;

public class StochasticPartitionRule
extends CARule
implements PartitionIF {
    private int statePerCell;
    private int maxNeighbor;
    private double defaultMobility = 0.0;
    private StochasticRuleUnit[] ruleArray;
    private int maxRuleEntry;
    private String RuleString = null;
    private static final int startIndex = 2;
    private Random rand = new Random(System.currentTimeMillis());

    public void setRule(int statePerCell, int maxNeighbor) {
        if (this.RuleString != null) {
            throw new IllegalArgumentException("Redefinition of statePerCell is not permitted. ");
        }
        this.statePerCell = statePerCell;
        this.maxNeighbor = maxNeighbor;
        this.maxRuleEntry = MyMath.ipow(statePerCell, maxNeighbor);
        this.ruleArray = PartitionRuleString.initializeRuleArray(this.maxRuleEntry);
    }

    @Override
    public void setRule(String RuleString, String filename) {
        if (RuleString == null) {
            if (filename == null) {
                throw new IllegalArgumentException("null arguments");
            }
            PartitionRuleIO partitionRuleIO = new PartitionRuleIO(filename);
            RuleString = partitionRuleIO.buff.toString();
        }
        this.RuleString = RuleString;
        this.statePerCell = Integer.parseInt(MyString.lindex(RuleString, 0));
        this.maxNeighbor = Integer.parseInt(MyString.lindex(RuleString, 1));
        this.maxRuleEntry = MyMath.ipow(this.statePerCell, this.maxNeighbor);
        String RuleContent = MyString.stripHeader(RuleString, 2);
        this.ruleArray = PartitionRuleString.createRuleArray(this.statePerCell, this.maxNeighbor, RuleContent);
        this.setAllTransitionProbability(this.defaultMobility);
    }

    public void saveRuleFile(String filename) {
        StringBuffer buff = new StringBuffer();
        buff.append(Integer.toString(this.statePerCell));
        buff.append(" ");
        buff.append(Integer.toString(this.maxNeighbor));
        buff.append(System.getProperty("line.separator"));
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            buff.append(Integer.toString(i));
            buff.append(":");
            buff.append(Integer.toString(this.ruleArray[i].getOutput()));
            buff.append(System.getProperty("line.separator"));
        }
        MyFileWriter.saveString(filename, buff.toString());
    }

    @Override
    public BlockOfCells outputBlock(BlockOfCells boc) {
        return boc;
    }

    public String getRuleString() {
        return this.RuleString;
    }

    public void printAllTransitionProbability() {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            System.out.println(this.ruleArray[i].getTransitionProbability());
        }
    }

    public void setAllTransitionProbability(double mobility) {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            if (this.ruleArray[i].transitionProbabilityString.equals("$mobility")) {
                this.ruleArray[i].setTransitionProbability(mobility);
                continue;
            }
            this.ruleArray[i].setTransitionProbability();
        }
    }

    public Partition outputBlock(Partition neighbor) {
        int ruleEntry = this.getRuleEntry(neighbor);
        if (this.rand.nextDouble() < this.ruleArray[ruleEntry].getTransitionProbability()) {
            return this.getPartition(ruleEntry);
        }
        return new Partition(neighbor);
    }

    private int getConservationOutputAtRandom(int ruleEntry) {
        Partition partition = this.int2Partition(ruleEntry);
        partition.relocateParticlesAtRandom();
        return this.getRuleEntry(partition);
    }

    private Partition int2Partition(int entry) {
        Partition partition = new Partition(this.maxNeighbor);
        if (this.maxNeighbor == 4) {
            int j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 1);
            partition.setHomeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getHomeState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 2);
            partition.setEastState((byte)MyMath.idiv(entry, j));
            entry -= partition.getEastState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 3);
            partition.setSouthState((byte)MyMath.idiv(entry, j));
            partition.setEsState((byte)(entry -= partition.getSouthState() * j));
        } else if (this.maxNeighbor == 5) {
            int j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 1);
            partition.setHomeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getHomeState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 2);
            partition.setNorthState((byte)MyMath.idiv(entry, j));
            entry -= partition.getNorthState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 3);
            partition.setEastState((byte)MyMath.idiv(entry, j));
            entry -= partition.getEastState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 4);
            partition.setSouthState((byte)MyMath.idiv(entry, j));
            partition.setWestState((byte)(entry -= partition.getSouthState() * j));
        } else if (this.maxNeighbor == 9) {
            int j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 1);
            partition.setWnState((byte)MyMath.idiv(entry, j));
            entry -= partition.getWnState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 2);
            partition.setNorthState((byte)MyMath.idiv(entry, j));
            entry -= partition.getNorthState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 3);
            partition.setNeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getNeState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 4);
            partition.setWestState((byte)MyMath.idiv(entry, j));
            entry -= partition.getWestState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 5);
            partition.setHomeState((byte)MyMath.idiv(entry, j));
            entry -= partition.getHomeState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 6);
            partition.setEastState((byte)MyMath.idiv(entry, j));
            entry -= partition.getEastState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 7);
            partition.setSwState((byte)MyMath.idiv(entry, j));
            entry -= partition.getSwState() * j;
            j = MyMath.ipow(this.statePerCell, this.maxNeighbor - 8);
            partition.setSouthState((byte)MyMath.idiv(entry, j));
            partition.setEsState((byte)(entry -= partition.getSouthState() * j));
        } else {
            throw new RuntimeException("No such maxNeighbor defined.");
        }
        return partition;
    }

    private Partition getPartition(int ruleEntry) {
        int out = this.ruleArray[ruleEntry].output;
        return this.int2Partition(out);
    }

    private int getRuleEntry(Partition partition) {
        int sum = 0;
        if (this.maxNeighbor == 4) {
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 1) * partition.getHomeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 2) * partition.getEastState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 3) * partition.getSouthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 4) * partition.getEsState();
        } else if (this.maxNeighbor == 5) {
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 1) * partition.getHomeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 2) * partition.getNorthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 3) * partition.getEastState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 4) * partition.getSouthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 5) * partition.getWestState();
        } else if (this.maxNeighbor == 9) {
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 1) * partition.getWnState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 2) * partition.getNorthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 3) * partition.getNeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 4) * partition.getWestState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 5) * partition.getHomeState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 6) * partition.getEastState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 7) * partition.getSwState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 8) * partition.getSouthState();
            sum += MyMath.ipow(this.statePerCell, this.maxNeighbor - 9) * partition.getEsState();
        }
        return sum;
    }

    public double getMu() {
        int j = 0;
        for (int i = 0; i < this.ruleArray.length; ++i) {
            if (this.ruleArray[i].output == i) continue;
            ++j;
        }
        return (double)j / (double)this.ruleArray.length;
    }

    public StochasticRuleUnit getRuleArray(int entry) {
        return this.ruleArray[entry];
    }

    public void setRuleArray(int entry, int output) {
        this.ruleArray[entry].output = output;
    }

    public void setRuleArray(int entry, StochasticRuleUnit ruleUnit) {
        this.ruleArray[entry] = ruleUnit;
    }

    public void copyRule(StochasticPartitionRule source) {
        for (int i = 0; i < this.maxRuleEntry; ++i) {
            this.setRuleArray(i, source.getRuleArray(i).getOutput());
        }
    }

    @Override
    public String getDefaultThread() {
        return "MCSThread";
    }

    @Override
    public int getStatePerCell() {
        return this.statePerCell;
    }

    @Override
    public int getMaxNeighbor() {
        return this.maxNeighbor;
    }

    public int getMaxRuleEntry() {
        return this.maxRuleEntry;
    }
}

