/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.FrameLocation;
import cambria.VNRule;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class RuleTable
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private VNRule rule;
    private JTextArea ta;

    public RuleTable(VNRule rule) {
        super("raw rule definition without macro commands");
        this.initTable(rule);
    }

    public void initTable(VNRule rule) {
        this.rule = rule;
        this.ta = new JTextArea();
        this.ta.setEditable(false);
        this.ta.append(String.valueOf(rule.statePerCell) + ";" + System.getProperty("line.separator"));
        for (int h = 0; h < rule.statePerCell; ++h) {
            for (int n = 0; n < rule.statePerCell; ++n) {
                for (int e = 0; e < rule.statePerCell; ++e) {
                    for (int s = 0; s < rule.statePerCell; ++s) {
                        for (int w = 0; w < rule.statePerCell; ++w) {
                            this.ta.append(this.constructLine(h, n, e, s, w));
                        }
                    }
                }
            }
        }
        this.add("Center", this.ta);
    }

    public void showTable() {
        JPanel subPanel = new JPanel();
        JButton saveButton = new JButton("save");
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);
        subPanel.add(saveButton);
        JButton closeButton = new JButton("close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        subPanel.add(closeButton);
        this.add("South", subPanel);
        this.setLocation(FrameLocation.getPoint("center", this));
        this.pack();
        this.setVisible(true);
    }

    protected String constructLine(int home, int north, int east, int south, int west) {
        int next = this.rule.output((byte)home, (byte)north, (byte)east, (byte)south, (byte)west);
        return Integer.toString(home) + " " + Integer.toString(north) + " " + Integer.toString(east) + " " + Integer.toString(south) + " " + Integer.toString(west) + " " + Integer.toString(next) + ";" + System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveTable(String fileName) {
        BufferedWriter bw;
        try {
            FileWriter fw = new FileWriter(fileName);
            bw = new BufferedWriter(fw);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return;
        }
        try {
            bw.write(this.ta.getText(), 0, this.ta.getText().length());
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("close")) {
            this.setVisible(false);
        } else if (command.equals("save")) {
            String file = null;
            String dir = null;
            FileDialog fdSave = new FileDialog((Frame)this, "Save", 0);
            fdSave.setVisible(true);
            file = fdSave.getFile();
            dir = fdSave.getDirectory();
            if (file == null) {
                return;
            }
            this.saveTable(dir + file);
        }
    }
}

