/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.stat.Statistic;

public class RuleStatistic {
    public static int getCombination(int place, int object) {
        if (place < object) {
            throw new IllegalArgumentException();
        }
        return RuleStatistic.getFactorial(place) / (RuleStatistic.getFactorial(object) * RuleStatistic.getFactorial(place - object));
    }

    public static int getFactorial(int i) {
        int factorial = 1;
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        if (i == 0) {
            return 1;
        }
        for (int j = 0; j < i; ++j) {
            factorial *= i - j;
        }
        return factorial;
    }

    public static double mutualEntropy(int entryA, int entryB, int maxRuleEntry, double[][][][] normCooccurProb) {
        double[] prob = new double[maxRuleEntry * maxRuleEntry];
        int index = 0;
        for (int i = 0; i < maxRuleEntry; ++i) {
            for (int j = 0; j < maxRuleEntry; ++j) {
                prob[index] = normCooccurProb[entryA][i][entryB][j];
                ++index;
            }
        }
        return Statistic.shannon(prob);
    }

    public static double getSumCooccureProb(int entryA, int entryB, double[][][][] cooccurProb) {
        if (entryA >= entryB) {
            throw new RuntimeException();
        }
        double sum = 0.0;
        int maxRuleEntry = cooccurProb.length;
        for (int ja = 0; ja < maxRuleEntry; ++ja) {
            for (int jb = 0; jb < maxRuleEntry; ++jb) {
                sum += cooccurProb[entryA][ja][entryB][jb];
            }
        }
        return sum;
    }

    public static double[][][][] calculateNormCooccurProb(int[][] ruleArray) {
        int maxRuleEntry = ruleArray.length;
        double[][][][] cooccurProb = RuleStatistic.calculateCooccurProb(ruleArray);
        double[][][][] normCooccurProb = new double[maxRuleEntry][maxRuleEntry][maxRuleEntry][maxRuleEntry];
        for (int ia = 0; ia < maxRuleEntry; ++ia) {
            for (int ja = 0; ja < maxRuleEntry; ++ja) {
                for (int ib = 0; ib < maxRuleEntry; ++ib) {
                    for (int jb = 0; jb < maxRuleEntry; ++jb) {
                        if (cooccurProb[ia][ja][ib][jb] != 0.0) {
                            if (RuleStatistic.getProb(ia, ja, ruleArray) == 0.0 || RuleStatistic.getProb(ib, jb, ruleArray) == 0.0) {
                                System.out.println(cooccurProb[ia][ja][ib][jb]);
                                throw new RuntimeException("Contradictory co-occurrence");
                            }
                            normCooccurProb[ia][ja][ib][jb] = cooccurProb[ia][ja][ib][jb] / (RuleStatistic.getProb(ia, ja, ruleArray) * RuleStatistic.getProb(ib, jb, ruleArray));
                            continue;
                        }
                        normCooccurProb[ia][ja][ib][jb] = 0.0;
                    }
                }
            }
        }
        return normCooccurProb;
    }

    public static double conditionalProb(int input, int output, boolean[] condition, int[][] ruleArray) {
        int maxRule = condition.length;
        int cumulative = 0;
        int all = 0;
        for (int i = 0; i < maxRule; ++i) {
            if (!condition[i]) continue;
            ++all;
            if (ruleArray[input][i] != output) continue;
            ++cumulative;
        }
        return all == 0 ? 0.0 : (double)cumulative / (double)all;
    }

    public static double[][][][] calculateCooccurProb(int[][] ruleArray) {
        int maxRuleEntry = ruleArray.length;
        double[][][][] cooccurProb = new double[maxRuleEntry][maxRuleEntry][maxRuleEntry][maxRuleEntry];
        for (int ia = 0; ia < maxRuleEntry; ++ia) {
            for (int ja = 0; ja < maxRuleEntry; ++ja) {
                boolean[] satisfied = RuleStatistic.collectSatisfied(ia, ja, ruleArray);
                for (int ib = 0; ib < maxRuleEntry; ++ib) {
                    for (int jb = 0; jb < maxRuleEntry; ++jb) {
                        cooccurProb[ia][ja][ib][jb] = ib <= ia ? 0.0 : RuleStatistic.conditionalProb(ib, jb, satisfied, ruleArray) * RuleStatistic.getProb(ia, ja, ruleArray);
                    }
                }
            }
        }
        return cooccurProb;
    }

    public static double getProb(int input, int output, int[][] ruleArray) {
        int sum = 0;
        int maxRule = ruleArray[0].length;
        for (int i = 0; i < maxRule; ++i) {
            if (ruleArray[input][i] != output) continue;
            ++sum;
        }
        return (double)sum / (double)maxRule;
    }

    public static boolean[] collectSatisfied(int input, int output, int[][] ruleArray) {
        int maxRule = ruleArray[0].length;
        int maxRuleEntry = ruleArray.length;
        boolean[] satisfied = new boolean[maxRule];
        for (int i = 0; i < maxRule; ++i) {
            satisfied[i] = ruleArray[input][i] == output;
        }
        return satisfied;
    }

    public static double getJointEntropy(int entryA, int entryB, double[][][][] cooccurProb) {
        int maxRuleEntry = cooccurProb.length;
        return RuleStatistic.getJointEntropy(entryA, entryB, cooccurProb, maxRuleEntry * maxRuleEntry);
    }

    public static double getJointEntropy(int entryA, int entryB, double[][][][] cooccurProb, int nbase) {
        if (entryA >= entryB) {
            throw new RuntimeException("EntryA mast be smaller than EntryB.");
        }
        int maxRuleEntry = cooccurProb.length;
        int combi = maxRuleEntry * maxRuleEntry;
        double[] prob = new double[combi];
        int index = 0;
        for (int i = 0; i < maxRuleEntry; ++i) {
            for (int j = 0; j < maxRuleEntry; ++j) {
                prob[index] = cooccurProb[entryA][i][entryB][j];
                ++index;
            }
        }
        if (combi != index) {
            throw new RuntimeException();
        }
        return Statistic.shannon(prob, nbase);
    }

    public static double getRuleEntropy(int entry, int[][] ruleArray) {
        int maxRuleEntry = ruleArray.length;
        return RuleStatistic.getRuleEntropy(entry, ruleArray, maxRuleEntry);
    }

    public static double getRuleEntropy(int entry, int[][] ruleArray, int nbase) {
        if (nbase == 1) {
            return 0.0;
        }
        int maxRule = ruleArray[0].length;
        int maxRuleEntry = ruleArray.length;
        int[] cumulative = new int[maxRuleEntry];
        for (int i = 0; i < maxRule; ++i) {
            int n = ruleArray[entry][i];
            cumulative[n] = cumulative[n] + 1;
        }
        double[] prob = new double[maxRuleEntry];
        for (int i = 0; i < maxRuleEntry; ++i) {
            prob[i] = (double)cumulative[i] / (double)maxRule;
        }
        double probSum = 0.0;
        for (int i = 0; i < maxRuleEntry; ++i) {
            probSum += prob[i];
        }
        if (1.0 - probSum > 1.0E-6) {
            throw new RuntimeException();
        }
        return Statistic.shannon(prob, nbase);
    }

    public static double[] getTransProb(int[][] ruleArray, int entry) {
        int i;
        int maxRuleEntry = ruleArray.length;
        int maxRule = ruleArray[0].length;
        int[] cumulative = new int[maxRuleEntry];
        double[] prob = new double[maxRuleEntry];
        for (i = 0; i < maxRule; ++i) {
            int n = ruleArray[entry][i];
            cumulative[n] = cumulative[n] + 1;
        }
        for (i = 0; i < maxRuleEntry; ++i) {
            prob[i] = (double)cumulative[i] / (double)maxRule;
        }
        return prob;
    }
}

