/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.StochasticRuleUnit;
import cambria.misc.MyMath;
import cambria.misc.MyString;
import java.io.IOException;
import java.io.StringReader;

public class PartitionRuleString {
    public static String[] getRuleStringComp(String RuleString) {
        int[] indexPosition = new int[256];
        int j = 0;
        while (RuleString.indexOf("switch", indexPosition[j]) != -1) {
            indexPosition[j + 1] = RuleString.indexOf("switch", indexPosition[j]) + 6;
            ++j;
        }
        String[] RuleStringComp = new String[j];
        j = 0;
        while (indexPosition[j + 1] - 6 > indexPosition[j]) {
            RuleStringComp[j] = RuleString.substring(indexPosition[j], indexPosition[j + 1] - 6);
            ++j;
        }
        return RuleStringComp;
    }

    public static boolean isStochastic(String RuleString) {
        int i = 0;
        boolean stochastic = false;
        while (MyString.lindex(RuleString, i) != null && !stochastic) {
            String string = MyString.lindex(RuleString, i);
            if (string.charAt(0) != '!' && string.charAt(0) != '%' && string.indexOf("tp=") != -1) {
                stochastic = true;
            }
            ++i;
        }
        return stochastic;
    }

    public static String selectRuleString(int index, String RuleString) {
        int digit = 0;
        boolean[] isRuleOn = MyMath.getBinaryArray(index);
        StringBuffer newString = new StringBuffer();
        int i = 0;
        while (MyString.lindex(RuleString, i) != null) {
            String string = MyString.lindex(RuleString, i);
            if (string != null && string.charAt(0) != '!') {
                if (string.charAt(0) == '%') {
                    if (isRuleOn[digit]) {
                        newString.append(string.substring(1));
                        newString.append(" ");
                    }
                    ++digit;
                } else {
                    newString.append(string);
                    newString.append(" ");
                }
            }
            ++i;
        }
        return newString.toString().trim();
    }

    public static StochasticRuleUnit[] createRuleArray(int statePerCell, int maxNeighbor, String RuleString) {
        String rotSymbol = "r:";
        if (maxNeighbor != 4 && maxNeighbor != 5 && maxNeighbor != 9) {
            throw new IllegalArgumentException("Invalid maxNeighbor");
        }
        int maxRuleEntry = MyMath.ipow(statePerCell, maxNeighbor);
        StochasticRuleUnit[] ruleArray = PartitionRuleString.initializeRuleArray(maxRuleEntry);
        String currentTransitionProbabilityString = "1.0";
        int i = 0;
        while (MyString.lindex(RuleString, i) != null) {
            String string = MyString.lindex(RuleString, i);
            if (string != null && string.charAt(0) != '!' && string.charAt(0) != '%') {
                int k;
                int j;
                String back;
                String front;
                if (string.substring(0, 3).equals("tp=")) {
                    currentTransitionProbabilityString = string.substring(3);
                } else if (string.substring(0, 2).equals(rotSymbol)) {
                    front = MyString.stripFront(string.substring(rotSymbol.length()), ':');
                    back = MyString.stripBack(string.substring(rotSymbol.length()), ':');
                    if (maxNeighbor == 4) {
                        for (int n = 0; n < 4; ++n) {
                            j = PartitionRuleString.getEntry(statePerCell, maxNeighbor, PartitionRuleString.getRotation4(front, n));
                            ruleArray[j].output = k = PartitionRuleString.getEntry(statePerCell, maxNeighbor, PartitionRuleString.getRotation4(back, n));
                            ruleArray[j].transitionProbabilityString = currentTransitionProbabilityString;
                        }
                    } else if (maxNeighbor == 5) {
                        for (int n = 0; n < 4; ++n) {
                            j = PartitionRuleString.getEntry(statePerCell, maxNeighbor, PartitionRuleString.getRotation5(front, n));
                            ruleArray[j].output = k = PartitionRuleString.getEntry(statePerCell, maxNeighbor, PartitionRuleString.getRotation5(back, n));
                            ruleArray[j].transitionProbabilityString = currentTransitionProbabilityString;
                        }
                    } else if (maxNeighbor == 9) {
                        for (int n = 0; n < 4; ++n) {
                            j = PartitionRuleString.getEntry(statePerCell, maxNeighbor, PartitionRuleString.getRotation9(front, n));
                            ruleArray[j].output = k = PartitionRuleString.getEntry(statePerCell, maxNeighbor, PartitionRuleString.getRotation9(back, n));
                            ruleArray[j].transitionProbabilityString = currentTransitionProbabilityString;
                        }
                    }
                } else if (string.charAt(0) == 't') {
                    front = MyString.stripFront(string, ':');
                    String expandedFront = null;
                    String back2 = MyString.stripBack(string, ':');
                    if (!PartitionRuleString.isValidTotal(statePerCell, front)) {
                        throw new RuntimeException("Invalid totalistic entryCode");
                    }
                    expandedFront = PartitionRuleString.collectEntryTotal(statePerCell, maxNeighbor, front);
                    int index = 0;
                    String entry = MyString.lindex(expandedFront, index);
                    do {
                        j = PartitionRuleString.getEntry(statePerCell, maxNeighbor, entry);
                        ruleArray[j].output = k = PartitionRuleString.getEntry(statePerCell, maxNeighbor, back2);
                        ruleArray[j].transitionProbabilityString = currentTransitionProbabilityString;
                    } while ((entry = MyString.lindex(expandedFront, ++index)) != null);
                } else {
                    front = MyString.stripFront(string, ':');
                    j = PartitionRuleString.getEntry(statePerCell, maxNeighbor, front);
                    back = MyString.stripBack(string, ':');
                    ruleArray[j].output = k = PartitionRuleString.getEntry(statePerCell, maxNeighbor, back);
                    ruleArray[j].transitionProbabilityString = currentTransitionProbabilityString;
                }
            }
            ++i;
        }
        return ruleArray;
    }

    public static StochasticRuleUnit[] initializeRuleArray(int maxRuleEntry) {
        StochasticRuleUnit[] ruleArray = new StochasticRuleUnit[maxRuleEntry];
        for (int i = 0; i < maxRuleEntry; ++i) {
            ruleArray[i] = new StochasticRuleUnit();
            ruleArray[i].setOutput(i);
            ruleArray[i].transitionProbabilityString = "1.0";
        }
        return ruleArray;
    }

    private static boolean isValidTotal(int statePerCell, String front) {
        return front.length() == statePerCell + 1;
    }

    private static String collectEntryTotal(int statePerCell, int maxNeighbor, String front) {
        if (front == null) {
            throw new IllegalArgumentException("Invalid totalistic entryCode");
        }
        if (statePerCell < 2) {
            throw new IllegalArgumentException("Invalid statePerCell");
        }
        if (maxNeighbor == 4) {
            return PartitionRuleString.collectEntryTotal4(statePerCell, front);
        }
        if (maxNeighbor == 5) {
            return PartitionRuleString.collectEntryTotal5(statePerCell, front);
        }
        if (maxNeighbor == 9) {
            return PartitionRuleString.collectEntryTotal9(statePerCell, front);
        }
        throw new IllegalArgumentException("Invalid maxNeighbor");
    }

    private static String collectEntryTotal4(int statePerCell, String expectedTotal) {
        if (expectedTotal == null) {
            throw new IllegalArgumentException("Null totalistic entryCode");
        }
        if (statePerCell < 2) {
            throw new IllegalArgumentException("Invalid statePerCell");
        }
        StringBuffer entries = new StringBuffer();
        for (int i0 = 0; i0 < statePerCell; ++i0) {
            for (int i1 = 0; i1 < statePerCell; ++i1) {
                for (int i2 = 0; i2 < statePerCell; ++i2) {
                    for (int i3 = 0; i3 < statePerCell; ++i3) {
                        char[] entryCodeChar = new char[]{'c', (char)(i0 + 48), (char)(i1 + 48), (char)(i2 + 48), (char)(i3 + 48)};
                        String entryCode = String.valueOf(entryCodeChar);
                        String total = PartitionRuleString.getTotalisticEntry(statePerCell, entryCode);
                        if (!expectedTotal.equals(total)) continue;
                        entries.append(entryCodeChar);
                        entries.append(' ');
                    }
                }
            }
        }
        if (entries == null) {
            throw new NullPointerException("No matching entries.");
        }
        return entries.toString().trim();
    }

    private static String collectEntryTotal5(int statePerCell, String expectedTotal) {
        if (expectedTotal == null) {
            throw new IllegalArgumentException("Null totalistic entryCode");
        }
        if (statePerCell < 2) {
            throw new IllegalArgumentException("Invalid statePerCell");
        }
        StringBuffer entries = new StringBuffer();
        for (int i0 = 0; i0 < statePerCell; ++i0) {
            for (int i1 = 0; i1 < statePerCell; ++i1) {
                for (int i2 = 0; i2 < statePerCell; ++i2) {
                    for (int i3 = 0; i3 < statePerCell; ++i3) {
                        for (int i4 = 0; i4 < statePerCell; ++i4) {
                            char[] entryCodeChar = new char[]{'c', (char)(i0 + 48), (char)(i1 + 48), (char)(i2 + 48), (char)(i3 + 48), (char)(i4 + 48)};
                            String entryCode = String.valueOf(entryCodeChar);
                            String total = PartitionRuleString.getTotalisticEntry(statePerCell, entryCode);
                            if (!expectedTotal.equals(total)) continue;
                            entries.append(entryCodeChar);
                            entries.append(' ');
                        }
                    }
                }
            }
        }
        if (entries == null) {
            throw new NullPointerException("No matching entries.");
        }
        return entries.toString().trim();
    }

    private static String collectEntryTotal9(int statePerCell, String expectedTotal) {
        if (expectedTotal == null) {
            throw new IllegalArgumentException("Invalid totalistic entryCode");
        }
        if (statePerCell < 2) {
            throw new IllegalArgumentException("Invalid statePerCell");
        }
        StringBuffer entries = new StringBuffer();
        for (int i0 = 0; i0 < statePerCell; ++i0) {
            for (int i1 = 0; i1 < statePerCell; ++i1) {
                for (int i2 = 0; i2 < statePerCell; ++i2) {
                    for (int i3 = 0; i3 < statePerCell; ++i3) {
                        for (int i4 = 0; i4 < statePerCell; ++i4) {
                            for (int i5 = 0; i5 < statePerCell; ++i5) {
                                for (int i6 = 0; i6 < statePerCell; ++i6) {
                                    for (int i7 = 0; i7 < statePerCell; ++i7) {
                                        for (int i8 = 0; i8 < statePerCell; ++i8) {
                                            char[] entryCodeChar = new char[]{'c', (char)(i0 + 48), (char)(i1 + 48), (char)(i2 + 48), (char)(i3 + 48), (char)(i4 + 48), (char)(i5 + 48), (char)(i6 + 48), (char)(i7 + 48), (char)(i8 + 48)};
                                            String entryCode = String.valueOf(entryCodeChar);
                                            String total = PartitionRuleString.getTotalisticEntry(statePerCell, entryCode);
                                            if (!expectedTotal.equals(total)) continue;
                                            entries.append(entryCodeChar);
                                            entries.append(' ');
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (entries == null) {
            throw new NullPointerException("No matching entries.");
        }
        return entries.toString().trim();
    }

    private static String getTotalisticEntry(int statePerCell, String entryCode) {
        if (entryCode == null) {
            throw new IllegalArgumentException("entryCode is null");
        }
        int[] total = new int[statePerCell];
        StringReader sr = new StringReader(entryCode);
        try {
            char char0 = (char)sr.read();
            int index = 1;
            do {
                if ((char0 = (char)sr.read()) < '0') {
                    throw new RuntimeException("not character");
                }
                int n = char0 - 48;
                total[n] = total[n] + 1;
            } while (++index < entryCode.length());
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        sr.close();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('t');
        for (int i = 0; i < statePerCell; ++i) {
            stringBuffer.append((char)(total[i] + 48));
        }
        return stringBuffer.toString();
    }

    private static String getRotation9(String string, int rot) {
        char[] rotated = new char[10];
        if (rot < 0 || rot > 3 || string.charAt(0) != 'c') {
            throw new IllegalArgumentException("Invalid rot or string");
        }
        rotated[0] = 99;
        if (rot == 0) {
            rotated[1] = string.charAt(1);
            rotated[2] = string.charAt(2);
            rotated[3] = string.charAt(3);
            rotated[4] = string.charAt(4);
            rotated[5] = string.charAt(5);
            rotated[6] = string.charAt(6);
            rotated[7] = string.charAt(7);
            rotated[8] = string.charAt(8);
            rotated[9] = string.charAt(9);
        } else if (rot == 1) {
            rotated[1] = string.charAt(7);
            rotated[2] = string.charAt(4);
            rotated[3] = string.charAt(1);
            rotated[4] = string.charAt(8);
            rotated[5] = string.charAt(5);
            rotated[6] = string.charAt(2);
            rotated[7] = string.charAt(9);
            rotated[8] = string.charAt(6);
            rotated[9] = string.charAt(3);
        } else if (rot == 2) {
            rotated[1] = string.charAt(9);
            rotated[2] = string.charAt(8);
            rotated[3] = string.charAt(7);
            rotated[4] = string.charAt(6);
            rotated[5] = string.charAt(5);
            rotated[6] = string.charAt(4);
            rotated[7] = string.charAt(3);
            rotated[8] = string.charAt(2);
            rotated[9] = string.charAt(1);
        } else if (rot == 3) {
            rotated[1] = string.charAt(3);
            rotated[2] = string.charAt(6);
            rotated[3] = string.charAt(9);
            rotated[4] = string.charAt(2);
            rotated[5] = string.charAt(5);
            rotated[6] = string.charAt(8);
            rotated[7] = string.charAt(1);
            rotated[8] = string.charAt(4);
            rotated[9] = string.charAt(7);
        }
        return new String(rotated);
    }

    private static String getRotation5(String string, int rot) {
        char[] rotated = new char[6];
        if (rot < 0 || rot > 3 || string.charAt(0) != 'c') {
            throw new IllegalArgumentException();
        }
        rotated[0] = 99;
        if (rot == 0) {
            rotated[1] = string.charAt(1);
            rotated[2] = string.charAt(2);
            rotated[3] = string.charAt(3);
            rotated[4] = string.charAt(4);
            rotated[5] = string.charAt(5);
        } else if (rot == 1) {
            rotated[1] = string.charAt(1);
            rotated[2] = string.charAt(3);
            rotated[3] = string.charAt(4);
            rotated[4] = string.charAt(5);
            rotated[5] = string.charAt(2);
        } else if (rot == 2) {
            rotated[1] = string.charAt(1);
            rotated[2] = string.charAt(4);
            rotated[3] = string.charAt(5);
            rotated[4] = string.charAt(2);
            rotated[5] = string.charAt(3);
        } else if (rot == 3) {
            rotated[1] = string.charAt(1);
            rotated[2] = string.charAt(5);
            rotated[3] = string.charAt(2);
            rotated[4] = string.charAt(3);
            rotated[5] = string.charAt(4);
        }
        return new String(rotated);
    }

    private static String getRotation4(String string, int rot) {
        char[] rotated = new char[5];
        if (rot < 0 || rot > 3 || string.charAt(0) != 'c') {
            throw new IllegalArgumentException();
        }
        rotated[0] = 99;
        if (rot == 0) {
            rotated[1] = string.charAt(1);
            rotated[2] = string.charAt(2);
            rotated[3] = string.charAt(3);
            rotated[4] = string.charAt(4);
        } else if (rot == 1) {
            rotated[1] = string.charAt(3);
            rotated[2] = string.charAt(1);
            rotated[3] = string.charAt(4);
            rotated[4] = string.charAt(2);
        } else if (rot == 2) {
            rotated[1] = string.charAt(4);
            rotated[2] = string.charAt(3);
            rotated[3] = string.charAt(2);
            rotated[4] = string.charAt(1);
        } else if (rot == 3) {
            rotated[1] = string.charAt(2);
            rotated[2] = string.charAt(4);
            rotated[3] = string.charAt(1);
            rotated[4] = string.charAt(3);
        }
        return new String(rotated);
    }

    private static int getEntry(int statePerCell, int maxNeighbor, String string) {
        int j = 0;
        if (string.charAt(0) == 'c') {
            j = PartitionRuleString.code2entry(statePerCell, maxNeighbor, string);
        } else {
            try {
                j = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return j;
    }

    private static int code2entry(int statePerCell, int maxNeighbor, String code) {
        if (code.charAt(0) != 'c' || code.length() != maxNeighbor + 1) {
            throw new IllegalArgumentException("Invalid ruleCode.");
        }
        if (statePerCell > 9) {
            throw new IllegalArgumentException("Too large statePerCell");
        }
        int maxRuleEntry = MyMath.ipow(statePerCell, maxNeighbor);
        int entry = 0;
        for (int i = 0; i < maxNeighbor; ++i) {
            int state = Integer.parseInt(code.substring(i + 1, i + 2));
            entry += MyMath.ipow(statePerCell, maxNeighbor - i - 1) * state;
        }
        return entry;
    }
}

