/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.misc.MyMath;

public class Partition
extends BlockOfCells {
    private int NORTHWEST;
    private int NORTH;
    private int NORTHEAST;
    private int WEST;
    private int HOME;
    private int EAST;
    private int SOUTHWEST;
    private int SOUTH;
    private int SOUTHEAST;
    private int NORTHEASTEAST;
    private int EASTEAST;
    private int SOUTHEASTEAST;
    private int SOUTHSOUTHWEST;
    private int SOUTHSOUTH;
    private int SOUTHSOUTHEAST;
    private int SOUTHSOUTHEASTEAST;
    private byte[] neighborState;
    private int maxNeighbor;
    private int x;
    private int y;
    private boolean torus = true;

    public Partition(int maxNeighbor, boolean torus) {
        this(maxNeighbor);
        this.torus = torus;
    }

    public Partition(int maxNeighbor) {
        if (maxNeighbor != 4 && maxNeighbor != 5 && maxNeighbor != 9 && maxNeighbor != 16) {
            throw new IllegalArgumentException("Invalid maxNeighbor");
        }
        this.maxNeighbor = maxNeighbor;
        this.neighborState = new byte[maxNeighbor];
        if (maxNeighbor == 4) {
            this.HOME = 0;
            this.EAST = 1;
            this.SOUTH = 2;
            this.SOUTHEAST = 3;
        } else if (maxNeighbor == 5) {
            this.HOME = 0;
            this.NORTH = 1;
            this.EAST = 2;
            this.SOUTH = 3;
            this.WEST = 4;
        } else if (maxNeighbor == 9) {
            this.NORTHWEST = 0;
            this.NORTH = 1;
            this.NORTHEAST = 2;
            this.WEST = 3;
            this.HOME = 4;
            this.EAST = 5;
            this.SOUTHWEST = 6;
            this.SOUTH = 7;
            this.SOUTHEAST = 8;
        } else {
            this.NORTHWEST = 0;
            this.NORTH = 1;
            this.NORTHEAST = 2;
            this.NORTHEASTEAST = 3;
            this.WEST = 4;
            this.HOME = 5;
            this.EAST = 6;
            this.EASTEAST = 7;
            this.SOUTHWEST = 8;
            this.SOUTH = 9;
            this.SOUTHEAST = 10;
            this.SOUTHEASTEAST = 11;
            this.SOUTHSOUTHWEST = 12;
            this.SOUTHSOUTH = 13;
            this.SOUTHSOUTHEAST = 14;
            this.SOUTHSOUTHEASTEAST = 15;
        }
    }

    public Partition(int maxNeighbor, byte[][] caState, int x, int y) {
        this(maxNeighbor);
        this.make(caState, x, y);
    }

    public Partition(Partition partition) {
        this(partition.getMaxNeighbor());
        this.neighborState[this.HOME] = partition.getHomeState();
        this.neighborState[this.NORTH] = partition.getNorthState();
        this.neighborState[this.EAST] = partition.getEastState();
        this.neighborState[this.SOUTH] = partition.getSouthState();
        this.neighborState[this.WEST] = partition.getWestState();
        this.neighborState[this.NORTHEAST] = partition.getNeState();
        this.neighborState[this.SOUTHEAST] = partition.getEsState();
        this.neighborState[this.SOUTHWEST] = partition.getSwState();
        this.neighborState[this.NORTHWEST] = partition.getWnState();
        this.neighborState[this.NORTHEASTEAST] = partition.getNeeState();
        this.neighborState[this.SOUTHEASTEAST] = partition.getEeState();
        this.neighborState[this.EASTEAST] = partition.getEesState();
        this.neighborState[this.SOUTHSOUTHWEST] = partition.getSswState();
        this.neighborState[this.SOUTHSOUTH] = partition.getSsState();
        this.neighborState[this.SOUTHSOUTHEAST] = partition.getEssState();
        this.neighborState[this.SOUTHSOUTHEASTEAST] = partition.getEessState();
        this.torus = partition.isTorus();
    }

    public static Partition getCheckerboard() {
        Partition refPattern = new Partition(9);
        refPattern.setWnState((byte)0);
        refPattern.setNorthState((byte)1);
        refPattern.setNeState((byte)0);
        refPattern.setWestState((byte)1);
        refPattern.setHomeState((byte)0);
        refPattern.setEastState((byte)1);
        refPattern.setSwState((byte)0);
        refPattern.setSouthState((byte)1);
        refPattern.setEsState((byte)0);
        return refPattern;
    }

    @Override
    public void make(byte[][] caState, int x, int y) {
        this.x = x;
        this.y = y;
        if (this.torus) {
            this.makeTorus(caState, x, y);
        } else {
            this.makeLS(caState, x, y);
        }
    }

    @Override
    public void setTorus(boolean torus) {
        this.torus = torus;
    }

    @Override
    public boolean isTorus() {
        return this.torus;
    }

    @Override
    public void updateCAState(byte[][] caState, int x, int y) {
        int x_max = caState.length;
        int y_max = caState[0].length;
        int east = (x + 1) % x_max;
        int eastEast = (x + 2) % x_max;
        int south = (y + 1) % y_max;
        int southSouth = (y + 2) % y_max;
        int west = (x - 1 + x_max) % x_max;
        int north = (y - 1 + y_max) % y_max;
        caState[x][y] = this.getHomeState();
        caState[east][y] = this.getEastState();
        caState[x][south] = this.getSouthState();
        if (this.maxNeighbor == 4) {
            caState[east][south] = this.getEsState();
        } else if (this.maxNeighbor == 5) {
            caState[x][north] = this.getNorthState();
            caState[west][y] = this.getWestState();
        } else if (this.maxNeighbor == 9) {
            caState[x][north] = this.getNorthState();
            caState[west][y] = this.getWestState();
            caState[east][south] = this.getEsState();
            caState[east][north] = this.getNeState();
            caState[west][south] = this.getSwState();
            caState[west][north] = this.getWnState();
        }
    }

    private void makeTorus(byte[][] caState, int x, int y) {
        int x_max = caState.length;
        int y_max = caState[0].length;
        int east = (x + 1) % x_max;
        int eastEast = (x + 2) % x_max;
        int south = (y + 1) % y_max;
        int southSouth = (y + 2) % y_max;
        int west = (x - 1 + x_max) % x_max;
        int north = (y - 1 + y_max) % y_max;
        this.setHomeState(caState[x][y]);
        this.setEastState(caState[east][y]);
        this.setSouthState(caState[x][south]);
        if (this.maxNeighbor == 4) {
            this.setEsState(caState[east][south]);
        } else if (this.maxNeighbor == 5) {
            this.setNorthState(caState[x][north]);
            this.setWestState(caState[west][y]);
        } else if (this.maxNeighbor == 9) {
            this.setEsState(caState[east][south]);
            this.setNorthState(caState[x][north]);
            this.setWestState(caState[west][y]);
            this.setNeState(caState[east][north]);
            this.setSwState(caState[west][south]);
            this.setWnState(caState[west][north]);
        } else if (this.maxNeighbor == 16) {
            this.setEsState(caState[east][south]);
            this.setNorthState(caState[x][north]);
            this.setWestState(caState[west][y]);
            this.setNeState(caState[east][north]);
            this.setSwState(caState[west][south]);
            this.setWnState(caState[west][north]);
            this.setNeeState(caState[eastEast][north]);
            this.setEeState(caState[eastEast][y]);
            this.setEesState(caState[eastEast][south]);
            this.setSswState(caState[west][southSouth]);
            this.setSsState(caState[x][southSouth]);
            this.setEssState(caState[east][southSouth]);
            this.setEessState(caState[eastEast][southSouth]);
        }
    }

    private void makeLS(byte[][] caState, int x, int y) {
        int x_max = caState.length;
        int y_max = caState[0].length;
        int east = x + 1;
        int eastEast = x + 2;
        int south = y + 1;
        int southSouth = y + 2;
        int north = y - 1;
        int west = x - 1;
        this.setHomeState(caState[x][y]);
        try {
            this.setEastState(caState[east][y]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.setEastState((byte)0);
        }
        try {
            this.setSouthState(caState[x][south]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.setSouthState((byte)0);
        }
        if (this.maxNeighbor == 4) {
            try {
                this.setEsState(caState[east][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEsState((byte)0);
            }
        } else if (this.maxNeighbor == 5) {
            try {
                this.setNorthState(caState[x][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNorthState((byte)0);
            }
            try {
                this.setWestState(caState[west][y]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setWestState((byte)0);
            }
        } else if (this.maxNeighbor == 9) {
            try {
                this.setNorthState(caState[x][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNorthState((byte)0);
            }
            try {
                this.setWestState(caState[west][y]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setWestState((byte)0);
            }
            try {
                this.setEsState(caState[east][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEsState((byte)0);
            }
            try {
                this.setNeState(caState[east][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNeState((byte)0);
            }
            try {
                this.setSwState(caState[west][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setSwState((byte)0);
            }
            try {
                this.setWnState(caState[west][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setWnState((byte)0);
            }
        } else if (this.maxNeighbor == 16) {
            try {
                this.setNorthState(caState[x][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNorthState((byte)0);
            }
            try {
                this.setWestState(caState[west][y]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setWestState((byte)0);
            }
            try {
                this.setEsState(caState[east][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEsState((byte)0);
            }
            try {
                this.setNeState(caState[east][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNeState((byte)0);
            }
            try {
                this.setSwState(caState[west][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setSwState((byte)0);
            }
            try {
                this.setWnState(caState[west][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setWnState((byte)0);
            }
            try {
                this.setNeeState(caState[eastEast][north]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setNeeState((byte)0);
            }
            try {
                this.setEeState(caState[eastEast][y]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEeState((byte)0);
            }
            try {
                this.setEesState(caState[eastEast][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEesState((byte)0);
            }
            try {
                this.setSswState(caState[west][southSouth]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setSswState((byte)0);
            }
            try {
                this.setSsState(caState[x][southSouth]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setSsState((byte)0);
            }
            try {
                this.setEssState(caState[east][southSouth]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEssState((byte)0);
            }
            try {
                this.setEessState(caState[eastEast][southSouth]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEessState((byte)0);
            }
        }
    }

    @Override
    public byte[] getNeighborState() {
        return this.neighborState;
    }

    public byte getHomeState() {
        return this.neighborState[this.HOME];
    }

    public byte getNorthState() {
        return this.neighborState[this.NORTH];
    }

    public byte getEastState() {
        return this.neighborState[this.EAST];
    }

    public byte getSouthState() {
        return this.neighborState[this.SOUTH];
    }

    public byte getWestState() {
        return this.neighborState[this.WEST];
    }

    public byte getNeState() {
        return this.neighborState[this.NORTHEAST];
    }

    public byte getEsState() {
        return this.neighborState[this.SOUTHEAST];
    }

    public byte getSwState() {
        return this.neighborState[this.SOUTHWEST];
    }

    public byte getWnState() {
        return this.neighborState[this.NORTHWEST];
    }

    public byte getNeeState() {
        return this.neighborState[this.NORTHEASTEAST];
    }

    public byte getEeState() {
        return this.neighborState[this.SOUTHEASTEAST];
    }

    public byte getEesState() {
        return this.neighborState[this.EASTEAST];
    }

    public byte getSswState() {
        return this.neighborState[this.SOUTHSOUTHWEST];
    }

    public byte getSsState() {
        return this.neighborState[this.SOUTHSOUTH];
    }

    public byte getEssState() {
        return this.neighborState[this.SOUTHSOUTHEAST];
    }

    public byte getEessState() {
        return this.neighborState[this.SOUTHSOUTHEASTEAST];
    }

    @Override
    public void setNeighborState(byte[] neighborState) {
        if (neighborState.length != this.maxNeighbor) {
            throw new IllegalArgumentException("Neighbor type does not match.");
        }
        for (int i = 0; i < this.maxNeighbor; ++i) {
            this.neighborState[i] = neighborState[i];
        }
    }

    public void setHomeState(byte state) {
        this.neighborState[this.HOME] = state;
    }

    public void setNorthState(byte state) {
        this.neighborState[this.NORTH] = state;
    }

    public void setEastState(byte state) {
        this.neighborState[this.EAST] = state;
    }

    public void setSouthState(byte state) {
        this.neighborState[this.SOUTH] = state;
    }

    public void setWestState(byte state) {
        this.neighborState[this.WEST] = state;
    }

    public void setNeState(byte state) {
        this.neighborState[this.NORTHEAST] = state;
    }

    public void setEsState(byte state) {
        this.neighborState[this.SOUTHEAST] = state;
    }

    public void setSwState(byte state) {
        this.neighborState[this.SOUTHWEST] = state;
    }

    public void setWnState(byte state) {
        this.neighborState[this.NORTHWEST] = state;
    }

    public void setNeeState(byte state) {
        this.neighborState[this.NORTHEASTEAST] = state;
    }

    public void setEeState(byte state) {
        this.neighborState[this.SOUTHEASTEAST] = state;
    }

    public void setEesState(byte state) {
        this.neighborState[this.EASTEAST] = state;
    }

    public void setSswState(byte state) {
        this.neighborState[this.SOUTHSOUTHWEST] = state;
    }

    public void setSsState(byte state) {
        this.neighborState[this.SOUTHSOUTH] = state;
    }

    public void setEssState(byte state) {
        this.neighborState[this.SOUTHSOUTHEAST] = state;
    }

    public void setEessState(byte state) {
        this.neighborState[this.SOUTHSOUTHEASTEAST] = state;
    }

    @Override
    public int getMaxNeighbor() {
        return this.maxNeighbor;
    }

    private void clear() {
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            this.neighborState[i] = 0;
        }
    }

    public void relocateParticlesAtRandom() {
        int[] allMasses = this.getAllMasses();
        this.clear();
        for (int i = 1; i < allMasses.length; ++i) {
            this.putParticlesAtRandom(i, allMasses[i]);
        }
    }

    private void putParticlesAtRandom(int state, int mass) {
        int remain = mass;
        while (remain > 0) {
            int j = MyMath.irand(this.maxNeighbor);
            if (this.neighborState[j] != 0) continue;
            this.neighborState[j] = (byte)state;
            --remain;
        }
    }

    public int getXAxis() {
        return this.x;
    }

    public int getYAxis() {
        return this.y;
    }

    public int getMass() {
        int mass = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] == 0) continue;
            ++mass;
        }
        return mass;
    }

    public int getMass(int state) {
        int sum = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] != state) continue;
            ++sum;
        }
        return sum;
    }

    private int[] getAllMasses() {
        int maxState = this.getMaxState();
        int[] allMasses = new int[maxState];
        for (int i = 0; i < maxState; ++i) {
            allMasses[i] = this.getMass(i);
        }
        return allMasses;
    }

    private int getMaxState() {
        byte maxState = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] <= maxState) continue;
            maxState = this.neighborState[i];
        }
        return this.maxNeighbor;
    }

    public boolean equals(Partition ref) {
        if (ref.getMaxNeighbor() != this.maxNeighbor) {
            return false;
        }
        if (ref.getHomeState() != this.getHomeState()) {
            return false;
        }
        if (ref.getEastState() != this.getEastState()) {
            return false;
        }
        if (ref.getSouthState() != this.getSouthState()) {
            return false;
        }
        if (this.maxNeighbor == 4) {
            if (ref.getEsState() != this.getEsState()) {
                return false;
            }
        } else if (this.maxNeighbor == 5) {
            if (ref.getNorthState() != this.getNorthState()) {
                return false;
            }
            if (ref.getWestState() != this.getWestState()) {
                return false;
            }
        } else if (this.maxNeighbor == 9) {
            if (ref.getNorthState() != this.getNorthState()) {
                return false;
            }
            if (ref.getWestState() != this.getWestState()) {
                return false;
            }
            if (ref.getEsState() != this.getEsState()) {
                return false;
            }
            if (ref.getNeState() != this.getNeState()) {
                return false;
            }
            if (ref.getSwState() != this.getSwState()) {
                return false;
            }
            if (ref.getWnState() != this.getWnState()) {
                return false;
            }
        }
        return true;
    }

    public byte[][] getCAState() {
        if (this.maxNeighbor == 4) {
            byte[][] caState = new byte[2][2];
            caState[0][0] = this.getHomeState();
            caState[0][1] = this.getSouthState();
            caState[1][0] = this.getEastState();
            caState[1][1] = this.getEsState();
            return caState;
        }
        if (this.maxNeighbor == 9) {
            byte[][] caState = new byte[3][3];
            caState[0][0] = this.getWnState();
            caState[0][1] = this.getWestState();
            caState[0][2] = this.getSwState();
            caState[1][0] = this.getNorthState();
            caState[1][1] = this.getHomeState();
            caState[1][2] = this.getSouthState();
            caState[2][0] = this.getNeState();
            caState[2][1] = this.getEastState();
            caState[2][2] = this.getEsState();
            return caState;
        }
        if (this.maxNeighbor == 16) {
            byte[][] caState = new byte[4][4];
            caState[0][0] = this.getWnState();
            caState[0][1] = this.getWestState();
            caState[0][2] = this.getSwState();
            caState[0][3] = this.getSswState();
            caState[1][0] = this.getNorthState();
            caState[1][1] = this.getHomeState();
            caState[1][2] = this.getSouthState();
            caState[1][3] = this.getSsState();
            caState[2][0] = this.getNeState();
            caState[2][1] = this.getEastState();
            caState[2][2] = this.getEsState();
            caState[2][3] = this.getEssState();
            caState[3][0] = this.getNeeState();
            caState[3][1] = this.getEeState();
            caState[3][2] = this.getEesState();
            caState[3][3] = this.getEessState();
            return caState;
        }
        throw new IllegalArgumentException("Neighbor type does not match.");
    }
}

