/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CAConfig;
import cambria.CAPanel;
import cambria.CARunner;
import cambria.FrameLocation;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MiscDialog
extends JFrame
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private JButton adoptButton;
    private JPanel p1;
    private JPanel p2;
    private Choice speedChoice;
    private Choice borderChoice;
    private Choice synchroChoice;
    private CARunner caRunner;
    private CAPanel caPanel;
    private CAConfig caConfig;

    public MiscDialog(CARunner caRunner) {
        super("Controller");
        this.caRunner = caRunner;
        this.caPanel = caRunner.getCAPanel();
        this.caConfig = this.caPanel.getCAConfig();
        this.middle_section();
        this.bottom_row();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MiscDialog.this.setVisible(false);
            }
        });
        this.setLocation(FrameLocation.getPoint("center", this));
        this.pack();
    }

    private void middle_section() {
        this.p1 = new JPanel();
        this.speedChoice = new Choice();
        this.speedChoice.addItem("fast  ");
        this.speedChoice.addItem("medium");
        this.speedChoice.addItem("slow  ");
        this.speedChoice.select(0);
        this.speedChoice.addItemListener(this);
        this.p1.add(this.speedChoice);
        this.borderChoice = new Choice();
        this.borderChoice.addItem("torus ");
        this.borderChoice.addItem("closed");
        int borderInit = this.caConfig.isTorus() ? 0 : 1;
        this.borderChoice.select(borderInit);
        this.borderChoice.addItemListener(this);
        this.p1.add(this.borderChoice);
        this.synchroChoice = new Choice();
        this.synchroChoice.addItem("synchronous ");
        this.synchroChoice.addItem("asynchronous");
        int synchroInit = this.caConfig.isSynchronous() ? 0 : 1;
        this.synchroChoice.select(synchroInit);
        this.synchroChoice.addItemListener(this);
        this.p1.add(this.synchroChoice);
        this.add("Center", this.p1);
    }

    private void bottom_row() {
        this.p2 = new JPanel();
        this.p2.setLayout(new FlowLayout(2));
        this.adoptButton = new JButton("close");
        this.adoptButton.addActionListener(this);
        this.p2.add(this.adoptButton);
        this.add("South", this.p2);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.adoptButton) {
            this.setVisible(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void itemStateChanged(ItemEvent e) {
        String string = e.getItem().toString();
        if (this.speedChoice == e.getSource()) {
            if (string.startsWith("fast")) {
                this.caRunner.setDeltaTime(25);
                return;
            } else if (string.startsWith("medium")) {
                this.caRunner.setDeltaTime(100);
                return;
            } else {
                if (!string.startsWith("slow")) return;
                this.caRunner.setDeltaTime(500);
            }
            return;
        } else if (this.borderChoice == e.getSource()) {
            if (string.startsWith("torus")) {
                this.caConfig.setTorus(true);
                return;
            } else {
                if (!string.startsWith("closed")) throw new RuntimeException("Invalid item state");
                this.caConfig.setTorus(false);
            }
            return;
        } else {
            if (this.synchroChoice != e.getSource()) return;
            if (string.startsWith("synchro")) {
                this.caConfig.setSynchronous(true);
                return;
            } else {
                if (!string.startsWith("asynchro")) throw new RuntimeException("Invalid item state");
                this.caConfig.setSynchronous(false);
            }
        }
    }
}

