/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.misc.MyMath;

public class Margolus
extends BlockOfCells {
    private static final int HOME = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int SOUTHEAST = 3;
    private static final int maxNeighbor = 4;
    private byte[] neighborState = new byte[4];
    private int x;
    private int y;
    private boolean torus = true;
    private int x_max;
    private int y_max;

    public Margolus() {
    }

    public Margolus(boolean torus, int x_max, int y_max) {
        this.torus = torus;
        this.x_max = x_max;
        this.y_max = y_max;
    }

    public Margolus(int x_max, int y_max) {
        this.x_max = x_max;
        this.y_max = y_max;
    }

    public Margolus(Margolus partition) {
        this.neighborState[0] = partition.getHomeState();
        this.neighborState[1] = partition.getEastState();
        this.neighborState[2] = partition.getSouthState();
        this.neighborState[3] = partition.getEsState();
        this.torus = partition.isTorus();
    }

    @Override
    public void make(byte[][] caState, int x, int y) {
        this.x = x;
        this.y = y;
        if (this.torus) {
            int east = (x + 1) % this.x_max;
            int south = (y + 1) % this.y_max;
            this.neighborState[0] = caState[x][y];
            this.neighborState[1] = caState[east][y];
            this.neighborState[2] = caState[x][south];
            this.neighborState[3] = caState[east][south];
        } else {
            int east = x + 1;
            int south = y + 1;
            this.setHomeState(caState[x][y]);
            try {
                this.setEastState(caState[east][y]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEastState((byte)0);
            }
            try {
                this.setSouthState(caState[x][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setSouthState((byte)0);
            }
            try {
                this.setEsState(caState[east][south]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setEsState((byte)0);
            }
        }
    }

    @Override
    public void setTorus(boolean torus) {
        this.torus = torus;
    }

    @Override
    public boolean isTorus() {
        return this.torus;
    }

    @Override
    public void updateCAState(byte[][] caState, int x, int y) {
        int east = (x + 1) % this.x_max;
        int south = (y + 1) % this.y_max;
        caState[x][y] = this.neighborState[0];
        caState[east][y] = this.neighborState[1];
        caState[x][south] = this.neighborState[2];
        caState[east][south] = this.neighborState[3];
    }

    @Override
    public byte[] getNeighborState() {
        return this.neighborState;
    }

    public byte getHomeState() {
        return this.neighborState[0];
    }

    public byte getEastState() {
        return this.neighborState[1];
    }

    public byte getSouthState() {
        return this.neighborState[2];
    }

    public byte getEsState() {
        return this.neighborState[3];
    }

    @Override
    public void setNeighborState(byte[] neighborState) {
        if (neighborState.length != 4) {
            throw new IllegalArgumentException("Neighbor type does not match.");
        }
        for (int i = 0; i < 4; ++i) {
            this.neighborState[i] = neighborState[i];
        }
    }

    public void setHomeState(byte state) {
        this.neighborState[0] = state;
    }

    public void setEastState(byte state) {
        this.neighborState[1] = state;
    }

    public void setSouthState(byte state) {
        this.neighborState[2] = state;
    }

    public void setEsState(byte state) {
        this.neighborState[3] = state;
    }

    @Override
    public int getMaxNeighbor() {
        return 4;
    }

    private void clear() {
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            this.neighborState[i] = 0;
        }
    }

    public void relocateParticlesAtRandom() {
        int[] allMasses = this.getAllMasses();
        this.clear();
        for (int i = 1; i < allMasses.length; ++i) {
            this.putParticlesAtRandom(i, allMasses[i]);
        }
    }

    private void putParticlesAtRandom(int state, int mass) {
        int remain = mass;
        while (remain > 0) {
            int j = MyMath.irand(4);
            if (this.neighborState[j] != 0) continue;
            this.neighborState[j] = (byte)state;
            --remain;
        }
    }

    public int getXAxis() {
        return this.x;
    }

    public int getYAxis() {
        return this.y;
    }

    public int getMass() {
        int mass = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.neighborState[i] == 0) continue;
            ++mass;
        }
        return mass;
    }

    public int getMass(int state) {
        int sum = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] != state) continue;
            ++sum;
        }
        return sum;
    }

    private int[] getAllMasses() {
        int maxState = this.getMaxState();
        int[] allMasses = new int[maxState];
        for (int i = 0; i < maxState; ++i) {
            allMasses[i] = this.getMass(i);
        }
        return allMasses;
    }

    private int getMaxState() {
        byte maxState = 0;
        for (int i = 0; i < this.getMaxNeighbor(); ++i) {
            if (this.neighborState[i] <= maxState) continue;
            maxState = this.neighborState[i];
        }
        return 4;
    }

    public boolean equals(Margolus ref) {
        if (ref.getHomeState() != this.neighborState[0]) {
            return false;
        }
        if (ref.getEastState() != this.neighborState[1]) {
            return false;
        }
        if (ref.getSouthState() != this.neighborState[2]) {
            return false;
        }
        return ref.getEsState() == this.neighborState[3];
    }
}

