/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CAConfig;
import cambria.CAPanel;
import cambria.FrameLocation;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InitDialog
extends JFrame
implements ActionListener,
ItemListener,
AdjustmentListener {
    private static final long serialVersionUID = 1L;
    private int initNo;
    private String[] InitTypeArray;
    private CAPanel cap;
    private CAConfig caConfig;
    private JPanel mainPanel;
    private JPanel subPanel;
    private Choice initChoice;
    private JButton closeButton;
    private Scrollbar densitySlider;
    private JTextField textField;

    public InitDialog(CAPanel cap) {
        this.cap = cap;
        this.caConfig = cap.getCAConfig();
        this.InitTypeArray = CAConfig.getInitTypeArray();
        this.setupGUI();
    }

    private void setupGUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(0, 2));
        this.mainPanel.add(new Label("patterns"));
        this.initChoice = new Choice();
        this.mainPanel.add(this.initChoice);
        for (int i = 0; i < this.InitTypeArray.length; ++i) {
            this.initChoice.addItem(this.InitTypeArray[i]);
        }
        this.initChoice.select(this.initNo);
        this.initChoice.addItemListener(this);
        this.mainPanel.add(new Label("density for random"));
        double density = this.caConfig.getDensity();
        this.densitySlider = new Scrollbar(0, (int)(density * 100.0), 30, 0, 130);
        this.densitySlider.addAdjustmentListener(this);
        this.mainPanel.add(this.densitySlider);
        this.textField = new JTextField(Float.toString((float)density), 10);
        this.textField.setEditable(false);
        this.mainPanel.add(this.textField);
        this.add("Center", this.mainPanel);
        this.subPanel = new JPanel();
        this.closeButton = new JButton("close");
        this.subPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.add("South", this.subPanel);
        this.pack();
        this.setLocation(FrameLocation.getPoint("center", this));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.closeButton) {
            this.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (this.initChoice == source) {
            this.caConfig.setInit(e.getItem().toString());
            this.cap.repaint();
        } else {
            System.out.println(this.toString() + ": No such choice object");
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        double density = (double)e.getValue() / 100.0;
        this.textField.setText(String.valueOf((float)density));
        this.caConfig.randomize(density);
        this.cap.repaint();
    }
}

