/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.BlockOfCells;
import cambria.CARule;
import cambria.Moore;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GenerationRule
extends CARule
implements ItemListener {
    private static final long serialVersionUID = 1L;
    public int statePerCell = 5;
    private Choice spcChoice;
    public static final int maxNeighbor = 9;
    public static final String[] presetRule = new String[]{"starwars  ", "life      ", "dayNight  ", "transers  ", "brain     ", "dizzy     ", "wanderers ", "sedimental"};
    private int spc = 4;
    boolean[] born = new boolean[]{false, false, true, false, false, false, false, false, false};
    boolean[] survive = new boolean[]{false, false, false, true, true, true, false, false, false};
    private static final boolean[] lifeBorn = new boolean[]{false, false, false, true, false, false, false, false, false};
    private static final boolean[] lifeSurvive = new boolean[]{false, false, true, true, false, false, false, false, false};
    private static final int lifeSpc = 2;
    private static final boolean[] dayNightBorn = new boolean[]{false, false, false, true, false, false, true, true, true};
    private static final boolean[] dayNightSurvive = new boolean[]{false, false, false, true, false, true, true, true, true};
    private static final int dayNightSpc = 2;
    private static final boolean[] brainBorn = new boolean[]{false, false, true, false, false, false, false, false, false};
    private static final boolean[] brainSurvive = new boolean[]{false, false, false, false, false, false, false, false, false};
    private static final int brainSpc = 3;
    private static final boolean[] starWarsBorn = new boolean[]{false, false, true, false, false, false, false, false, false};
    private static final boolean[] starWarsSurvive = new boolean[]{false, false, false, true, true, true, false, false, false};
    private static final int starWarsSpc = 4;
    private static final boolean[] dizzyBorn = new boolean[]{false, false, true, true, false, false, false, false, false};
    private static final boolean[] dizzySurvive = new boolean[]{false, false, false, false, false, false, false, false, false};
    private static final int dizzySpc = 4;
    private static final boolean[] sedimentalBorn = new boolean[]{false, false, true, false, false, true, true, true, true};
    private static final boolean[] sedimentalSurvive = new boolean[]{false, false, false, false, true, true, true, true, true};
    private static final int sedimentalSpc = 4;
    private static final boolean[] transersBorn = new boolean[]{false, false, true, false, false, false, true, false, false};
    private static final boolean[] transersSurvive = new boolean[]{false, false, false, true, true, true, false, false, false};
    private static final int transersSpc = 5;
    private static final boolean[] wanderersSurvive = new boolean[]{false, false, false, true, true, true, false, false, false};
    private static final boolean[] wanderersBorn = new boolean[]{false, false, false, true, true, false, true, true, true};
    private static final int wanderersSpc = 5;
    Checkbox[] bornCB = new Checkbox[]{new Checkbox("total 0", this.born[0]), new Checkbox("total 1", this.born[1]), new Checkbox("total 2", this.born[2]), new Checkbox("total 3", this.born[3]), new Checkbox("total 4", this.born[4]), new Checkbox("total 5", this.born[5]), new Checkbox("total 6", this.born[6]), new Checkbox("total 7", this.born[7]), new Checkbox("total 8", this.born[8])};
    Checkbox[] surviveCB = new Checkbox[]{new Checkbox("total 0", this.survive[0]), new Checkbox("total 1", this.survive[1]), new Checkbox("total 2", this.survive[2]), new Checkbox("total 3", this.survive[3]), new Checkbox("total 4", this.survive[4]), new Checkbox("total 5", this.survive[5]), new Checkbox("total 6", this.survive[6]), new Checkbox("total 7", this.survive[7]), new Checkbox("total 8", this.survive[8])};
    JButton adoptButton;
    JButton cancelButton;
    JLabel bLabel;
    JLabel sLabel;
    JTextField stateText;

    @Override
    public void setRule(String ruleString, String filename) {
        if (ruleString != null) {
            this.changePreset(ruleString);
        }
    }

    @Override
    public int output(BlockOfCells boc) {
        Moore neighbor = (Moore)boc;
        neighbor.setNorthState((byte)(neighbor.getNorthState() % this.spc));
        neighbor.setNeState((byte)(neighbor.getNeState() % this.spc));
        neighbor.setEastState((byte)(neighbor.getEastState() % this.spc));
        neighbor.setEsState((byte)(neighbor.getEsState() % this.spc));
        neighbor.setSouthState((byte)(neighbor.getSouthState() % this.spc));
        neighbor.setSwState((byte)(neighbor.getSwState() % this.spc));
        neighbor.setWestState((byte)(neighbor.getWestState() % this.spc));
        neighbor.setWnState((byte)(neighbor.getWnState() % this.spc));
        int total = neighbor.getNorthState() / (this.spc - 1) + neighbor.getNeState() / (this.spc - 1) + neighbor.getEastState() / (this.spc - 1) + neighbor.getEsState() / (this.spc - 1) + neighbor.getSouthState() / (this.spc - 1) + neighbor.getSwState() / (this.spc - 1) + neighbor.getWestState() / (this.spc - 1) + neighbor.getWnState() / (this.spc - 1);
        if (neighbor.getHomeState() == 0) {
            return this.born[total] ? this.spc - 1 : 0;
        }
        if (neighbor.getHomeState() == this.spc - 1) {
            return this.survive[total] ? neighbor.getHomeState() : neighbor.getHomeState() - 1;
        }
        return neighbor.getHomeState() - 1;
    }

    @Override
    public int getStatePerCell() {
        return this.statePerCell;
    }

    @Override
    public int getMaxNeighbor() {
        return 9;
    }

    @Override
    public void edit() {
        if (this.mainPanel == null) {
            int i;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridLayout(0, 10));
            this.sLabel = new JLabel("survive");
            this.mainPanel.add(this.sLabel);
            for (i = 0; i < 9; ++i) {
                this.mainPanel.add(this.surviveCB[i]);
            }
            this.bLabel = new JLabel("born");
            this.mainPanel.add(this.bLabel);
            for (i = 0; i < 9; ++i) {
                this.mainPanel.add(this.bornCB[i]);
            }
            this.add("Center", this.mainPanel);
            Label stateLabel = new Label("states");
            this.mainPanel.add(stateLabel);
            this.spcChoice = new Choice();
            for (int i2 = 2; i2 < this.statePerCell + 1; ++i2) {
                this.spcChoice.addItem(Integer.toString(i2));
            }
            this.spcChoice.select(this.spc - 2);
            this.mainPanel.add(this.spcChoice);
            Label presetLabel = new Label("rules");
            this.mainPanel.add(presetLabel);
            Choice ruleChoice = new Choice();
            for (int i3 = 0; i3 < presetRule.length; ++i3) {
                ruleChoice.addItem(presetRule[i3]);
            }
            ruleChoice.addItemListener(this);
            this.mainPanel.add(ruleChoice);
            this.subPanel = new JPanel();
            this.adoptButton = new JButton("adopt");
            this.cancelButton = new JButton("cancel");
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.addActionListener(this);
            this.subPanel.add(this.cancelButton);
            this.adoptButton.setActionCommand("adopt");
            this.adoptButton.addActionListener(this);
            this.subPanel.add(this.adoptButton);
            this.add("South", this.subPanel);
            this.pack();
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        String command = evt.getActionCommand();
        if (command.equals("cancel")) {
            for (int i = 0; i < 9; ++i) {
                this.bornCB[i].setState(this.born[i]);
                this.surviveCB[i].setState(this.survive[i]);
            }
            this.setVisible(false);
        } else if (command.equals("adopt")) {
            for (int i = 0; i < 9; ++i) {
                this.born[i] = this.bornCB[i].getState();
                this.survive[i] = this.surviveCB[i].getState();
            }
            try {
                this.spc = Integer.parseInt(this.spcChoice.getSelectedItem());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String selected = e.getItem().toString();
        this.changePreset(selected.trim());
        this.setRuleGUI();
    }

    private void changePreset(String selected) {
        if (selected.regionMatches(true, 0, "life", 0, 4)) {
            this.born = lifeBorn;
            this.survive = lifeSurvive;
            this.spc = 2;
        } else if (selected.regionMatches(true, 0, "dayNight", 0, 8)) {
            this.born = dayNightBorn;
            this.survive = dayNightSurvive;
            this.spc = 2;
        } else if (selected.regionMatches(true, 0, "brain", 0, 5)) {
            this.born = brainBorn;
            this.survive = brainSurvive;
            this.spc = 3;
        } else if (selected.regionMatches(true, 0, "starwars", 0, 8)) {
            this.born = starWarsBorn;
            this.survive = starWarsSurvive;
            this.spc = 4;
        } else if (selected.regionMatches(true, 0, "transers", 0, 8)) {
            this.born = transersBorn;
            this.survive = transersSurvive;
            this.spc = 5;
        } else if (selected.regionMatches(true, 0, "dizzy", 0, 5)) {
            this.born = dizzyBorn;
            this.survive = dizzySurvive;
            this.spc = 4;
        } else if (selected.regionMatches(true, 0, "wanderers", 0, 9)) {
            this.born = wanderersBorn;
            this.survive = wanderersSurvive;
            this.spc = 5;
        } else if (selected.regionMatches(true, 0, "sedimental", 0, 10)) {
            this.born = sedimentalBorn;
            this.survive = sedimentalSurvive;
            this.spc = 4;
        } else {
            throw new RuntimeException("No such rule defined : " + selected);
        }
    }

    private void setRuleGUI() {
        int i;
        for (i = 0; i < this.bornCB.length; ++i) {
            this.bornCB[i].setState(this.born[i]);
        }
        for (i = 0; i < this.surviveCB.length; ++i) {
            this.surviveCB[i].setState(this.survive[i]);
        }
        this.spcChoice.select(this.spc - 2);
    }
}

