/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.misc.MyFile;
import cambria.misc.MyString;

public class FileNameArrange {
    String stemName;
    String extension;
    static final int numberOfDigits = 3;
    int startNumber;
    int endNumber;

    public static void main(String[] args) {
        FileNameArrange fileNameArrange = new FileNameArrange();
        fileNameArrange.setStemName(args[0]);
        fileNameArrange.setNumberOfDigits(MyString.convertIntParameter(args[1]));
        fileNameArrange.setExtension(args[2]);
        fileNameArrange.setRange(MyString.convertIntParameter(args[3]), MyString.convertIntParameter(args[4]));
        fileNameArrange.run();
    }

    public void run() {
        String nextFileName = MyFile.getNextFileName(this.stemName, this.extension);
        for (int i = this.startNumber; i < this.endNumber + 1; ++i) {
            System.out.println(i);
            StringBuffer myFileName = new StringBuffer();
            myFileName.append(this.stemName).append(MyString.getDigits(i, 3)).append('.').append(this.extension);
            if (nextFileName.compareTo(myFileName.toString()) >= 0) continue;
            MyFile myFile = new MyFile(myFileName.toString());
            myFile.appendNumberedFile(this.stemName, this.extension);
        }
    }

    private void setStemName(String stemName) {
        this.stemName = stemName;
    }

    private void setNumberOfDigits(int numberOfDigits) {
        if (numberOfDigits != 3) {
            throw new IllegalArgumentException("Only 3 digits.");
        }
    }

    private void setExtension(String extension) {
        this.extension = extension;
    }

    private void setRange(int startNumber, int endNumber) {
        if (startNumber > 999 || startNumber < 1) {
            throw new IllegalArgumentException("Invalid startNumber");
        }
        if (endNumber > 999 || endNumber < 1) {
            throw new IllegalArgumentException("Invalid endNumber");
        }
        if (endNumber < startNumber) {
            throw new IllegalArgumentException("endNumber is less than startNumber");
        }
        this.startNumber = startNumber;
        this.endNumber = endNumber;
    }
}

