/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CABatch;
import cambria.CAConfig;
import cambria.CAGraphics;
import cambria.CARule;
import cambria.CASearch;
import cambria.CanonicalRule;
import cambria.CheckRule;
import cambria.Demon;
import cambria.InteractingEnergy;
import cambria.RuleSwitcher;
import cambria.misc.MyFileReader;
import cambria.misc.MyString;

public class Cambria {
    private CAConfig caConfig;
    private CARule rule;
    private String[] args;
    private String parameterString;
    private String X_MAX;
    private String Y_MAX;
    private String T_MAX;
    private String DeltaTime;
    private String CellSize;
    private String RuleClass = null;
    private String RuleString;
    private String RuleFile;
    private String InitType = null;
    private String InitFile = null;
    private String ThreadName = null;
    private String Torus = null;
    private String UserMode = "GUI";
    private String BatchNumber;
    private String RunNumber;
    private String PopulationSize = null;
    private String EliteSize = null;
    private String GoalOfHs = null;
    private String MutationRate = null;
    private String CrossoverRate = null;
    private String MaxIter = null;
    private int timeSpan = 0;
    private String dataFilename = null;

    public static void main(String[] args) {
        Cambria cambria = new Cambria();
        cambria.readParameters(args);
        cambria.setNonGraphicItems();
        String UserMode = cambria.getUserModeString();
        if (UserMode == null) {
            UserMode = "GUI";
        }
        if (UserMode.regionMatches(true, 0, "Batch", 0, 5)) {
            int batchNumber = cambria.getBatchNumber();
            String runNumber = cambria.getRunNumber();
            int t_max = cambria.getTMax();
            CAConfig caConfig = cambria.getCAConfig();
            CABatch.executeBatchJob(caConfig, batchNumber, runNumber, t_max);
        } else if (UserMode.regionMatches(true, 0, "GUI", 0, 3) || UserMode.regionMatches(true, 0, "Demo", 0, 4)) {
            int cellSize = cambria.getCellSize();
            int deltaTime = cambria.getDeltaTime();
            CAConfig caConfig = cambria.getCAConfig();
            CAGraphics cAGraphics = new CAGraphics(caConfig, cellSize, deltaTime, UserMode);
        } else if (UserMode.regionMatches(true, 0, "Search", 0, 6)) {
            int populationSize = cambria.getPopulationSize();
            int eliteSize = cambria.getEliteSize();
            double mutationRate = cambria.getMutationRate();
            double crossoverRate = cambria.getCrossoverRate();
            int maxIter = cambria.getMaxIter();
            double goalOfHs = cambria.getGoalOfHs();
            String runNumber = cambria.getRunNumber();
            CAConfig caConfig = cambria.getCAConfig();
            CASearch caSearch = new CASearch(caConfig, populationSize, eliteSize, mutationRate, crossoverRate, maxIter, goalOfHs, runNumber);
            caSearch.start();
        } else {
            throw new RuntimeException("Invalid parameter of UserMode");
        }
    }

    public CAConfig getCAConfig() {
        return this.caConfig;
    }

    private void setNonGraphicItems() {
        int y_max;
        int x_max;
        this.rule = CARule.createRule(this.RuleClass);
        if (!(this.rule instanceof RuleSwitcher)) {
            this.rule.setRule(this.RuleString, this.RuleFile);
        } else {
            int statePerCell = 2;
            int maxRuleSelection = 2;
            ((RuleSwitcher)((Object)this.rule)).initializeRuleArray(statePerCell, maxRuleSelection);
            this.rule.setRule(this.RuleString, this.RuleFile);
        }
        boolean torus = Cambria.getTorus(this.Torus);
        if (this.ThreadName == null) {
            this.ThreadName = this.rule.getDefaultThread();
        }
        if (this.InitFile != null) {
            if (this.X_MAX != null || this.Y_MAX != null || this.InitType != null) {
                System.out.println("Warning: Some parameters are interfared. ");
            }
            this.caConfig = new CAConfig(this.rule, torus, this.isSynchronous(this.ThreadName), this.InitFile);
            x_max = this.caConfig.getXMax();
            y_max = this.caConfig.getYMax();
        } else {
            x_max = Cambria.convertIntParameter(this.X_MAX, 100);
            y_max = Cambria.convertIntParameter(this.Y_MAX, 100);
            this.caConfig = new CAConfig(this.rule, torus, this.InitType, this.isSynchronous(this.ThreadName), x_max, y_max);
        }
        if (this.rule instanceof InteractingEnergy) {
            if (this.rule instanceof CanonicalRule || this.rule instanceof CheckRule) {
                Demon demon = new Demon(x_max, y_max, 0, 1, 5);
                ((InteractingEnergy)((Object)this.rule)).setDemon(demon);
            } else {
                Demon demon = new Demon(x_max, y_max);
                ((InteractingEnergy)((Object)this.rule)).setDemon(demon);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getTorus(String Torus) {
        if (Torus == null) return true;
        if (Torus.equals("false")) return false;
        if (Torus.equals("False")) {
            return false;
        }
        if (Torus.equals("true")) return true;
        if (!Torus.equals("True")) throw new IllegalArgumentException("Invalid torus argument");
        return true;
    }

    private void readParameters(String[] args) {
        StringBuffer strbuff = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            strbuff.append(args[i]);
            strbuff.append(" ");
        }
        strbuff.append(MyFileReader.file2string("Cambria.init", '%'));
        this.parameterString = strbuff.toString();
        this.T_MAX = Cambria.getParameter(this.parameterString, "t_max");
        this.X_MAX = Cambria.getParameter(this.parameterString, "x_max");
        this.Y_MAX = Cambria.getParameter(this.parameterString, "y_max");
        this.DeltaTime = Cambria.getParameter(this.parameterString, "deltaTime");
        this.CellSize = Cambria.getParameter(this.parameterString, "cellSize");
        this.RuleClass = Cambria.getParameter(this.parameterString, "ruleClass");
        this.RuleString = Cambria.getParameter(this.parameterString, "ruleString");
        this.RuleFile = Cambria.getParameter(this.parameterString, "ruleFile");
        this.ThreadName = Cambria.getParameter(this.parameterString, "threadName");
        this.InitType = Cambria.getParameter(this.parameterString, "initType");
        this.InitFile = Cambria.getParameter(this.parameterString, "initFile");
        this.Torus = Cambria.getParameter(this.parameterString, "torus");
        this.UserMode = Cambria.getParameter(this.parameterString, "userMode");
        this.BatchNumber = Cambria.getParameter(this.parameterString, "batchNumber");
        this.RunNumber = Cambria.getParameter(this.parameterString, "runNumber");
        this.PopulationSize = Cambria.getParameter(this.parameterString, "populationSize");
        this.EliteSize = Cambria.getParameter(this.parameterString, "eliteSize");
        this.GoalOfHs = Cambria.getParameter(this.parameterString, "goalOfHs");
        this.MutationRate = Cambria.getParameter(this.parameterString, "mutationRate");
        this.CrossoverRate = Cambria.getParameter(this.parameterString, "crossoverRate");
        this.MaxIter = Cambria.getParameter(this.parameterString, "maxIter");
    }

    public String getUserModeString() {
        return this.UserMode;
    }

    private boolean isSynchronous(String ThreadName) {
        if (ThreadName == null) {
            return true;
        }
        if (ThreadName.regionMatches(true, 0, "MCSThread", 0, 9)) {
            return false;
        }
        if (ThreadName.regionMatches(true, 0, "CAThread", 0, 8)) {
            return true;
        }
        throw new IllegalArgumentException("No such parameter.");
    }

    public static String getParameter(String parameterString, String parameter) {
        int index = Cambria.indexParameter(parameterString, parameter);
        if (index < 0) {
            return null;
        }
        return MyString.stripBack(MyString.lindex(parameterString, index), '=');
    }

    public static int indexParameter(String parameterString, String parameter) {
        int len = parameter.length();
        int i = 0;
        while (MyString.lindex(parameterString, i) != null) {
            if (parameter.regionMatches(true, 0, MyString.lindex(parameterString, i), 0, len)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getDeltaTime() {
        return Cambria.convertIntParameter(this.DeltaTime, 25);
    }

    public int getCellSize() {
        return Cambria.convertIntParameter(this.CellSize, 3);
    }

    public int getTMax() {
        return Cambria.convertIntParameter(this.T_MAX, 200);
    }

    public int getBatchNumber() {
        return Cambria.convertIntParameter(this.BatchNumber, 1);
    }

    public String getRunNumber() {
        return this.RunNumber;
    }

    public int getPopulationSize() {
        return Cambria.convertIntParameter(this.PopulationSize, 20);
    }

    public int getEliteSize() {
        return Cambria.convertIntParameter(this.EliteSize, 20);
    }

    public double getMutationRate() {
        return Cambria.convertDoubleParameter(this.MutationRate, 0.005);
    }

    public double getCrossoverRate() {
        return Cambria.convertDoubleParameter(this.CrossoverRate, 0.005);
    }

    public int getMaxIter() {
        return Cambria.convertIntParameter(this.MaxIter, 1000);
    }

    public double getGoalOfHs() {
        return Cambria.convertDoubleParameter(this.GoalOfHs, 0.6);
    }

    public static int convertIntParameter(String string, int defaultValue) {
        int intParameter = 0;
        if (string != null) {
            try {
                intParameter = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                intParameter = defaultValue;
                System.out.print("'" + string + "' is not an integer. ");
                System.out.println("Check input parameters.");
            }
        } else {
            intParameter = defaultValue;
        }
        return intParameter;
    }

    public static double convertDoubleParameter(String string, double defaultValue) {
        double doubleParameter = 0.0;
        if (string != null) {
            try {
                doubleParameter = new Double(string);
            }
            catch (NumberFormatException e) {
                System.out.print("'" + string + "' is not a double. ");
                System.out.println("Check input parameters.");
                doubleParameter = defaultValue;
            }
        } else {
            doubleParameter = defaultValue;
        }
        return doubleParameter;
    }
}

