/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CAConfig;
import cambria.PictureDialog;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class CAPanel
extends JPanel
implements MouseListener {
    private MemoryImageSource mis;
    private int[] pixel;
    private Image image;
    private PictureDialog pictureDialog;
    private CAConfig caConfig;
    private int x_max;
    private int y_max;
    private Color[] stateColor;
    private int cellSize = 3;

    public CAPanel(CAConfig caConfig, Color[] stateColor, int cellSize) {
        if (caConfig == null) {
            throw new IllegalArgumentException("caConfig is null");
        }
        this.caConfig = caConfig;
        this.x_max = caConfig.getXMax();
        this.y_max = caConfig.getYMax();
        if (stateColor == null) {
            throw new IllegalArgumentException("null color set given");
        }
        if (cellSize < 1) {
            throw new IllegalArgumentException("nil or negative cellSize");
        }
        this.setSize(cellSize);
        int statePerCell = caConfig.getStatePerCell();
        this.stateColor = new Color[statePerCell];
        for (int i = 0; i < statePerCell; ++i) {
            this.stateColor[i] = Color.black;
        }
        this.setColor(stateColor);
        this.addMouseListener(this);
    }

    public void setColor(Color[] stateColor) {
        if (stateColor != null) {
            for (int i = 0; i < stateColor.length; ++i) {
                this.stateColor[i] = stateColor[i];
            }
        } else {
            System.out.println("CAPicture: Warning: null color set given. Default color sets used.");
            this.stateColor[1] = Color.white;
            this.stateColor[2] = Color.red;
        }
    }

    public Color[] getStateColor() {
        return this.stateColor;
    }

    public Color getStateColor(int i) {
        if (i >= this.stateColor.length) {
            throw new IllegalArgumentException("Invalid state");
        }
        return this.stateColor[i];
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void setSize(int size) {
        this.cellSize = size;
        this.pixel = new int[this.x_max * this.y_max * this.cellSize * this.cellSize];
        this.mis = new MemoryImageSource(this.x_max * this.cellSize, this.y_max * this.cellSize, this.pixel, 0, this.x_max * this.cellSize);
        this.mis.setAnimated(true);
        this.image = this.createImage(this.mis);
    }

    public void setSize() {
        if (this.pictureDialog != null) {
            this.cellSize = this.pictureDialog.cellSize;
        }
        this.pixel = new int[this.x_max * this.y_max * this.cellSize * this.cellSize];
        this.mis = new MemoryImageSource(this.x_max * this.cellSize, this.y_max * this.cellSize, this.pixel, 0, this.x_max * this.cellSize);
        this.mis.setAnimated(true);
        this.image = this.createImage(this.mis);
    }

    public CAConfig getCAConfig() {
        return this.caConfig;
    }

    @Override
    public synchronized void paint(Graphics g) {
        for (int j = 0; j < this.cellSize; ++j) {
            int count = this.x_max * this.cellSize * j;
            for (int y = 0; y < this.y_max; ++y) {
                for (int x = 0; x < this.x_max; ++x) {
                    byte state = this.caConfig.getCAState(x, y);
                    for (int i = 0; i < this.cellSize; ++i) {
                        this.pixel[count++] = this.stateColor[state].getRGB();
                    }
                }
                count += this.x_max * this.cellSize * (this.cellSize - 1);
            }
        }
        this.mis.newPixels();
        g.drawImage(this.image, 0, 0, null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i = e.getX() / this.cellSize;
        int j = e.getY() / this.cellSize;
        if (i > this.x_max - 1 || j > this.y_max - 1) {
            return;
        }
        if (e.isAltDown()) {
            boolean torus = this.caConfig.isTorus();
            byte state = this.caConfig.getCAState(i, j);
            this.pictureDialog = new PictureDialog(this.stateColor, state, torus, this.cellSize);
            this.caConfig.setTorus(torus);
        } else {
            byte state = this.caConfig.getCAState(i, j);
            if (state == (byte)(this.caConfig.getStatePerCell() - 1)) {
                this.caConfig.setCAState(0, i, j);
            } else {
                this.caConfig.setCAState(state + 1, i, j);
            }
            this.repaint();
        }
    }
}

