/*
 * Decompiled with CFR 0.152.
 */
package cambria;

import cambria.CABatch;
import cambria.CAConfig;
import cambria.CAPanel;
import cambria.CARule;
import cambria.CARunner;
import cambria.ColorSet;
import cambria.EntroS;
import cambria.InitDialog;
import cambria.MiscDialog;
import cambria.RawData;
import cambria.TimeSeriesHelp;
import cambria.mmi.JpegEncoder;
import cambria.mmi.Plotter;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CAGraphics
implements ActionListener,
ItemListener {
    private CAConfig caConfig;
    private CARule rule;
    private String UserInterface;
    private CARunner caRunner;
    private int deltaTime;
    private MiscDialog miscDialog;
    private InitDialog initDialog;
    private CAPanel cap;
    private int cellSize;
    private Plotter pxy;
    private EntroS entroS;
    private JButton initButton;
    private JButton startButton;
    private JButton nextButton;
    private JButton ruleButton;
    private JButton miscButton;
    private JPanel runTimePanel;
    private JButton quitButton;
    private JButton jpegButton;
    private Choice entChoice;
    private JPanel gPanel;
    private JFrame mainFrame;
    private static final int gPanelX = 600;
    private static final int gPanelY = 400;
    private int x_max;
    private int y_max;

    public CAGraphics(CAConfig caConfig, int cellSize, int deltaTime, String UserInterface) {
        this.caConfig = caConfig;
        this.rule = caConfig.getCARule();
        this.cellSize = cellSize;
        this.deltaTime = deltaTime;
        this.UserInterface = UserInterface;
        this.createGUI();
    }

    private void createGUI() {
        this.mainFrame = new JFrame("Cambria");
        this.mainFrame.setLayout(new BorderLayout());
        this.mainFrame.setDefaultCloseOperation(2);
        Font font = new Font("Times", 1, 14);
        this.runTimePanel = new JPanel();
        this.startButton = new JButton("start");
        this.runTimePanel.add(this.startButton);
        this.startButton.addActionListener(this);
        this.nextButton = new JButton("step");
        this.runTimePanel.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.initButton = new JButton("initialize");
        this.runTimePanel.add(this.initButton);
        this.initButton.addActionListener(this);
        this.miscButton = new JButton("Misc.");
        this.runTimePanel.add(this.miscButton);
        this.miscButton.addActionListener(this);
        this.cap = new CAPanel(this.caConfig, ColorSet.createColorSet(this.rule), this.cellSize);
        this.mainFrame.add("Center", this.cap);
        this.cap.repaint();
        this.caRunner = new CARunner(this.deltaTime, this.cap);
        if (this.UserInterface.regionMatches(true, 0, "GUI", 0, 3)) {
            this.gPanel = new JPanel();
            this.gPanel.setLayout(new BorderLayout());
            this.gPanel.setMinimumSize(new Dimension(600, 400));
            this.pxy = new Plotter("Data Analysis Pane", this.gPanel);
            this.pxy.setFont("time", 11);
            this.gPanel.add((Component)this.pxy, "Center");
            this.gPanel.setVisible(true);
            this.mainFrame.add((Component)this.gPanel, "North");
        }
        this.createRuleButton();
        this.jpegButton = new JButton("JPEG");
        this.jpegButton.setActionCommand("JPEG");
        this.jpegButton.addActionListener(this);
        this.runTimePanel.add(this.jpegButton);
        if (this.UserInterface.regionMatches(true, 0, "GUI", 0, 3)) {
            this.entChoice = new Choice();
            this.entChoice.addItem("Time-series   ");
            this.entChoice.addItem("Hs and Hc  128");
            this.entChoice.addItem("Hs and Hc 1024");
            this.entChoice.addItem("Hs and Hc 4096");
            this.entChoice.addItem("Hc  -  Hs  128");
            this.entChoice.addItem("Hc  -  Hs 1024");
            this.entChoice.addItem("Hc  -  Hs 4096");
            this.entChoice.addItem("demograph  128");
            this.entChoice.addItem("demograph 1024");
            this.entChoice.addItem("demograph 4096");
            this.entChoice.addItem("help info     ");
            this.entChoice.select(0);
            this.entChoice.addItemListener(this);
            this.runTimePanel.add(this.entChoice);
        }
        this.quitButton = new JButton("quit");
        this.runTimePanel.add(this.quitButton);
        this.quitButton.addActionListener(this);
        int w = this.runTimePanel.getSize().width;
        this.mainFrame.add("South", this.runTimePanel);
        if (this.UserInterface.regionMatches(true, 0, "GUI", 0, 3)) {
            this.mainFrame.setSize(600 + this.cellSize * this.caConfig.getXMax(), this.cellSize * this.caConfig.getYMax() + 60);
        } else if (this.UserInterface.regionMatches(true, 0, "Demo", 0, 4)) {
            int xGSize = Math.max(this.cellSize * this.caConfig.getXMax(), 400);
            this.mainFrame.setSize(xGSize, this.cellSize * this.caConfig.getYMax() + 60);
        } else {
            throw new RuntimeException("No such a UserInterface mode.");
        }
        this.mainFrame.setMinimumSize(new Dimension(600, 400));
        this.mainFrame.setSize(new Dimension(600, 400));
        this.mainFrame.setVisible(true);
    }

    private void Hs_and_Hc(int timeSpan, boolean traj) {
        float[] xData = new float[timeSpan];
        for (int t = 0; t < timeSpan; ++t) {
            xData[t] = t + 1;
        }
        float[][] hs = CABatch.getHsAndHc(this.caConfig, timeSpan);
        if (traj) {
            this.pxy.setGraphType("circle");
            this.pxy.setRange(0.0, 0.0, 1.0, 1.0);
            this.pxy.setXData(hs[1]);
            this.pxy.setYData(hs[0]);
            this.pxy.setTitle("Hc(X_axis) - Hs(Y_axis)");
            this.pxy.setColor(0, Color.red);
            this.pxy.setDecimal(1, 1);
        } else {
            this.pxy.setGraphType("line");
            this.pxy.setFont("time", 10);
            this.pxy.setRange(0.0, 0.0, timeSpan, 1.0);
            this.pxy.setXData(xData);
            this.pxy.setYData(hs);
            this.pxy.setTitle("Hs:red, Hc:blue");
            this.pxy.setColor(0, Color.red);
            this.pxy.setColor(1, Color.blue);
            this.pxy.setDecimal(0, 1);
        }
        this.pxy.repaint();
        this.cap.repaint();
        RawData rawData = new RawData(xData, hs);
    }

    private void getPopulation(int timeSpan) {
        int i;
        float[][] pop = new float[this.rule.getStatePerCell() - 1][timeSpan];
        float[] xData = new float[timeSpan];
        for (i = 0; i < timeSpan; ++i) {
            this.cap.getCAConfig().step();
            xData[i] = i + 1;
            for (int state = 1; state < this.rule.getStatePerCell(); ++state) {
                pop[state - 1][i] = this.cap.getCAConfig().getPopulation(state);
            }
        }
        this.pxy.resetRange();
        this.pxy.setGraphType("line");
        this.pxy.setFont("time", 10);
        this.pxy.setXData(xData);
        this.pxy.setYData(pop);
        this.pxy.setTitle("population");
        for (i = 1; i < this.rule.getStatePerCell(); ++i) {
            this.pxy.setColor(i - 1, this.cap.getStateColor(i));
        }
        this.pxy.setDecimal(0, 0);
        this.pxy.repaint();
        this.cap.repaint();
        RawData rawData = new RawData(xData, pop);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object clicked = e.getSource();
        String command = e.getActionCommand();
        if (command == "JPEG") {
            Calendar calendar = Calendar.getInstance();
            int week = calendar.get(3);
            int day = calendar.get(7);
            int hour = calendar.get(11);
            int min = calendar.get(12);
            int sec = calendar.get(13);
            String outFile = "j" + week + day + hour + min + sec + ".jpg";
            CAGraphics.saveJPEG(outFile, this.cap, this.mainFrame);
        } else if (command == "rule") {
            this.rule.edit();
        }
        Object obj = e.getSource();
        if (obj == this.startButton) {
            if (this.caRunner.isAlive()) {
                this.stopProcess();
            } else {
                this.startProcess();
            }
        } else if (obj == this.nextButton) {
            this.caConfig.step();
            this.cap.repaint();
        } else if (obj == this.quitButton) {
            System.exit(0);
        } else if (obj == this.initButton) {
            if (this.initDialog == null) {
                this.initDialog = new InitDialog(this.cap);
            } else {
                this.initDialog.setVisible(true);
            }
        } else if (obj == this.miscButton) {
            if (this.miscDialog == null) {
                this.miscDialog = new MiscDialog(this.caRunner);
            } else {
                this.miscDialog.setVisible(true);
            }
        }
    }

    private void stopProcess() {
        this.initButton.setEnabled(true);
        this.startButton.setLabel("start");
        this.nextButton.setEnabled(true);
        this.ruleButton.setEnabled(true);
        this.jpegButton.setEnabled(true);
        this.miscButton.setEnabled(true);
        this.quitButton.setEnabled(true);
        this.caRunner.stop();
    }

    private void startProcess() {
        this.cap.setVisible(false);
        this.cap.setSize();
        this.cap.setVisible(true);
        this.startButton.setLabel("stop");
        this.initButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.ruleButton.setEnabled(false);
        this.miscButton.setEnabled(false);
        this.jpegButton.setEnabled(false);
        this.quitButton.setEnabled(false);
        this.caRunner.start();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        this.mainFrame.setTitle("CADemo main display: time-series analysis going");
        this.mainFrame.setEnabled(false);
        if (this.entChoice == source) {
            if (e.getItem().toString() == "Hs and Hc  128") {
                this.Hs_and_Hc(128, false);
            } else if (e.getItem().toString() == "Hs and Hc 1024") {
                this.Hs_and_Hc(1024, false);
            } else if (e.getItem().toString() == "Hs and Hc 4096") {
                this.Hs_and_Hc(4096, false);
            } else if (e.getItem().toString() == "Hc  -  Hs  128") {
                this.Hs_and_Hc(128, true);
            } else if (e.getItem().toString() == "Hc  -  Hs 1024") {
                this.Hs_and_Hc(1024, true);
            } else if (e.getItem().toString() == "Hc  -  Hs 4096") {
                this.Hs_and_Hc(1024, true);
            } else if (e.getItem().toString() == "demograph  128") {
                this.getPopulation(128);
            } else if (e.getItem().toString() == "demograph 1024") {
                this.getPopulation(1024);
            } else if (e.getItem().toString() == "demograph 4096") {
                this.getPopulation(4096);
            } else if (e.getItem().toString() == "help info     ") {
                TimeSeriesHelp timeSeriesHelp = new TimeSeriesHelp();
            } else if (e.getItem().toString() != "Time-series   ") {
                throw new RuntimeException("No such choice item.");
            }
        } else {
            throw new RuntimeException("No such choice object.");
        }
        this.mainFrame.setEnabled(true);
        this.mainFrame.setTitle("CADemo main display");
    }

    private void createRuleButton() {
        this.ruleButton = new JButton("rule");
        this.ruleButton.setActionCommand("rule");
        this.ruleButton.addActionListener(this);
        this.runTimePanel.add(this.ruleButton);
    }

    static void saveJPEG(String fileName, Component con, Frame mainFrame) {
        if (fileName == null) {
            throw new IllegalArgumentException("filename is null");
        }
        Dimension size = con.getSize();
        Image image = mainFrame.createImage(size.height, size.width);
        if (image == null) {
            System.out.print("Image is null");
        }
        Graphics offg = image.getGraphics();
        con.paint(offg);
        File outFile = new File(fileName);
        try {
            FileOutputStream dataOut = new FileOutputStream(outFile);
            JpegEncoder jpg = new JpegEncoder(image, 100, dataOut);
            jpg.Compress();
            dataOut.close();
            System.out.println(outFile.getName() + " was strored in JPEG format." + System.getProperty("line.separator"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

